/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.line;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.MetricCode;
import org.jetbrains.annotations.NotNull;

public class LineLoginController
extends AbstractLoginer {
    private static final String TAG = "LineLoginController";
    private ILoginActionCallBack mMyCallBack;
    private static final String LINE_PKG_NAME = "jp.naver.line.android";

    public LineLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 4);
        this.mMyCallBack = callBack;
        ThirdPartyPlatformHelper.getInstance().getPlatform(7);
    }

    @Override
    public void openLoginWindow() {
        if (this.interceptLogin()) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.app_uninstall_ips), (Object[])new Object[]{"LINE"}), (int)0);
            return;
        }
        this.startLogin();
    }

    private boolean interceptLogin() {
        return !SystemUtils.isAppInstalled((String)LINE_PKG_NAME);
    }

    public void logout() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(7);
        if (adapter != null) {
            adapter.logout();
        }
    }

    private void startLogin() {
        MLog.info((Object)TAG, (String)"startLogin!", (Object[])new Object[0]);
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        this.authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                MLog.info((Object)LineLoginController.TAG, (String)"startLogin success!", (Object[])new Object[0]);
                if (result != null && result.authorizedData != null) {
                    LoginMetricHelper.reportToMetric((int)4, (String)"0");
                    LineLoginController.this.handleLoginResult(result);
                } else {
                    LineLoginController.this.handleLoginError("114", "");
                }
            }

            public void onCancel() {
                LineLoginController.this.handleLoginError("116", "");
            }

            public void onError(int errorCode, Exception e) {
                LineLoginController.this.handleLoginError("211", e != null ? e.getMessage() : "");
            }
        });
    }

    private void handleLoginResult(LoginSuccessResult result) {
        this.mMyCallBack.onLoginStart(this);
        String userid = result.authorizedData.userId;
        String tokenStr = result.authorizedData.tokenStr;
        String appId = result.authorizedData.appId;
        String mail = result.authorizedData.mail;
        MLog.info((Object)TAG, (String)"handleLoginResult!", (Object[])new Object[0]);
        final long startTime = System.currentTimeMillis();
        this.mMyCallBack.getLoginRequester().loginWithThirdParty(7, appId, tokenStr, userid, mail, new ILoginRequestCallBack(){

            public void onSuccess(LoginData data) {
                MLog.info((Object)LineLoginController.TAG, (String)"handleLoginResult success!", (Object[])new Object[0]);
                if (data == null) {
                    LineLoginController.this.handleLoginError("211", "get line userinfo error!");
                    return;
                }
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
                LoginData lineLoginData = data;
                AccountInfo accountInfo = AccountInfo.obtain((LoginData)lineLoginData);
                accountInfo.loginType = 4;
                if (LineLoginController.this.mLoginCallBack != null) {
                    LineLoginController.this.mLoginCallBack.onLoginSuccess(LineLoginController.this, accountInfo);
                }
            }

            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                LineLoginController.this.handleLoginError(errorCode, errorDescription);
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
            }
        });
    }

    private void handleLoginError(final String errorCode, final String des) {
        MLog.error((Object)TAG, (String)"login error:%s %s", (Object[])new Object[]{errorCode, des});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LineLoginController.this.mLoginCallBack != null) {
                    LineLoginController.this.mLoginCallBack.onLoginError(LineLoginController.this, errorCode, des);
                }
                LineLoginController.this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                LineLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
        });
    }

    @Override
    protected void authorization(final IThirdPartyAuthorizationCallBack callBack) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(7);
        if (adapter != null) {
            adapter.login(new ILoginCallBack(){

                public void onSuccess(@NotNull LoginSuccessResult result) {
                    if (result.authorizedData != null) {
                        if (callBack != null) {
                            callBack.onSuccess(result);
                        }
                    } else if (callBack != null) {
                        callBack.onError(-1, (Exception)new RuntimeException(""));
                        String metricCode = MetricCode.getSelfCode((String)"300");
                        LoginMetricHelper.reportToMetric((int)4, (String)metricCode);
                    }
                }

                public void onCancel() {
                    if (callBack != null) {
                        callBack.onCancel();
                    }
                }

                public void onError(@NotNull LoginErrorResult result) {
                    if (callBack != null) {
                        callBack.onError(result.errorCode, result.exception);
                        LoginMetricHelper.reportToMetric((int)4, (String)result.metricCode);
                    }
                }
            });
        }
    }

    @Override
    public int getSelectLoginType() {
        return 4;
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        UserInfoBean bean = new UserInfoBean();
        bean.setSex(-1);
        AbsPlatformAdapter lineAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(7);
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_GET_ACCOUNT_NICK;
        Object nick = lineAdapter.handleMessageSync(message);
        Message message2 = Message.obtain();
        message2.what = PlatformMsgDef.MSG_GET_ACCOUNT_AVATAR_URL;
        Object avatarUrl = lineAdapter.handleMessageSync(message2);
        if (nick instanceof String) {
            bean.setNick((String)nick);
        } else {
            nick = "";
        }
        if (avatarUrl instanceof String) {
            bean.setAvatar((String)avatarUrl);
        } else {
            avatarUrl = "";
        }
        if (callBack != null) {
            callBack.onSuccess(bean);
        }
    }
}

