/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.language;

import android.app.Dialog;
import android.os.Build;
import android.os.Message;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import androidx.annotation.RequiresApi;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.login.language.SelectLanguageView;
import com.yy.hiyo.login.language.YYOkCancelView;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;

public class LanguageSelectorController
extends DefaultWindowController {
    public LanguageSelectorController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.SHOW_CHANGED_LANGUAGE_DIALOG) {
            this.showSelectDialog();
        } else if (msg.what == BaseMsgDef.SHOW_CHANGED_LANGUAGE_DIALOG_DEBUG && Build.VERSION.SDK_INT >= 17) {
            this.debugChangeLanguage();
        }
    }

    private void showSelectDialog() {
        BaseDialog dialog = new BaseDialog(){
            private SelectLanguageView.LanguageType mLanguageType;

            public void init(Dialog dialog) {
                SelectLanguageView languageView = new SelectLanguageView(LanguageSelectorController.this.mContext);
                languageView.setLanguageSelectListener(type -> {
                    this.mLanguageType = type;
                });
                YYOkCancelView okCancelView = YYOkCancelView.newBuilder(LanguageSelectorController.this.getActivity(), () -> ((Dialog)dialog).dismiss()).title(R.string.short_tips_setting_language_title).contentView((View)languageView).isWithOk(true).isWithCancel(true).okText(R.string.short_tips_ok_reboot).isCancelable(true).onOk(new Runnable(){

                    @Override
                    public void run() {
                        if (mLanguageType != null && LanguageLocaleHelper.saveLanguage((String)mLanguageType.getLanguage())) {
                            LoginTrack.changeLanguageSelected(mLanguageType == SelectLanguageView.LanguageType.EN ? "1" : "2");
                            YYTaskExecutor.postToMainThread(() -> {
                                Message msg = Message.obtain();
                                msg.what = BaseMsgDef.APP_EXIT;
                                msg.obj = true;
                                LanguageSelectorController.this.sendMessageSync(msg);
                            }, (long)500L);
                        }
                    }
                }).build();
                dialog.setContentView((View)okCancelView);
            }

            public int getId() {
                return 0;
            }
        };
        this.mDialogLinkManager.showDialog(dialog);
    }

    @RequiresApi(api=17)
    private void debugChangeLanguage() {
        final RadioGroup group = new RadioGroup(RuntimeContext.sApplicationContext);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("en", "\u82f1\u8bed");
        map.put("ar", "\u963f\u62c9\u4f2f");
        map.put("es", "\u897f\u73ed\u7259");
        map.put("hi", "\u5370\u5730\u8bed");
        map.put("in", "\u5370\u5c3c");
        map.put("ja", "\u65e5\u672c");
        map.put("ko", "\u97e9\u56fd");
        map.put("ms", "\u9a6c\u6765");
        map.put("pt", "\u8461\u8404\u7259");
        map.put("ru", "\u4fc4\u8bed");
        map.put("th", "\u6cf0\u8bed");
        map.put("vi", "\u8d8a\u5357");
        map.put("zh", "\u4e2d\u6587");
        map.put("ur", "\u4e4c\u5c14\u90fd\u8bed");
        Set languages = map.keySet();
        String currentLanguage = Locale.getDefault().getLanguage();
        for (String language : languages) {
            RadioButton button = new RadioButton(RuntimeContext.sApplicationContext);
            button.setText((CharSequence)(language + "_" + (String)map.get(language)));
            button.setTextColor(-16777216);
            button.setTag((Object)language);
            button.setId(View.generateViewId());
            if (currentLanguage.equalsIgnoreCase(new Locale(language).getLanguage())) {
                button.setChecked(true);
            }
            group.addView((View)button);
        }
        group.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener(){

            public void onCheckedChanged(RadioGroup group, int checkedId) {
                RadioButton button = (RadioButton)group.findViewById(checkedId);
                button.setTextSize(16.0f);
                LanguageLocaleHelper.saveLanguage((String)("" + button.getTag()));
                YYTaskExecutor.postToMainThread(() -> {
                    Message msg = Message.obtain();
                    msg.what = BaseMsgDef.APP_EXIT;
                    msg.obj = true;
                    LanguageSelectorController.this.sendMessageSync(msg);
                }, (long)100L);
            }
        });
        this.mDialogLinkManager.showDialog(new BaseDialog(){

            public void init(Dialog dialog) {
                group.setBackgroundResource(R.drawable.dialog_background);
                dialog.setContentView((View)group, new ViewGroup.LayoutParams(ResolutionUtils.dip2Px((float)100.0f), -2));
            }

            public int getId() {
                return 0;
            }
        });
    }
}

