/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Keep;
import androidx.appcompat.widget.AppCompatImageView;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.login.bean.LoginSmallIconInfo;
import com.yy.hiyo.login.view.ILoginTypeView;
import com.yy.hiyo.login.view.LoginButtonInfoHelper;
import javax.annotation.Nonnull;

public class LoginSmallBtn
extends AppCompatImageView
implements ILoginTypeView<LoginSmallIconInfo> {
    private LoginSmallIconInfo mData;

    public static LoginSmallBtn create(LoginTypeData type) {
        LoginSmallBtn btn = new LoginSmallBtn(RuntimeContext.sApplicationContext);
        btn.setData(LoginButtonInfoHelper.createSmallBtnInfo(type));
        btn.setVisibility(type.isVisible() ? 0 : 8);
        if (type == LoginTypeData.PHONE) {
            btn.setContentDescription("login with phone");
        }
        return btn;
    }

    public LoginSmallBtn(Context context) {
        super(context);
        ClickScaleAnimProvider.apply((View)this);
    }

    public LoginSmallBtn(Context context, AttributeSet attrs) {
        super(context, attrs);
        ClickScaleAnimProvider.apply((View)this);
    }

    public LoginSmallBtn(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        ClickScaleAnimProvider.apply((View)this);
    }

    public static ViewGroup.MarginLayoutParams generateDefaultParams() {
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(ResolutionUtils.dip2Px((float)40.0f), ResolutionUtils.dip2Px((float)40.0f));
        int margin = ResolutionUtils.dip2Px((float)15.0f);
        params.setMargins(margin, 0, margin, 0);
        return params;
    }

    @Override
    public void setData(@Nonnull LoginSmallIconInfo data) {
        this.mData = data;
        this.setBackgroundResource(data.btnBackgroundResId);
    }

    @Override
    public LoginSmallIconInfo getData() {
        return this.mData;
    }

    @Keep
    public String toString() {
        return super.toString() + ", iconInfo " + this.mData;
    }
}

