/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.windows;

import android.app.Dialog;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.account.LoginTypeData;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.LoginSmallIconInfo;
import com.yy.hiyo.login.utils.LoginTypeContainerHelper;
import com.yy.hiyo.login.view.LoginSmallBtn;
import java.util.Collection;
import java.util.List;

public class OtherLoginDialog
implements BaseDialog,
View.OnClickListener {
    private String TAG = "OtherLoginDialog";
    private YYImageView mIvClose;
    private YYTextView mTvReturn;
    private YYTextView mTvContent;
    private YYTextView mTvTitle;
    private YYLinearLayout mLlLoginDialogWay;
    private IOtherLoginListener mOtherLoginListener;
    private boolean mIsShowReturn = false;
    private String mTitle;
    private String mContent;
    private int mDialogId = -1;
    private Dialog mDialog;
    private int mCurrentLoginType;
    private JLoginTypeInfo mLoginTypeInfo;

    public OtherLoginDialog(@NonNull JLoginTypeInfo loginTypeInfo, boolean isShowReturn, String title, String content, IOtherLoginListener otherLoginListener) {
        this.mLoginTypeInfo = loginTypeInfo;
        this.mIsShowReturn = isShowReturn;
        this.mTitle = title;
        this.mContent = content;
        this.mOtherLoginListener = otherLoginListener;
    }

    public void setCurrentLoginType(int currentLoginType) {
        this.mCurrentLoginType = currentLoginType;
    }

    private void bindLoginType() {
        MLog.debug((Object)this.TAG, (String)"bindLoginType", (Object[])new Object[0]);
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginSecondUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
        }
    }

    private void unbindLoginType() {
        MLog.debug((Object)this.TAG, (String)"unbindLoginType", (Object[])new Object[0]);
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginSecondUpdate");
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
        }
    }

    @KvoMethodAnnotation(name="totalTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginSecondUpdate(KvoEventIntent event) {
        this.showSecondLogin((List)event.newValue());
    }

    @KvoMethodAnnotation(name="updateTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginUpdateUpdate(KvoEventIntent event) {
        List updateList = (List)event.newValue();
        if (!FP.empty((Collection)updateList)) {
            for (LoginTypeData u : updateList) {
                this.updateLoginType(u);
            }
        }
    }

    private void findViews(final Dialog dialog, Window root, String title, String content) {
        this.mDialog = dialog;
        this.mIvClose = (YYImageView)root.findViewById(R.id.tv_login_dialog_close);
        this.mTvReturn = (YYTextView)root.findViewById(R.id.tv_login_return);
        this.mTvContent = (YYTextView)root.findViewById(R.id.tv_login_dialog_content);
        this.mTvTitle = (YYTextView)root.findViewById(R.id.tv_login_dialog_title);
        this.mLlLoginDialogWay = (YYLinearLayout)root.findViewById(R.id.ll_login_dialog_way);
        this.mTvContent.setText((CharSequence)content);
        this.mTvTitle.setText((CharSequence)title);
        LinearLayout.LayoutParams loginDialogWayParams = (LinearLayout.LayoutParams)this.mLlLoginDialogWay.getLayoutParams();
        if (this.mIsShowReturn) {
            loginDialogWayParams.bottomMargin = ResourceUtils.getDimen((int)R.dimen.login_other_way_dialog_return_bottom);
            this.mLlLoginDialogWay.setLayoutParams((ViewGroup.LayoutParams)loginDialogWayParams);
            this.mTvReturn.setVisibility(0);
        } else {
            loginDialogWayParams.bottomMargin = ResourceUtils.getDimen((int)R.dimen.login_other_way_dialog_bottom);
            this.mLlLoginDialogWay.setLayoutParams((ViewGroup.LayoutParams)loginDialogWayParams);
            this.mTvReturn.setVisibility(8);
        }
        this.mIvClose.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.dismiss();
            }
        });
        this.mTvReturn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (OtherLoginDialog.this.mOtherLoginListener != null) {
                    OtherLoginDialog.this.mOtherLoginListener.onOtherLoginBackClicked();
                }
                if (OtherLoginDialog.this.mDialog != null) {
                    OtherLoginDialog.this.mDialog.dismiss();
                }
            }
        });
        this.bindLoginType();
    }

    public void onClick(View v) {
        LoginSmallIconInfo smallIconInfo;
        if (v instanceof LoginSmallBtn && (smallIconInfo = ((LoginSmallBtn)v).getData()) != null && this.mOtherLoginListener != null) {
            this.mOtherLoginListener.onJump(smallIconInfo.loginType, 2);
        }
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
    }

    public void init(Dialog dialog) {
        dialog.setCancelable(true);
        dialog.setCanceledOnTouchOutside(true);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (OtherLoginDialog.this.mOtherLoginListener != null) {
                    OtherLoginDialog.this.mOtherLoginListener.onDismiss();
                }
                OtherLoginDialog.this.unbindLoginType();
            }
        });
        Window window = dialog.getWindow();
        if (window != null) {
            window.setContentView(R.layout.layout_login_dialog);
            this.findViews(dialog, window, this.mTitle, this.mContent);
            this.mDialogId = DialogId.OtherLoginDialog;
        }
    }

    public int getId() {
        return this.mDialogId;
    }

    private void showSecondLogin(List<LoginTypeData> secondTypeList) {
        if (secondTypeList != null) {
            YYLinearLayout container = this.mLlLoginDialogWay;
            container.removeAllViews();
            if (secondTypeList.size() > 0) {
                for (LoginTypeData loginType : secondTypeList) {
                    if (loginType == null || loginType.getType() == this.mCurrentLoginType || loginType == LoginTypeData.GUEST) continue;
                    LoginSmallBtn btn = LoginSmallBtn.create(loginType);
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(LoginSmallBtn.generateDefaultParams());
                    btn.setLayoutParams((ViewGroup.LayoutParams)lp);
                    btn.setOnClickListener(this);
                    container.addView((View)btn);
                }
            }
        }
    }

    private void updateLoginType(LoginTypeData loginType) {
        LoginTypeContainerHelper.updateLoginType((LinearLayout)this.mLlLoginDialogWay, loginType);
    }

    public static interface IOtherLoginListener {
        public void onJump(LoginTypeData var1, int var2);

        public void onOtherLoginBackClicked();

        public void onDismiss();
    }
}

