/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.request;

import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import androidx.collection.ArrayMap;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.constant.CommonPerfUtils;
import com.yy.appbase.data.LoginUpdateInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceUtil;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DES3Utils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.SHAUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Request;
import com.yy.grace.Response;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.account.PhoneLoginData;
import com.yy.hiyo.login.base.OnReportCallback;
import com.yy.hiyo.login.request.ILoginRequester;
import com.yy.hiyo.login.request.IQueryThirdPartyAccountCallBack;
import com.yy.hiyo.login.request.IQueryWhatsAppTokenCallback;
import com.yy.hiyo.login.request.IRequestSmsCodeCallBack;
import com.yy.hiyo.loginrequest.BaseLoginRequestManager;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.hiyo.loginrequest.LoginUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoginRequestManager
extends BaseLoginRequestManager
implements ILoginRequester {
    private static final String TAG = "LoginRequestManager";
    private static final String KEY_MOBILE = "mobile";
    private static final String KEY_COUNTRY_CODE = "country_code";
    private static final String KEY_OPER_TYPE = "oper_type";
    private static final String KEY_NONSTR = "nonstr";
    private static final String KEY_TIMESTAMP = "timestamp";
    private static final String KEY_SIGN = "sign";
    private static final String KEY_PWD_ORI = "password_origin";
    private static final String KEY_PWD = "password";
    private static final String KEY_OLD_PWD = "old_password";
    private static final String KEY_NEW_PWD = "new_password";
    private static final String KEY_CONFIRM_PWD = "confirm_password";
    private static final String KEY_SMS_SET_PWD = "set_password";
    private static final String KEY_SMS_CODE = "sms_code";
    private static final String KEY_WHATSAPP_TOKEN = "whatsapp_key";
    private final SparseArray<Map<String, String>> mLoginDatas = new SparseArray(5);
    private static int sLoginId = 1;

    public static LoginRequestManager getInstance() {
        return SingleHolder.INSTANCE;
    }

    private LoginRequestManager() {
    }

    @Override
    public void queryWhatsAppToken(String whatsAppToken, final IQueryWhatsAppTokenCallback callback) {
        WhatsAppTokenItem item = new WhatsAppTokenItem();
        item.whatsAppToken = whatsAppToken;
        item.url = UriProvider.LoginWhatsappRequest;
        if (callback != null) {
            item.callBack = new IQueryWhatsAppTokenCallback(){

                @Override
                public void onSuccess(final @NotNull String token) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(token);
                        }
                    });
                }

                @Override
                public void onError(final @NotNull String errorCode, final @Nullable Throwable exception) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onError(errorCode, exception);
                        }
                    });
                }
            };
        }
        item.maxRetryTimes = 2;
        item.curRetryTimes = 0;
        item.ipHost = UriProvider.LOGIN_IP_HOST;
        this.queryWhatsAppToken(item);
    }

    private void queryWhatsAppToken(final WhatsAppTokenItem item) {
        MLog.info((Object)TAG, (String)"queryWhatsAppToken url: %s, curTimes: %d, whatsappToken: %s", (Object[])new Object[]{item.url, item.curRetryTimes, item.whatsAppToken});
        String url = item.url;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_WHATSAPP_TOKEN, item.whatsAppToken + "");
        params.put("device_id", this.getDeviceId());
        params.put("dev_type", "11");
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        HashMap<String, String> headers = null;
        if (item.curUseIp) {
            headers = new HashMap<String, String>();
            headers.put("Host", item.ipHost);
        }
        GraceUtil.getGrace().newCall(new Request.Builder<String>(){}.url(url).method("POST", params).addHeader(headers).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("queryWhatsAppToken response: " + response), (Object[])new Object[0]);
                }
                String resultCode = null;
                String resultDesc = null;
                String token = "";
                try {
                    JSONObject json = JsonParser.obtainJSONObject((String)((String)response.body()));
                    resultCode = json.optString("result_code", "113");
                    resultDesc = json.optString("result_desc");
                    token = json.optString(LoginRequestManager.KEY_WHATSAPP_TOKEN, "");
                }
                catch (Exception ex) {
                    MLog.error((Object)LoginRequestManager.TAG, (String)"queryWhatsAppToken parse response error", (Throwable)ex, (Object[])new Object[0]);
                    resultCode = "112";
                }
                IQueryWhatsAppTokenCallback callback = item.callBack;
                if (StringUtils.equal((String)resultCode, (String)"00000")) {
                    if (callback != null) {
                        callback.onSuccess(token);
                    }
                } else if (callback != null) {
                    callback.onError(resultCode, new Exception(resultDesc));
                }
            }

            public void onFailure(Call<String> call, Throwable e) {
                if (item.curRetryTimes < item.maxRetryTimes) {
                    MLog.error((Object)LoginRequestManager.TAG, (String)"queryWhatsAppToken retry by error: ", (Throwable)e, (Object[])new Object[0]);
                    ++item.curRetryTimes;
                    LoginRequestManager.this.queryWhatsAppToken(item);
                } else {
                    MLog.error((Object)LoginRequestManager.TAG, (String)"queryWhatsAppToken error: ", (Throwable)e, (Object[])new Object[0]);
                    if (item.callBack != null) {
                        item.callBack.onError("111", e);
                    }
                }
            }
        });
    }

    @Override
    public void requestSmsCode(String phoneNum, String countryCode, String whatsAppToken, final IRequestSmsCodeCallBack callBack) {
        SmsRequestItem item = new SmsRequestItem();
        item.url = UriProvider.LoginSMSRequest;
        item.phoneNum = phoneNum;
        item.countryCode = countryCode;
        item.whatsAppToken = whatsAppToken;
        if (callBack != null) {
            item.callBack = new IRequestSmsCodeCallBack(){

                @Override
                public void onSuccess(final boolean sentWhatsapp) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(sentWhatsapp);
                        }
                    });
                }

                @Override
                public void onError(final String errorCode, final String errorDescription) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onError(errorCode, errorDescription);
                        }
                    });
                }
            };
        }
        item.maxRetryTimes = 2;
        item.curRetryTimes = 0;
        item.curUseIp = false;
        item.ipHost = UriProvider.LOGIN_IP_HOST;
        this.requestVerificationCode(item);
    }

    private void requestVerificationCode(final SmsRequestItem item) {
        String url = item.url;
        MLog.info((Object)TAG, (String)"url %s countryCode: %s phoneNum: %s whatsAppToken: %s", (Object[])new Object[]{url, item.countryCode, item.phoneNum, item.whatsAppToken});
        Map<String, String> params = this.createSmsCodeRequestParams(item.phoneNum, item.countryCode, item.whatsAppToken);
        ArrayMap headers = null;
        if (item.curUseIp) {
            headers = new ArrayMap();
            headers.put("Host", item.ipHost);
        }
        GraceUtil.post((String)url, params, (Map)headers, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("on requestVerificationCode response =" + response), (Object[])new Object[0]);
                }
                MLog.info((Object)LoginRequestManager.TAG, (String)"on requestVerificationCode url: %s", (Object[])new Object[]{item.url});
                LoginRequestManager.this.handleVerificationCodeCallBack((String)response.body(), item.callBack);
            }

            public void onFailure(Call<String> call, Throwable e) {
                if (item.curRetryTimes < item.maxRetryTimes) {
                    MLog.error((Object)"LoginRequestManager ", (String)"requestVerificationCode retry by error =", (Throwable)e, (Object[])new Object[0]);
                    ++item.curRetryTimes;
                    if (LoginRequestManager.this.canUseIp()) {
                        if (!item.curUseIp) {
                            item.curUseIp = true;
                            item.url = UriProvider.SMS_GET_IP_ONE;
                        } else {
                            item.curUseIp = true;
                            item.url = "http://47.52.230.226/uaas/sms/sendCode";
                        }
                    } else {
                        item.curUseIp = false;
                        item.url = UriProvider.LoginSMSRequest;
                    }
                    LoginRequestManager.this.requestVerificationCode(item);
                } else {
                    MLog.error((Object)"LoginRequestManager ", (String)"requestVerificationCode error =", (Throwable)e, (Object[])new Object[0]);
                    if (item.callBack != null) {
                        item.callBack.onError("111", "");
                    }
                }
            }
        });
    }

    @Override
    public void reportLocation(String location, String longitude, String latitude, final OnReportCallback callback) {
        final String url = UriProvider.LoginReportLocation;
        MLog.info((Object)TAG, (String)"url %s", (Object[])new Object[]{url});
        Map<String, String> param = this.createLocationParams(location, longitude, latitude);
        GraceUtil.getGrace().newCall(new Request.Builder<BaseResponseBean<LoginUpdateInfoBean>>(){}.url(url).method("POST", param).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<BaseResponseBean<LoginUpdateInfoBean>>(){

            public void onResponse(Call<BaseResponseBean<LoginUpdateInfoBean>> call, Response<BaseResponseBean<LoginUpdateInfoBean>> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("on reportLocation response =" + response), (Object[])new Object[0]);
                }
                if (callback != null) {
                    BaseResponseBean parseData = (BaseResponseBean)response.body();
                    if (parseData != null && parseData.code == 1) {
                        callback.onSuccess((LoginUpdateInfoBean)parseData.data);
                    } else {
                        callback.onError(-1, "code is " + (parseData != null ? Integer.valueOf(parseData.code) : "parseData is null"));
                    }
                }
            }

            public void onFailure(Call<BaseResponseBean<LoginUpdateInfoBean>> call, Throwable e) {
                MLog.info((Object)LoginRequestManager.TAG, (String)"on reportLocation %s error = %s", (Object[])new Object[]{url, e});
                if (callback != null) {
                    callback.onError(NetworkUtils.getErrorCodeByExc((Throwable)e), "" + e);
                }
            }
        });
    }

    @Override
    public void phoneLogin(String phoneNum, String countryCode, String smsCheckCode, ILoginRequestCallBack callBack) {
        this.phoneLogin(phoneNum, countryCode, smsCheckCode, null, callBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePhoneLogin(final PhoneLoginItem item) {
        String url = item.url;
        MLog.info((Object)TAG, (String)"url %s phoneNum %s countryCode %s smsCheckCode %s", (Object[])new Object[]{url, item.phoneNum, item.countryCode, item.smsCheckCode});
        Map<String, String> params = this.createLoginWithSmsCodeParams(item);
        SparseArray<Map<String, String>> sparseArray = this.mLoginDatas;
        synchronized (sparseArray) {
            this.mLoginDatas.put(sLoginId, params);
        }
        ArrayMap headers = null;
        if (item.curUseIp) {
            headers = new ArrayMap();
            headers.put("Host", item.ipHost);
        }
        GraceUtil.getGrace().newCall(new Request.Builder<String>(){}.url(url).method("POST", params).addHeader((Map)headers).group((Request.Group)BizScenc.NORMAL_LOGIN).tag(Integer.class, (Object)sLoginId).build()).enqueue((Callback)new Callback<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call<String> call, Response<String> response) {
                MLog.infoIfDebug((Object)LoginRequestManager.TAG, (String)("on loginWithVerificationCode response =" + response), (Object[])new Object[0]);
                MLog.info((Object)LoginRequestManager.TAG, (String)"on loginWithVerificationCode url: %s", (Object[])new Object[]{item.url});
                Map loginParams = null;
                SparseArray sparseArray = LoginRequestManager.this.mLoginDatas;
                synchronized (sparseArray) {
                    Integer id2 = (Integer)call.request().tag(Integer.class);
                    if (id2 != null) {
                        loginParams = (Map)LoginRequestManager.this.mLoginDatas.get(id2.intValue());
                        LoginRequestManager.this.mLoginDatas.remove(id2.intValue());
                    }
                }
                if (loginParams == null) {
                    return;
                }
                LoginRequestManager.this.handlePhoneLoginResult((String)response.body(), loginParams, item.callBack);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call<String> call, Throwable e) {
                if (item.curRetryTimes < item.maxRetryTimes) {
                    MLog.error((Object)LoginRequestManager.TAG, (String)"loginWithVerificationCode retry by error =", (Throwable)e, (Object[])new Object[0]);
                    ++item.curRetryTimes;
                    if (LoginRequestManager.this.canUseIp()) {
                        if (!item.curUseIp) {
                            item.curUseIp = true;
                            item.url = item.mode == 1 ? UriProvider.PHONE_LOGIN_PWD_IP_ONE : UriProvider.PHONE_LOGIN_IP_ONE;
                        } else {
                            item.curUseIp = true;
                            item.url = item.mode == 1 ? UriProvider.PHONE_LOGIN_PWD_IP_TWO : "http://47.52.230.226/uaas/login/smsAuth";
                        }
                    } else {
                        item.curUseIp = false;
                        item.url = item.mode == 1 ? UriProvider.LoginWithPwd : UriProvider.LoginWithSMSCode;
                    }
                    LoginRequestManager.this.handlePhoneLogin(item);
                } else {
                    MLog.error((Object)LoginRequestManager.TAG, (String)"loginWithVerificationCode error =", (Throwable)e, (Object[])new Object[0]);
                    SparseArray sparseArray = LoginRequestManager.this.mLoginDatas;
                    synchronized (sparseArray) {
                        Integer id2 = (Integer)call.request().tag(Integer.class);
                        if (id2 != null) {
                            LoginRequestManager.this.mLoginDatas.remove(id2.intValue());
                        }
                    }
                    if (item.callBack != null) {
                        item.callBack.onError("111", "" + e, "" + e);
                    }
                }
            }
        });
        ++sLoginId;
    }

    @Override
    public void phoneLogin(final String phoneNum, final String countryCode, final String smsCheckCode, final String password, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PhoneLoginItem item = new PhoneLoginItem();
                item.url = UriProvider.LoginWithSMSCode;
                item.listenCallBack(callBack);
                item.phoneNum = phoneNum;
                if (StringUtils.isNotEmpty((String)password)) {
                    item.passwordOri = password;
                    item.mode = 2;
                } else {
                    item.mode = 0;
                }
                item.countryCode = countryCode;
                item.smsCheckCode = smsCheckCode;
                LoginRequestManager.this.handlePhoneLogin(item);
            }
        });
    }

    @Override
    public void phoneLoginWithHashPwd(final String phoneNum, final String countryCode, final String passwordHash, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PhoneLoginItem item = new PhoneLoginItem();
                item.url = UriProvider.LoginWithPwd;
                item.listenCallBack(callBack);
                item.phoneNum = phoneNum;
                if (StringUtils.isNotEmpty((String)passwordHash)) {
                    item.passwordHash = passwordHash;
                }
                item.countryCode = countryCode;
                item.mode = 1;
                LoginRequestManager.this.handlePhoneLogin(item);
            }
        });
    }

    @Override
    public void phoneLoginWithPwd(final String phoneNum, final String countryCode, final String password, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PhoneLoginItem item = new PhoneLoginItem();
                item.url = UriProvider.LoginWithPwd;
                item.listenCallBack(callBack);
                item.phoneNum = phoneNum;
                if (StringUtils.isNotEmpty((String)password)) {
                    item.passwordOri = password;
                }
                item.countryCode = countryCode;
                item.mode = 1;
                LoginRequestManager.this.handlePhoneLogin(item);
            }
        });
    }

    @Override
    public void setLoginPassword(final String smsCheckCode, final String password, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PasswordSetItem item = new PasswordSetItem();
                item.url = UriProvider.LoginSetPwd;
                item.listenCallBack(callBack);
                item.smsCheckCode = smsCheckCode;
                item.passwordOri = password;
                AccountInfo info = AccountModel.getInstance().getAccountInfo();
                if (info != null) {
                    item.sessionKey = info.sessionKey;
                }
                LoginRequestManager.this.handleLoginPasswordUpdate(item);
            }
        });
    }

    @Override
    public void resetLoginPassword(final String originPwd, final String newPwd, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PasswordSetItem item = new PasswordSetItem();
                item.url = UriProvider.LoginResetPwd;
                item.listenCallBack(callBack);
                item.oldPassword = originPwd;
                item.passwordOri = newPwd;
                AccountInfo info = AccountModel.getInstance().getAccountInfo();
                if (info != null) {
                    item.sessionKey = info.sessionKey;
                }
                LoginRequestManager.this.handleLoginPasswordUpdate(item);
            }
        });
    }

    private void handleLoginPasswordUpdate(final PasswordSetItem item) {
        final String url = item.url;
        Map<String, String> params = this.createSetPasswordParams(item);
        ArrayMap headers = null;
        if (item.curUseIp) {
            headers = new ArrayMap();
            headers.put("Host", item.ipHost);
        }
        GraceUtil.post((String)url, params, (Map)headers, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("handleLoginPasswordUpdate response =" + response), (Object[])new Object[0]);
                }
                MLog.info((Object)LoginRequestManager.TAG, (String)"handleLoginPasswordUpdate onResponse url: %s ", (Object[])new Object[]{item.url});
                YYTaskExecutor.execute(() -> {
                    String resultCode = LoginRequestManager.this.handleLoginTokenDatasInner((String)response.body(), item2.sessionKey, item2.callBack);
                    boolean result = "0000".equals(resultCode);
                    CommonPerfUtils.statLoginEvent((int)3, (boolean)result, (int)item2.curRetryTimes, (String)(result ? "" : "parse data error:" + resultCode), (int)-1, (String)url, (String)String.valueOf(resultCode));
                    if (!result && RuntimeContext.sIsDebuggable) {
                        MLog.error((Object)LoginRequestManager.TAG, (String)"handleLoginPasswordUpdate sessionKey: %s, password: %s, sms: %s", (Object[])new Object[]{item2.sessionKey, item2.confirmPassword, item2.smsCheckCode});
                    }
                });
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    if (item2.curRetryTimes < item2.maxRetryTimes && !RuntimeContext.sIsDebuggable) {
                        MLog.error((Object)LoginRequestManager.TAG, (String)"handleLoginPasswordUpdate retry by error =", (Throwable)e, (Object[])new Object[0]);
                        ++item2.curRetryTimes;
                        LoginRequestManager.this.handleLoginPasswordUpdate(item);
                    } else {
                        MLog.error((Object)LoginRequestManager.TAG, (String)"handleLoginPasswordUpdate error =", (Throwable)e, (Object[])new Object[0]);
                        if (item2.callBack != null) {
                            item2.callBack.onError("111", "", "" + e);
                            CommonPerfUtils.statLoginEvent((int)3, (boolean)false, (int)item2.curRetryTimes, (String)(e != null ? e.toString() : ""), (int)-1, (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void bingThirdParty(AccountInfo accountInfo, int platformId, String appIdFromPlatform, String token, String userId, String mail, final ILoginRequestCallBack callBack) {
        final ILoginRequestCallBack actualCallback = callBack != null ? new ILoginRequestCallBack(){

            public void onSuccess(final LoginData data) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onSuccess(data);
                    }
                });
            }

            public void onError(final String errorCode, final String errorDescription, final String exceptionDue) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onError(errorCode, errorDescription, exceptionDue);
                    }
                });
            }
        } : null;
        String url = UriProvider.LoginBindThirdPlatform;
        final String sessionSecret = SHAUtils.getSHA256((String)userId);
        Map<String, String> params = this.createBindThirdParty(accountInfo, platformId, appIdFromPlatform, token, userId, mail, sessionSecret);
        GraceUtil.post((String)url, params, null, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                YYTaskExecutor.execute(() -> {
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)LoginRequestManager.TAG, (String)("login thirdpartyresponse =" + response), (Object[])new Object[0]);
                    }
                    LoginRequestManager.this.handleLoginTokenDatasInner((String)response.body(), sessionSecret, actualCallback);
                });
            }

            public void onFailure(Call<String> call, Throwable e) {
                MLog.info((Object)LoginRequestManager.TAG, (String)("login thirdparty error =" + e), (Object[])new Object[0]);
                if (actualCallback != null) {
                    actualCallback.onError("111", e != null ? e.toString() : "", "" + e);
                }
            }
        });
    }

    @Override
    public void queryThirdParty(AccountInfo accountInfo, final IQueryThirdPartyAccountCallBack callBack) {
        final IQueryThirdPartyAccountCallBack actualCallback = callBack != null ? new IQueryThirdPartyAccountCallBack(){

            @Override
            public void onSuccess(final SparseArray<String> thirdPartyUserId) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onSuccess((SparseArray<String>)thirdPartyUserId);
                    }
                });
            }

            @Override
            public void onError(final String errorCode, final Throwable e) {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callBack.onError(errorCode, e);
                    }
                });
            }
        } : null;
        if (accountInfo == null) {
            if (actualCallback != null) {
                actualCallback.onError("118", new RuntimeException());
            }
            return;
        }
        String url = UriProvider.LoginQueryThirdPlatform;
        Map<String, String> params = this.createQueryThirdPartyBindParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey);
        GraceUtil.post((String)url, params, null, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                YYTaskExecutor.execute(() -> {
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)LoginRequestManager.TAG, (String)("query thirdpartyresponse =" + response), (Object[])new Object[0]);
                    }
                    LoginRequestManager.this.handleQueryThirdPartyAccountCallBack((String)response.body(), actualCallback);
                });
            }

            public void onFailure(Call<String> call, Throwable e) {
                MLog.info((Object)LoginRequestManager.TAG, (String)("bind thirdparty error =" + e), (Object[])new Object[0]);
                if (actualCallback != null) {
                    actualCallback.onError("111", e);
                }
            }
        });
    }

    private void handleVerificationCodeCallBack(String response, IRequestSmsCodeCallBack callBack) {
        String resultCode = null;
        String resultDescrip = null;
        boolean sentWhatsapp = false;
        JSONObject jsonObject = null;
        try {
            jsonObject = JsonParser.obtainJSONObject((String)response);
            if (jsonObject.has("result_code")) {
                resultCode = jsonObject.getString("result_code");
            }
            if (jsonObject.has("result_desc")) {
                resultDescrip = jsonObject.getString("result_desc");
            }
            sentWhatsapp = jsonObject.optBoolean("send_wa", false);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            resultCode = "112";
            resultDescrip = null;
        }
        if (resultCode != null && resultCode.equals("00000")) {
            if (callBack != null) {
                callBack.onSuccess(sentWhatsapp);
            }
        } else {
            if (resultCode != null && resultCode.equals("20103")) {
                resultCode = "119";
            } else if (resultCode != null && resultCode.equals("20004")) {
                resultCode = "200";
            }
            if (callBack != null) {
                callBack.onError(resultCode, resultDescrip);
            }
            MLog.error((Object)TAG, (String)"VerificationCodeCallBack %s, %s ", (Object[])new Object[]{resultCode, resultDescrip});
        }
    }

    @Override
    public void loginGuest(final ILoginRequestCallBack callBack) {
        ILoginRequestCallBack actualCallBack = null;
        if (callBack != null) {
            actualCallBack = new ILoginRequestCallBack(){

                public void onSuccess(final LoginData data) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(data);
                        }
                    });
                }

                public void onError(final String errorCode, final String errorDescription, final String exceptionDue) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onError(errorCode, errorDescription, exceptionDue);
                        }
                    });
                }
            };
        }
        this.loginGuestInner(actualCallBack, 0, 1, SystemClock.elapsedRealtime());
    }

    private void loginGuestInner(final ILoginRequestCallBack callBack, final int retryTimes, final int maxRetryTimes, final long startTime) {
        final String url = UriProvider.LoginGuestAuth;
        final String sessionSecret = SHAUtils.getSHA256((String)this.getDeviceId());
        Map<String, String> params = this.createLoginGuestParams();
        GraceUtil.post((String)url, params, null, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("login guest =" + response), (Object[])new Object[0]);
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String body = (String)response.body();
                    String resultCode = LoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, callBack);
                    boolean result = "0000".equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - startTime);
                    String string2 = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)2, (boolean)result, (int)retryTimes, (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    if (maxRetryTimes > retryTimes) {
                        LoginRequestManager.this.loginGuestInner(callBack, retryTimes + 1, maxRetryTimes, startTime);
                    } else if (LoginRequestManager.this.canUseIp()) {
                        MLog.error((Object)LoginRequestManager.TAG, (String)"use ip by login guest error =", (Throwable)e, (Object[])new Object[0]);
                        LoginRequestManager.this.loginWithGuestByIp(UriProvider.GUEST_LOGIN_IP_ONE, callBack, 0, 1, startTime);
                    } else {
                        String curError;
                        MLog.error((Object)LoginRequestManager.TAG, (String)"login guest error =", (Throwable)e, (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError("111", "", "" + e);
                        }
                        String string2 = curError = e != null ? e.toString() : "";
                        if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                            curError = curError.substring(0, 200);
                        }
                        CommonPerfUtils.statLoginEvent((int)2, (boolean)false, (int)retryTimes, (String)curError, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                    }
                });
            }
        });
    }

    private void loginWithGuestByIp(final String url, final ILoginRequestCallBack callBack, final int retryTimes, final int maxRetryTimes, final long startTime) {
        final String sessionSecret = SHAUtils.getSHA256((String)this.getDeviceId());
        Map<String, String> params = this.createLoginGuestParams();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", UriProvider.LOGIN_IP_HOST);
        GraceUtil.post((String)url, params, headers, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)LoginRequestManager.TAG, (String)("use ip login guest =" + response), (Object[])new Object[0]);
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String body = (String)response.body();
                    String resultCode = LoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, callBack);
                    boolean result = "0000".equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - startTime);
                    String string2 = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)2, (boolean)result, (int)retryTimes, (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    if (maxRetryTimes > retryTimes && LoginRequestManager.this.canUseIp()) {
                        MLog.error((Object)LoginRequestManager.TAG, (String)"will retry by login guest error =", (Throwable)e, (Object[])new Object[0]);
                        LoginRequestManager.this.loginWithGuestByIp("http://47.52.230.226/uaas/login/guestAuth", callBack, retryTimes + 1, maxRetryTimes, startTime);
                    } else {
                        String curError;
                        MLog.error((Object)LoginRequestManager.TAG, (String)"use ip login guest error =", (Throwable)e, (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError("111", "", "" + e);
                        }
                        String string2 = curError = e != null ? e.toString() : "";
                        if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                            curError = curError.substring(0, 200);
                        }
                        CommonPerfUtils.statLoginEvent((int)2, (boolean)false, (int)retryTimes, (String)curError, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                    }
                });
            }
        });
    }

    private void handlePhoneLoginResult(String response, Map<String, String> requestParams, final ILoginRequestCallBack callBack) {
        String resultCode = null;
        String resultDesc = null;
        if (requestParams == null || requestParams.size() <= 0) {
            resultCode = "115";
            resultDesc = "";
            if (callBack != null) {
                callBack.onError(resultCode, resultDesc, resultDesc);
            }
        } else {
            final String phoneNumFull = requestParams.get(KEY_MOBILE);
            final String countryCode = requestParams.get(KEY_COUNTRY_CODE);
            String smsCode = requestParams.get(KEY_SMS_CODE);
            String pSha = requestParams.get(KEY_PWD);
            final String password = requestParams.get(KEY_PWD_ORI);
            final String passwordSha = StringUtils.isEmpty((String)pSha) ? requestParams.get(KEY_CONFIRM_PWD) : pSha;
            String smsCodeSecret = !StringUtils.isEmpty((String)smsCode) ? SHAUtils.getSHA256((String)smsCode) : SHAUtils.getSHA256((String)passwordSha);
            this.handleLoginTokenDatasInner(response, smsCodeSecret, true, new ILoginRequestCallBack(){

                public void onSuccess(LoginData data) {
                    PhoneLoginData loginItem = new PhoneLoginData(data);
                    loginItem.passwordSha = passwordSha;
                    loginItem.password = password;
                    loginItem.countryCode = countryCode;
                    loginItem.phoneNumFull = phoneNumFull;
                    if (StringUtils.isNotEmpty((String)passwordSha)) {
                        loginItem.hasPhonePwd = true;
                    }
                    if (callBack != null) {
                        callBack.onSuccess((LoginData)loginItem);
                    }
                }

                public void onError(String errorCode, String errorDescription, String exceptionDue) {
                    if (callBack != null) {
                        callBack.onError(errorCode, errorDescription, exceptionDue);
                    }
                    MLog.error((Object)LoginRequestManager.TAG, (String)"errorCode:%s des:%s", (Object[])new Object[]{errorCode, errorDescription});
                }
            });
        }
    }

    private void handleQueryThirdPartyAccountCallBack(String response, IQueryThirdPartyAccountCallBack callBack) {
        String resultCode = null;
        String resultDesc = null;
        JSONObject jsonObject = null;
        JSONArray bindInfo = null;
        SparseArray items = new SparseArray(1);
        try {
            jsonObject = JsonParser.obtainJSONObject((String)response);
            if (jsonObject.has("result_code")) {
                resultCode = jsonObject.getString("result_code");
            }
            if (jsonObject.has("result_desc")) {
                resultDesc = jsonObject.getString("result_desc");
            }
            if (jsonObject.has("bind_info")) {
                bindInfo = jsonObject.optJSONArray("bind_info");
            }
            if (bindInfo != null) {
                JSONObject itemJson = null;
                int size = bindInfo.length();
                int openSource = -1;
                String userId = "";
                for (int i = 0; i < size; ++i) {
                    itemJson = bindInfo.optJSONObject(i);
                    if (itemJson == null || !itemJson.has("open_source")) continue;
                    openSource = itemJson.getInt("open_source");
                    if (!itemJson.has("open_id") || !StringUtils.isNotEmpty((String)(userId = itemJson.getString("open_id")))) continue;
                    items.put(openSource, (Object)userId);
                }
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            resultCode = "112";
            resultDesc = null;
        }
        if (resultCode != null && (resultCode.equals("00000") || resultCode.equals("20414"))) {
            if (callBack != null) {
                callBack.onSuccess((SparseArray<String>)items);
            }
        } else {
            if (callBack != null) {
                callBack.onError(resultCode, new Exception());
            }
            MLog.error((Object)TAG, (String)"VerificationCodeCallBack %s, %s ", (Object[])new Object[]{resultCode, resultDesc});
        }
    }

    private String getSmsSequenceId() {
        return "sms" + System.currentTimeMillis();
    }

    private Map<String, String> createSmsCodeRequestParams(String phoneNum, String countryCode, String whatsAppToken) {
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String randomStr = curTimeStr + "2333";
        String phoneNumFull = countryCode + phoneNum;
        String operType = "0";
        StringBuilder strBuild = new StringBuilder();
        strBuild.append(KEY_NONSTR).append("=").append(randomStr).append("&").append(KEY_TIMESTAMP).append("=").append(curTimeStr).append("&").append(KEY_MOBILE).append("=").append(phoneNumFull).append("&").append(KEY_OPER_TYPE).append("=").append(operType).append("&").append(KEY_COUNTRY_CODE).append("=").append(countryCode);
        String sign = strBuild.toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_MOBILE, phoneNumFull);
        params.put(KEY_COUNTRY_CODE, countryCode);
        params.put(KEY_WHATSAPP_TOKEN, whatsAppToken);
        params.put(KEY_OPER_TYPE, operType);
        params.put(KEY_NONSTR, randomStr);
        params.put(KEY_TIMESTAMP, curTimeStr);
        params.put(KEY_SIGN, SHAUtils.getSHA256((String)sign));
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        return params;
    }

    private Map<String, String> createSetPasswordParams(PasswordSetItem passwordSetItem) {
        ArrayMap params = new ArrayMap();
        if (passwordSetItem.smsCheckCode != null) {
            params.put(KEY_SMS_CODE, passwordSetItem.smsCheckCode);
            if (StringUtils.isNotEmpty((String)passwordSetItem.passwordOri)) {
                passwordSetItem.confirmPassword = SHAUtils.getSHA256((String)passwordSetItem.passwordOri);
                params.put(KEY_PWD, passwordSetItem.confirmPassword);
            }
            MLog.infoIfDebug((Object)TAG, (String)"createSetPasswordParams smsCode: %s, password: %s, passwordSha: %s", (Object[])new Object[]{passwordSetItem.smsCheckCode, passwordSetItem.passwordOri, passwordSetItem.confirmPassword});
        } else {
            if (StringUtils.isNotEmpty((String)passwordSetItem.oldPassword)) {
                params.put(KEY_OLD_PWD, SHAUtils.getSHA256((String)passwordSetItem.oldPassword));
            }
            if (StringUtils.isNotEmpty((String)passwordSetItem.passwordOri)) {
                passwordSetItem.confirmPassword = SHAUtils.getSHA256((String)passwordSetItem.passwordOri);
                params.put(KEY_NEW_PWD, passwordSetItem.confirmPassword);
                params.put(KEY_CONFIRM_PWD, passwordSetItem.confirmPassword);
            }
            MLog.infoIfDebug((Object)TAG, (String)"createSetPasswordParams old: %s, confirm: %s", (Object[])new Object[]{passwordSetItem.oldPassword, passwordSetItem.confirmPassword});
        }
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo != null && accountInfo.isValid()) {
            BaseLoginRequestManager.ClientToken token = this.getClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey);
            if (token == null) {
                return null;
            }
            params.put("s_t", token.st);
            params.put("c_auth", token.auth);
            MLog.info((Object)TAG, (String)"createLoginWithSmsCodeParams s_t: %s, c_auth:%s", (Object[])new Object[]{token.st, token.auth});
        }
        return params;
    }

    private Map<String, String> createLoginWithSmsCodeParams(PhoneLoginItem phoneLoginItem) {
        BaseLoginRequestManager.ClientToken clientToken;
        String smsCode;
        ArrayMap params = new ArrayMap();
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String phoneNumFull = phoneLoginItem.countryCode + phoneLoginItem.phoneNum;
        String deviceId = this.getDeviceId();
        String desSecret = null;
        String pwd = phoneLoginItem.passwordOri;
        String pwdSecret = phoneLoginItem.passwordHash;
        if (StringUtils.isEmpty((String)pwdSecret) && StringUtils.isNotEmpty((String)pwd)) {
            phoneLoginItem.passwordHash = pwdSecret = SHAUtils.getSHA256((String)pwd);
        }
        if (StringUtils.isNotEmpty((String)pwdSecret)) {
            params.put(KEY_PWD, pwdSecret);
            params.put(KEY_SMS_SET_PWD, "1");
            desSecret = SHAUtils.getSHA256((String)pwdSecret);
        }
        if (StringUtils.isNotEmpty((String)(smsCode = phoneLoginItem.smsCheckCode))) {
            params.put(KEY_SMS_CODE, smsCode);
            desSecret = SHAUtils.getSHA256((String)smsCode);
        }
        MLog.infoIfDebug((Object)TAG, (String)"create login param pwd: %s, pwdHash: %s, smsCode: %s, secret: %s", (Object[])new Object[]{pwd, pwdSecret, smsCode, desSecret});
        params.put(KEY_MOBILE, phoneNumFull);
        params.put(KEY_COUNTRY_CODE, phoneLoginItem.countryCode);
        params.put("device_id", deviceId);
        params.put("dev_type", "11");
        params.put(KEY_TIMESTAMP, curTimeStr);
        String curTimeStrDES3 = "";
        if (desSecret != null) {
            try {
                curTimeStrDES3 = DES3Utils.encrypt((String)curTimeStr, (String)desSecret);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        params.put("ts", curTimeStrDES3);
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        LoginUtil.initCountryCodeParam((Map)params);
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo != null && accountInfo.isValid() && accountInfo.loginType == 10 && (clientToken = this.getClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey)) != null) {
            params.put("guest_s_t", clientToken.st);
            params.put("guest_c_auth", clientToken.auth);
            MLog.info((Object)TAG, (String)"createLoginWithSmsCodeParams s_t:%s, c_auth:%s", (Object[])new Object[]{clientToken.st, clientToken.auth});
        }
        return params;
    }

    private Map<String, String> createLocationParams(String locationStr, String longitude, String latitude) {
        HashMap<String, String> params = new HashMap<String, String>(2);
        if (locationStr == null) {
            locationStr = "";
        }
        if (latitude == null) {
            latitude = "";
        }
        if (longitude == null) {
            longitude = "";
        }
        Gson gson = new Gson();
        Location locationOb = new Location(locationStr, longitude, latitude);
        String json = "";
        try {
            json = gson.toJson((Object)locationOb);
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        params.put("data", json);
        return params;
    }

    private Map<String, String> createBindThirdParty(AccountInfo accountInfo, int platformId, String appIdFromPlatform, String token, String userId, String mail, String secretKey) {
        HashMap<String, String> params = new HashMap<String, String>(14);
        if (StringUtils.isEmpty((String)token) || accountInfo == null) {
            return params;
        }
        String openSecretKey = secretKey;
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String ts = "";
        try {
            ts = DES3Utils.encrypt((String)curTimeStr, (String)openSecretKey);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        params.put("ts", ts);
        params.put("open_id", userId != null ? userId : "");
        if (StringUtils.isNotEmpty((String)mail)) {
            params.put("mail", mail);
        }
        params.put("open_source", String.valueOf(platformId));
        params.put("access_token", token);
        params.put("open_key", appIdFromPlatform);
        params.put("device_id", this.getDeviceId());
        params.put("dev_type", "11");
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        BaseLoginRequestManager.ClientToken clientToken = this.getClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey);
        if (clientToken != null) {
            params.put("s_t", clientToken.st);
            params.put("c_auth", clientToken.auth);
        }
        return params;
    }

    private Map<String, String> createQueryThirdPartyBindParams(long uuid, String token, String sessionKey) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isEmpty((String)token)) {
            return params;
        }
        BaseLoginRequestManager.ClientToken clientToken = this.getClientTokenParams(uuid, token, sessionKey);
        if (clientToken != null) {
            params.put("s_t", clientToken.st);
            params.put("c_auth", clientToken.auth);
        }
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        return params;
    }

    private Map<String, String> createLoginGuestParams() {
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String deviceId = this.getDeviceId();
        String desSecret = SHAUtils.getSHA256((String)deviceId);
        String curTimeStrDES3 = "";
        try {
            curTimeStrDES3 = DES3Utils.encrypt((String)curTimeStr, (String)desSecret);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        String ts = curTimeStrDES3;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ts", ts);
        params.put("device_id", deviceId);
        params.put("dev_type", "11");
        params.put(KEY_TIMESTAMP, curTimeStr);
        params.put("appId", "ikxd");
        params.put("app", "olaparty");
        LoginUtil.initCountryCodeParam(params);
        return params;
    }

    @Override
    public void reportLoginAuth(AbstractLoginer loginer, AccountInfo accountInfo) {
        String url = UriProvider.LoginOlaPartyAuthApp;
        HashMap<String, String> params = new HashMap<String, String>();
        BaseLoginRequestManager.ClientToken token = this.getLoginAuthClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey);
        if (token == null) {
            MLog.error((Object)TAG, (String)"reportLoginAuth token is null", (Object[])new Object[0]);
            return;
        }
        params.put("appId", "ikxd");
        params.put("c_auth", token.auth);
        params.put("s_t", token.st);
        params.put("app", "hago");
        GraceUtil.post((String)url, params, null, (Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                MLog.info((Object)LoginRequestManager.TAG, (String)"reportLoginAuth success", (Object[])new Object[0]);
            }

            public void onFailure(Call<String> call, Throwable e) {
                MLog.error((Object)LoginRequestManager.TAG, (String)("reportLoginAuth error : " + e.toString()), (Object[])new Object[0]);
            }
        });
    }

    private BaseLoginRequestManager.ClientToken getLoginAuthClientTokenParams(long uuid, String token, String sessionKey) {
        String tokenDecode = null;
        try {
            tokenDecode = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (StringUtils.isEmpty((String)tokenDecode)) {
            return null;
        }
        String[] tokenDatas = tokenDecode.split(",");
        if (tokenDatas.length < 2) {
            return null;
        }
        String clientToken = null;
        BaseLoginRequestManager.ClientToken clientTokenData = new BaseLoginRequestManager.ClientToken();
        JSONObject tokenJoson = JsonParser.obtainJSONObject();
        try {
            long time = System.currentTimeMillis();
            tokenJoson.put("uuid", uuid);
            tokenJoson.put(KEY_TIMESTAMP, time);
            String clientJosn = tokenJoson.toString();
            clientTokenData.uuid = uuid;
            clientTokenData.time = time;
            clientTokenData.clientJosn = clientJosn;
            clientTokenData.sessionKey = sessionKey;
            try {
                clientToken = DES3Utils.encrypt((String)clientJosn, (String)sessionKey);
            }
            catch (UnsupportedEncodingException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        clientTokenData.st = tokenDatas[1];
        clientTokenData.auth = clientToken;
        return clientTokenData;
    }

    private static class WhatsAppTokenItem
    extends BaseLoginRequestManager.BasicItem {
        String whatsAppToken;
        IQueryWhatsAppTokenCallback callBack;

        private WhatsAppTokenItem() {
        }
    }

    private static class PasswordSetItem
    extends BaseLoginRequestManager.BasicLoginItem {
        String smsCheckCode;
        String oldPassword;
        String confirmPassword;
        String passwordOri;
        String sessionKey;

        PasswordSetItem() {
            this.maxRetryTimes = 2;
            this.curRetryTimes = 0;
            this.curUseIp = false;
            this.ipHost = UriProvider.LOGIN_IP_HOST;
        }

        protected LoginData packData(LoginData data) {
            PhoneLoginData phoneLoginData = new PhoneLoginData(data);
            phoneLoginData.password = this.passwordOri;
            phoneLoginData.passwordSha = this.confirmPassword;
            return phoneLoginData;
        }
    }

    private static class PhoneLoginItem
    extends BaseLoginRequestManager.BasicLoginItem {
        public static final int MODE_SMS = 0;
        public static final int MODE_PWD = 1;
        public static final int MODE_SMS_PWD = 2;
        String phoneNum;
        String countryCode;
        String smsCheckCode;
        String passwordOri;
        String passwordHash;
        int mode;

        PhoneLoginItem() {
            this.maxRetryTimes = 2;
            this.curRetryTimes = 0;
            this.curUseIp = false;
            this.ipHost = UriProvider.LOGIN_IP_HOST;
        }
    }

    private static class SmsRequestItem
    extends BaseLoginRequestManager.BasicItem {
        String phoneNum;
        String countryCode;
        String whatsAppToken;
        IRequestSmsCodeCallBack callBack;

        private SmsRequestItem() {
        }
    }

    @DontProguardClass
    private static class Location {
        private static final String SPLIT = "_";
        @SerializedName(value="location")
        public String location;
        @SerializedName(value="location_tude")
        public String mLocationTude;

        Location(String locationStr, String longitude, String latitude) {
            this.location = locationStr;
            if (longitude == null) {
                longitude = "";
            }
            if (latitude == null) {
                latitude = "";
            }
            this.mLocationTude = TextUtils.isEmpty((CharSequence)longitude) && TextUtils.isEmpty((CharSequence)latitude) ? "" : longitude + SPLIT + latitude;
        }
    }

    private static final class SingleHolder {
        private static final LoginRequestManager INSTANCE = new LoginRequestManager();

        private SingleHolder() {
        }
    }
}

