/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.hint;

import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.common.Callback;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.login.LoginTrack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.ISmsCallback;
import com.yy.socialplatformbase.data.SmsRetriever;
import java.util.regex.Pattern;

public final class HagoSmsRetriever {
    private static final String TAG = "FTLogin HagoSmsRetriever";
    private static final int MIN_CODE_LENGTH = 4;
    private Pattern mPattern = Pattern.compile("\\d{4,8}");
    private Callback<String> mSmsCodeListener;
    private SmsRetriever smsRetriever;

    public HagoSmsRetriever() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_CREATE_SMS_RETRIEVER;
        Object result = adapter.handleMessageSync(message);
        if (result instanceof SmsRetriever) {
            this.smsRetriever = (SmsRetriever)result;
        } else if (SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("why is null!");
        }
    }

    public void setCodeListener(@NonNull Callback<String> smsCodeListener) {
        this.mSmsCodeListener = smsCodeListener;
    }

    public void start() {
        MLog.info((Object)TAG, (String)"start", (Object[])new Object[0]);
        this.smsRetriever.start(new ISmsCallback(){

            public void onSmsObtained(String sms) {
                if (FP.size((CharSequence)sms) >= 4 && HagoSmsRetriever.this.mSmsCodeListener != null) {
                    HagoSmsRetriever.this.mSmsCodeListener.onResponse((Object)sms);
                    LoginTrack.googleSmsSuccess();
                }
            }

            public void onStartSuccess() {
                MLog.info((Object)HagoSmsRetriever.TAG, (String)"start onSuccess", (Object[])new Object[0]);
                LoginTrack.googleSmsCall();
            }
        });
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy mSmsCodeListener %s", (Object[])new Object[]{this.mSmsCodeListener});
        this.mSmsCodeListener = null;
        this.smsRetriever.stop();
    }
}

