/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.language;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.fragment.app.FragmentActivity;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.language.IDismissActioner;
import com.yy.hiyo.mvp.base.ICustomView;
import javax.annotation.Nonnull;

class YYOkCancelView
extends YYRelativeLayout
implements ICustomView {
    private Builder mBuilder;
    private YYTextView mTitle;
    private YYFrameLayout mContainer;
    private YYTextView mBtnOk;
    private YYTextView mBtnCancel;

    private YYOkCancelView(Context context) {
        super(context);
    }

    private void setBuilder(Builder builder) {
        this.mBuilder = builder;
        this.createView(null);
    }

    public void createView(@Nullable AttributeSet attrs) {
        YYOkCancelView.inflate((Context)this.getContext(), (int)R.layout.hago_common_dialog_view, (ViewGroup)this);
        this.initView();
    }

    public void onDimiss() {
    }

    private void initView() {
        this.mTitle = (YYTextView)this.findViewById(R.id.title);
        this.mContainer = (YYFrameLayout)this.findViewById(R.id.container);
        this.mBtnOk = (YYTextView)this.findViewById(R.id.btn_ok);
        this.mBtnCancel = (YYTextView)this.findViewById(R.id.btn_cancel);
        this.mTitle.setText((CharSequence)this.mBuilder.title);
        if (this.mBuilder.contentView != null) {
            this.mContainer.addView(this.mBuilder.contentView);
        }
        if (this.mBuilder.isWithOk) {
            this.mBtnOk.setVisibility(0);
            this.mBtnOk.setText((CharSequence)this.mBuilder.okText);
            this.mBtnOk.setOnClickListener(v -> {
                if (this.mBuilder.onOk != null) {
                    this.mBuilder.onOk.run();
                }
                this.mBuilder.dismissActioner.dismiss();
            });
        }
        if (this.mBuilder.isWithCancel) {
            this.mBtnCancel.setVisibility(0);
            this.mBtnCancel.setOnClickListener(v -> {
                if (this.mBuilder.onCancel != null) {
                    this.mBuilder.onCancel.run();
                }
                this.mBuilder.dismissActioner.dismiss();
            });
        }
    }

    public static Builder newBuilder(@Nonnull FragmentActivity activity, IDismissActioner dismissActioner) {
        return new Builder(activity).dismissActioner(dismissActioner).isWithOk(true).isWithCancel(true);
    }

    public static final class Builder {
        private FragmentActivity activity;
        private boolean isWithOk;
        private boolean isWithCancel;
        private View contentView;
        private String title;
        private String okText;
        private String cancelText;
        private boolean isCancelable;
        private Runnable onOk;
        private Runnable onCancel;
        private IDismissActioner dismissActioner;

        private Builder(FragmentActivity activity) {
            this.activity = activity;
        }

        private Builder dismissActioner(IDismissActioner actioner) {
            this.dismissActioner = actioner;
            return this;
        }

        public Builder isWithOk(boolean val) {
            this.isWithOk = val;
            return this;
        }

        public Builder isWithCancel(boolean val) {
            this.isWithCancel = val;
            return this;
        }

        public Builder contentView(View val) {
            this.contentView = val;
            return this;
        }

        public Builder title(@StringRes int id2) {
            return this.title(ResourceUtils.getString((int)id2));
        }

        public Builder title(String val) {
            this.title = val;
            return this;
        }

        public Builder okText(@StringRes int id2) {
            return this.okText(ResourceUtils.getString((int)id2));
        }

        public Builder okText(String val) {
            this.okText = val;
            return this;
        }

        public Builder cancelText(String val) {
            this.cancelText = val;
            return this;
        }

        public Builder isCancelable(boolean val) {
            this.isCancelable = val;
            return this;
        }

        public Builder onOk(Runnable onOk) {
            this.isWithOk(true);
            this.onOk = onOk;
            return this;
        }

        public Builder onCancel(Runnable onCancel) {
            this.onCancel = onCancel;
            return this;
        }

        public YYOkCancelView build() {
            YYOkCancelView view = new YYOkCancelView((Context)this.activity);
            view.setBuilder(this);
            return view;
        }
    }
}

