/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.Environment;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.callback.IUserCallBack;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractHandleUserInfoLoginer
extends AbstractLoginer {
    private static final String ICON = "icon_";
    private static final String ICON_EXT = ".jpg";

    public AbstractHandleUserInfoLoginer(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo, int loginType) {
        super(env, callBack, loginTypeInfo, loginType);
    }

    public static void statGetIconFromResult(String url, boolean success, Exception e) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("ifield", success ? 1 : 0);
        statContent.put("sfield", url);
        if (!success && e != null) {
            String errorInfo = e.toString();
            if (errorInfo.length() > 200) {
                errorInfo = errorInfo.substring(0, 200);
            }
            statContent.put("sfieldtwo", errorInfo);
        }
        statContent.put("perftype", "saveiconfromurl");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public void getUserInfo(final boolean needTransformIcon, final int platformId, final AccountInfo accountInfo, final IUserInfoCallBack callBack) {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(platformId);
        if (adapter != null) {
            adapter.getUserInfo(new IUserCallBack(){

                public void onSuccess(final @NotNull UserDetainInfo info) {
                    final Object[] iconPathObject = new Object[1];
                    final Runnable result = new Runnable(){

                        @Override
                        public void run() {
                            AbstractHandleUserInfoLoginer.this.handleLoginWithUpdateUserInfo(callBack, iconPathObject[0] != null ? (String)iconPathObject[0] : null, accountInfo, info);
                        }
                    };
                    if (!needTransformIcon) {
                        YYTaskExecutor.postToMainThread((Runnable)result);
                        return;
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            final String iconUrl = info.getIconUrl();
                            if (StringUtils.isNotEmpty((String)iconUrl)) {
                                File dir = FileStorageUtils.getInstance().getDirAndCreate(true, AbstractHandleUserInfoLoginer.this.getIconDir());
                                final File iconFile = new File(dir, AbstractHandleUserInfoLoginer.ICON + accountInfo.uuid + System.currentTimeMillis() + AbstractHandleUserInfoLoginer.ICON_EXT);
                                try {
                                    ImageLoader.savePhotoSync((String)iconUrl, (File)iconFile, (ImageLoader.ISavePicListener)new ImageLoader.ISavePicListener(){

                                        public void onFailed(Exception e) {
                                            iconPathObject[0] = null;
                                            AbstractHandleUserInfoLoginer.statGetIconFromResult(iconUrl, false, e);
                                            result.run();
                                        }

                                        public void onSuccess() {
                                            iconPathObject[0] = iconFile.getAbsolutePath();
                                            AbstractHandleUserInfoLoginer.statGetIconFromResult(iconUrl, true, null);
                                            result.run();
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    MLog.error((Object)("AbstractLoginer" + platformId), (Throwable)e);
                                    iconPathObject[0] = null;
                                    AbstractHandleUserInfoLoginer.statGetIconFromResult(iconUrl, false, e);
                                    YYTaskExecutor.postToMainThread((Runnable)result);
                                }
                            } else {
                                iconPathObject[0] = null;
                                YYTaskExecutor.postToMainThread((Runnable)result);
                            }
                        }
                    });
                }

                public void onError(int errorCode, Exception e) {
                    AbstractHandleUserInfoLoginer.this.handleUpdateHagoUserInfoError(callBack, AbstractHandleUserInfoLoginer.this.getThirdpartyError(), "get userinfo platformId:" + platformId + " error:" + (e != null ? e.getMessage() : ""));
                }
            });
        } else {
            this.handleUpdateHagoUserInfoError(callBack, this.getThirdpartyError(), "PlatformAdapter error!");
        }
    }

    protected void handleUpdateHagoUserInfoError(final IUserInfoCallBack callBack, final String errorCode, final String errorDes) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (callBack != null) {
                    callBack.onError(errorCode, errorDes);
                }
            }
        });
    }

    protected abstract String getIconDir();

    protected abstract String getThirdpartyError();

    protected abstract void handleLoginWithUpdateUserInfo(IUserInfoCallBack var1, String var2, AccountInfo var3, UserDetainInfo var4);
}

