/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.utils;

import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.yy.appbase.account.LoginTypeData;
import com.yy.base.logger.MLog;
import com.yy.hiyo.login.view.LoginSmallBtn;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public final class LoginTypeContainerHelper {
    private static final String TAG = "LoginTypeContainerHelper";

    public static void updateLoginType(LinearLayout container, LoginTypeData loginType) {
        if (container == null || loginType == null) {
            MLog.warn((Object)TAG, (String)"updateLoginType ignore, container or loginType is null", (Object[])new Object[0]);
            return;
        }
        boolean hasChanged = LoginTypeContainerHelper.checkLoginVisibleChanged(container, loginType);
        if (!hasChanged) {
            MLog.debug((Object)TAG, (String)"updateLoginType ignore, loginType: %d has visible: %b", (Object[])new Object[]{loginType.getType(), loginType.isVisible()});
            return;
        }
        if (loginType == LoginTypeData.WHATSAPP && loginType.isVisible()) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "wa_show"));
        }
        LoginSmallBtn btn = null;
        LoginSmallBtn targetUpdate = null;
        for (int i = 0; i < container.getChildCount() && container.getChildAt(i) instanceof LoginSmallBtn; ++i) {
            btn = (LoginSmallBtn)container.getChildAt(i);
            if (btn.getData() == null) continue;
            if (loginType == btn.getData().loginType) {
                targetUpdate = btn;
                if (loginType.isVisible()) {
                    LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new AlphaAnimation(0.0f, 1.0f));
                    continue;
                }
                LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new AlphaAnimation(1.0f, 0.0f));
                continue;
            }
            if (targetUpdate == null) {
                if (loginType.isVisible()) {
                    LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f));
                    continue;
                }
                LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f));
                continue;
            }
            if (loginType.isVisible()) {
                LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new TranslateAnimation(1, -1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f));
                continue;
            }
            LoginTypeContainerHelper.playLoginBtnAnimation(btn, btn.getData().loginType.isVisible(), (Animation)new TranslateAnimation(1, 1.0f, 1, 0.0f, 1, 0.0f, 1, 0.0f));
        }
    }

    private static boolean checkLoginVisibleChanged(@NonNull LinearLayout container, @NonNull LoginTypeData loginType) {
        LoginSmallBtn btn = null;
        for (int i = 0; i < container.getChildCount() && container.getChildAt(i) instanceof LoginSmallBtn; ++i) {
            btn = (LoginSmallBtn)container.getChildAt(i);
            if (btn.getData() == null || loginType.getType() != btn.getData().loginType.getType()) continue;
            boolean currentVisible = btn.getVisibility() == 0;
            return currentVisible != loginType.isVisible();
        }
        return false;
    }

    private static void playLoginBtnAnimation(final LoginSmallBtn btn, Boolean show, Animation anim2) {
        if (show.booleanValue()) {
            btn.setVisibility(0);
            anim2.setDuration(400L);
            btn.clearAnimation();
            btn.startAnimation(anim2);
        } else {
            anim2.setDuration(400L);
            anim2.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    btn.setVisibility(8);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            btn.clearAnimation();
            btn.startAnimation(anim2);
        }
    }
}

