/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.snapchat;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.login.AbstractHandleUserInfoLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u00016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\u001c\u0010\u001b\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0015H\u0002J\u0018\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J.\u0010$\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010\u00192\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\u0012\u0010(\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020\u0013H\u0002J\u0010\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u000eH\u0002J\b\u0010/\u001a\u00020\u0015H\u0002J\u0018\u00100\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0002J\u0010\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u00020\u0015H\u0016J\b\u00105\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/yy/hiyo/login/snapchat/SnapChatLoginController;", "Lcom/yy/hiyo/login/AbstractHandleUserInfoLoginer;", "environment", "Lcom/yy/framework/core/Environment;", "callback", "Lcom/yy/hiyo/login/ILoginActionCallBack;", "loginTypeInfo", "Lcom/yy/hiyo/login/bean/JLoginTypeInfo;", "(Lcom/yy/framework/core/Environment;Lcom/yy/hiyo/login/ILoginActionCallBack;Lcom/yy/hiyo/login/bean/JLoginTypeInfo;)V", "mBeginTime", "", "mEnableRunnable", "Ljava/lang/Runnable;", "mLoginEnable", "", "mLoginHandling", "mOtherTypeReported", "mReportRunnable", "mReportTimes", "", "authorization", "", "callBack", "Lcom/yy/hiyo/login/base/IThirdPartyAuthorizationCallBack;", "getIconDir", "", "getThirdpartyError", "getUserInfo", "accountInfo", "Lcom/yy/hiyo/login/account/AccountInfo;", "Lcom/yy/hiyo/login/IUserInfoCallBack;", "handleEnableTask", "handleLoginFailed", "errorCode", "description", "handleLoginSucceed", "handleLoginWithUpdateUserInfo", "iconPath", "info", "Lcom/yy/socialplatformbase/UserDetainInfo;", "handleMessage", "msg", "Landroid/os/Message;", "handleOtherLoginTypeSelect", "type", "handleReachResult", "success", "handleReportTask", "handleThirdPartyFailed", "handleThirdPartySucceed", "result", "Lcom/yy/socialplatformbase/data/LoginSuccessResult;", "openLoginWindow", "startLogin", "Companion", "login_release"})
public final class SnapChatLoginController
extends AbstractHandleUserInfoLoginer {
    private boolean mLoginEnable;
    private Runnable mEnableRunnable;
    private Runnable mReportRunnable;
    private int mReportTimes;
    private long mBeginTime;
    private boolean mLoginHandling;
    private boolean mOtherTypeReported;
    private static final String TAG = "SnapChatLoginController";
    private static final long ENABLE_DELAY = 2000L;
    private static final long REPORT_DELAY = 15000L;
    private static final int REPORT_LIMIT = 4;
    public static final Companion Companion = new Companion(null);

    public void handleMessage(@Nullable Message msg) {
        super.handleMessage(msg);
        Message message = msg;
        if (message != null) {
            if (message.what == LoginMsgDef.MSG_LOGIN_TYPE_SELECT) {
                int loginType = msg.arg1;
                if (loginType != 9) {
                    this.handleOtherLoginTypeSelect(msg.arg1);
                }
            }
        }
    }

    @Override
    @NotNull
    protected String getThirdpartyError() {
        return "215";
    }

    @Override
    public void openLoginWindow() {
        this.startLogin();
    }

    @Override
    protected void handleLoginWithUpdateUserInfo(@NotNull IUserInfoCallBack callBack, @Nullable String iconPath, @Nullable AccountInfo accountInfo, @Nullable UserDetainInfo info) {
        Intrinsics.checkParameterIsNotNull((Object)callBack, (String)"callBack");
        if (info == null || accountInfo == null || !accountInfo.isValid()) {
            this.handleUpdateHagoUserInfoError(callBack, "215", "get snapchat userinfo error!");
            return;
        }
        UserInfoBean userInfoBean = this.transform(info);
        boolean bl = false;
        boolean bl2 = false;
        UserInfoBean $this$apply = userInfoBean;
        boolean bl3 = false;
        $this$apply.setUid(accountInfo.uuid);
        UserInfoBean userInfo = userInfoBean;
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(callBack, userInfo){
            final /* synthetic */ IUserInfoCallBack $callBack;
            final /* synthetic */ UserInfoBean $userInfo;

            public final void run() {
                this.$callBack.onSuccess(this.$userInfo);
            }
            {
                this.$callBack = iUserInfoCallBack;
                this.$userInfo = userInfoBean;
            }
        });
    }

    @Override
    @NotNull
    protected String getIconDir() {
        return "snapchat";
    }

    @Override
    protected void authorization(@Nullable IThirdPartyAuthorizationCallBack callBack) {
        block0: {
            AbsPlatformAdapter adapter;
            AbsPlatformAdapter absPlatformAdapter = adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(14);
            if (absPlatformAdapter == null) break block0;
            absPlatformAdapter.login(new ILoginCallBack(callBack){
                final /* synthetic */ IThirdPartyAuthorizationCallBack $callBack;

                public void onSuccess(@NotNull LoginSuccessResult result) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                        IThirdPartyAuthorizationCallBack iThirdPartyAuthorizationCallBack = this.$callBack;
                        if (iThirdPartyAuthorizationCallBack == null) break block0;
                        iThirdPartyAuthorizationCallBack.onSuccess(result);
                    }
                }

                public void onCancel() {
                    block0: {
                        IThirdPartyAuthorizationCallBack iThirdPartyAuthorizationCallBack = this.$callBack;
                        if (iThirdPartyAuthorizationCallBack == null) break block0;
                        iThirdPartyAuthorizationCallBack.onCancel();
                    }
                }

                public void onError(@NotNull LoginErrorResult result) {
                    Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
                    IThirdPartyAuthorizationCallBack iThirdPartyAuthorizationCallBack = this.$callBack;
                    if (iThirdPartyAuthorizationCallBack != null) {
                        int n = result.errorCode;
                        Exception exception = result.exception;
                        if (exception == null) {
                            exception = new RuntimeException("login error, null result");
                        }
                        iThirdPartyAuthorizationCallBack.onError(n, exception);
                    }
                    LoginMetricHelper.reportToMetric((int)6, (String)result.metricCode);
                }
                {
                    this.$callBack = $captured_local_variable$0;
                }
            });
        }
    }

    @Override
    public void getUserInfo(@Nullable AccountInfo accountInfo, @Nullable IUserInfoCallBack callBack) {
        this.getUserInfo(false, 14, accountInfo, callBack);
    }

    private final void startLogin() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            return;
        }
        if (!this.mLoginEnable) {
            MLog.debug((Object)TAG, (String)"startLogin ignore, is not enable", (Object[])new Object[0]);
            return;
        }
        this.mLoginEnable = false;
        if (this.mLoginHandling) {
            this.handleOtherLoginTypeSelect(9);
        } else {
            this.mLoginHandling = true;
        }
        this.handleEnableTask();
        this.handleReportTask();
        this.authorization(new IThirdPartyAuthorizationCallBack(this){
            final /* synthetic */ SnapChatLoginController this$0;

            public void onSuccess(@Nullable LoginSuccessResult result) {
                if (result == null) {
                    SnapChatLoginController.access$handleThirdPartyFailed(this.this$0, "114", "");
                } else {
                    SnapChatLoginController.access$handleThirdPartySucceed(this.this$0, result);
                }
            }

            public void onCancel() {
                SnapChatLoginController.access$handleThirdPartyFailed(this.this$0, "116", "");
            }

            public void onError(int errorCode, @Nullable Exception e) {
                Object object = e;
                if (object == null || (object = ((Throwable)object).getMessage()) == null) {
                    object = "";
                }
                SnapChatLoginController.access$handleThirdPartyFailed(this.this$0, "215", (String)object);
            }
            {
                this.this$0 = $outer;
            }
        });
        this.mOtherTypeReported = false;
        this.mBeginTime = System.currentTimeMillis();
    }

    private final void handleEnableTask() {
        block1: {
            if (this.mEnableRunnable != null) break block1;
            Runnable runnable = this.mEnableRunnable = (Runnable)new Runnable(this){
                final /* synthetic */ SnapChatLoginController this$0;

                public final void run() {
                    SnapChatLoginController.access$setMLoginEnable$p(this.this$0, true);
                    SnapChatLoginController.access$setMEnableRunnable$p(this.this$0, null);
                }
                {
                    this.this$0 = snapChatLoginController;
                }
            };
            if (runnable != null) {
                Runnable runnable2 = runnable;
                boolean bl = false;
                boolean bl2 = false;
                Runnable it = runnable2;
                boolean bl3 = false;
                YYTaskExecutor.postToMainThread((Runnable)it, (long)2000L);
            }
        }
    }

    private final void handleReportTask() {
        block1: {
            if (this.mReportRunnable != null) break block1;
            Runnable runnable = this.mReportRunnable = (Runnable)new Runnable(this){
                final /* synthetic */ SnapChatLoginController this$0;

                public final void run() {
                    SnapChatLoginController snapChatLoginController = this.this$0;
                    int n = SnapChatLoginController.access$getMReportTimes$p(snapChatLoginController);
                    SnapChatLoginController.access$setMReportTimes$p(snapChatLoginController, n + 1);
                    long delayTime = (long)SnapChatLoginController.access$getMReportTimes$p(this.this$0) * 15000L;
                    HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "snapchat_login_interval").put("delay_time", String.valueOf(delayTime)));
                    MLog.debug((Object)"SnapChatLoginController", (String)("handleReportTask interval: " + delayTime + ", reportTimes: " + SnapChatLoginController.access$getMReportTimes$p(this.this$0)), (Object[])new Object[0]);
                    if (SnapChatLoginController.access$getMReportTimes$p(this.this$0) < 4) {
                        Runnable runnable = SnapChatLoginController.access$getMReportRunnable$p(this.this$0);
                        if (runnable != null) {
                            Runnable runnable2 = runnable;
                            boolean bl = false;
                            boolean bl2 = false;
                            Runnable it = runnable2;
                            boolean bl3 = false;
                            YYTaskExecutor.postToMainThread((Runnable)it, (long)15000L);
                        }
                    } else {
                        SnapChatLoginController.access$setMReportRunnable$p(this.this$0, null);
                        SnapChatLoginController.access$setMReportTimes$p(this.this$0, 0);
                        MLog.debug((Object)"SnapChatLoginController", (String)("handleReportTask reportTimes: " + SnapChatLoginController.access$getMReportTimes$p(this.this$0) + " reach limit"), (Object[])new Object[0]);
                    }
                }
                {
                    this.this$0 = snapChatLoginController;
                }
            };
            if (runnable != null) {
                Runnable runnable2 = runnable;
                boolean bl = false;
                boolean bl2 = false;
                Runnable it = runnable2;
                boolean bl3 = false;
                YYTaskExecutor.postToMainThread((Runnable)it, (long)15000L);
            }
        }
    }

    private final void handleOtherLoginTypeSelect(int type) {
        if (!this.mLoginHandling) {
            MLog.warn((Object)TAG, (String)("handleOtherLoginTypeSelect ignore, type: " + type + ", is not login handling"), (Object[])new Object[0]);
            return;
        }
        if (this.mReportRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mReportRunnable);
            this.mReportRunnable = null;
            this.mReportTimes = 0;
        }
        if (this.mOtherTypeReported) {
            MLog.debug((Object)TAG, (String)"handleOtherLoginTypeSelect ignore, has report", (Object[])new Object[0]);
            return;
        }
        this.mOtherTypeReported = true;
        String loginWay = "";
        switch (type) {
            case 3: {
                loginWay = "google";
                break;
            }
            case 1: {
                loginWay = "facebook";
                break;
            }
            case 9: {
                loginWay = "snapchat";
                break;
            }
            case 4: {
                loginWay = "line";
                break;
            }
            case 7: {
                loginWay = "zalo";
                break;
            }
            case 5: {
                loginWay = "vk";
                break;
            }
            case 2: {
                loginWay = "phone";
                break;
            }
            case 10: {
                loginWay = "guest";
            }
        }
        HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "snapchat_next_click").put("next_login_type", loginWay).put("delay_time", String.valueOf(System.currentTimeMillis() - this.mBeginTime)));
        MLog.debug((Object)TAG, (String)("handleOtherLoginTypeSelect, report " + loginWay + ", delay: " + (System.currentTimeMillis() - this.mBeginTime)), (Object[])new Object[0]);
    }

    private final void handleThirdPartySucceed(LoginSuccessResult result) {
        this.mLoginCallBack.onLoginStart(this);
        long startTime = System.currentTimeMillis();
        ILoginActionCallBack iLoginActionCallBack = this.mLoginCallBack;
        Intrinsics.checkExpressionValueIsNotNull((Object)iLoginActionCallBack, (String)"mLoginCallBack");
        iLoginActionCallBack.getLoginRequester().loginWithThirdParty(14, result.authorizedData.appId, result.authorizedData.tokenStr, result.authorizedData.userId, result.authorizedData.mail, new ILoginRequestCallBack(this, startTime){
            final /* synthetic */ SnapChatLoginController this$0;
            final /* synthetic */ long $startTime;

            public void onSuccess(@Nullable LoginData data) {
                AccountInfo accountInfo;
                if (data == null) {
                    SnapChatLoginController.access$handleLoginFailed(this.this$0, "215", "get snapchat loginData error!");
                    return;
                }
                AccountInfo accountInfo2 = AccountInfo.obtain((LoginData)data);
                SnapChatLoginController snapChatLoginController = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                AccountInfo $this$apply = accountInfo2;
                boolean bl3 = false;
                $this$apply.loginType = 9;
                AccountInfo accountInfo3 = accountInfo = accountInfo2;
                Intrinsics.checkExpressionValueIsNotNull((Object)accountInfo3, (String)"AccountInfo.obtain(data)\u2026NAPCHAT\n                }");
                SnapChatLoginController.access$handleLoginSucceed(snapChatLoginController, accountInfo3);
                long time = System.currentTimeMillis() - this.$startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
            }

            public void onError(@Nullable String errorCode, @Nullable String errorDescription, @Nullable String exceptionDue) {
                String string2;
                String string3 = errorCode;
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = errorDescription) == null) {
                    string2 = "";
                }
                SnapChatLoginController.access$handleLoginFailed(this.this$0, string3, string2);
                long time = System.currentTimeMillis() - this.$startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
            }
            {
                this.this$0 = $outer;
                this.$startTime = $captured_local_variable$1;
            }
        });
    }

    private final void handleThirdPartyFailed(String errorCode, String description) {
        MLog.error((Object)TAG, (String)("handleThirdPartyFailed errorCode: " + errorCode + ", description: " + description), (Object[])new Object[0]);
        this.handleLoginFailed(errorCode, description);
    }

    private final void handleLoginSucceed(AccountInfo accountInfo) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, accountInfo){
            final /* synthetic */ SnapChatLoginController this$0;
            final /* synthetic */ AccountInfo $accountInfo;

            public final void run() {
                SnapChatLoginController.access$handleReachResult(this.this$0, true);
                SnapChatLoginController.access$getMLoginCallBack$p(this.this$0).onLoginSuccess(this.this$0, this.$accountInfo);
            }
            {
                this.this$0 = snapChatLoginController;
                this.$accountInfo = accountInfo;
            }
        });
    }

    private final void handleLoginFailed(String errorCode, String description) {
        MLog.error((Object)TAG, (String)("handleLoginFailed errorCode: " + errorCode + ", description: " + description), (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, errorCode, description){
            final /* synthetic */ SnapChatLoginController this$0;
            final /* synthetic */ String $errorCode;
            final /* synthetic */ String $description;

            public final void run() {
                SnapChatLoginController.access$handleReachResult(this.this$0, false);
                SnapChatLoginController.access$getMLoginCallBack$p(this.this$0).onLoginError(this.this$0, this.$errorCode, this.$description);
                this.this$0.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                this.this$0.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
            {
                this.this$0 = snapChatLoginController;
                this.$errorCode = string2;
                this.$description = string3;
            }
        });
    }

    private final void handleReachResult(boolean success) {
        MLog.debug((Object)TAG, (String)("handleReachResult success: " + success), (Object[])new Object[0]);
        this.mLoginEnable = true;
        this.mLoginHandling = false;
        this.mBeginTime = 0L;
        if (this.mEnableRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mEnableRunnable);
            this.mEnableRunnable = null;
        }
        if (this.mReportRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mReportRunnable);
            this.mReportRunnable = null;
            this.mReportTimes = 0;
        }
    }

    public SnapChatLoginController(@NotNull Environment environment, @NotNull ILoginActionCallBack callback, @NotNull JLoginTypeInfo loginTypeInfo) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        Intrinsics.checkParameterIsNotNull((Object)loginTypeInfo, (String)"loginTypeInfo");
        super(environment, callback, loginTypeInfo, 9);
        this.mLoginEnable = true;
        MLog.debug((Object)TAG, (String)"init", (Object[])new Object[0]);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT);
    }

    public static final /* synthetic */ void access$handleThirdPartyFailed(SnapChatLoginController $this, String errorCode, String description) {
        $this.handleThirdPartyFailed(errorCode, description);
    }

    public static final /* synthetic */ void access$handleThirdPartySucceed(SnapChatLoginController $this, LoginSuccessResult result) {
        $this.handleThirdPartySucceed(result);
    }

    public static final /* synthetic */ boolean access$getMLoginEnable$p(SnapChatLoginController $this) {
        return $this.mLoginEnable;
    }

    public static final /* synthetic */ void access$setMLoginEnable$p(SnapChatLoginController $this, boolean bl) {
        $this.mLoginEnable = bl;
    }

    public static final /* synthetic */ Runnable access$getMEnableRunnable$p(SnapChatLoginController $this) {
        return $this.mEnableRunnable;
    }

    public static final /* synthetic */ void access$setMEnableRunnable$p(SnapChatLoginController $this, Runnable runnable) {
        $this.mEnableRunnable = runnable;
    }

    public static final /* synthetic */ int access$getMReportTimes$p(SnapChatLoginController $this) {
        return $this.mReportTimes;
    }

    public static final /* synthetic */ void access$setMReportTimes$p(SnapChatLoginController $this, int n) {
        $this.mReportTimes = n;
    }

    public static final /* synthetic */ Runnable access$getMReportRunnable$p(SnapChatLoginController $this) {
        return $this.mReportRunnable;
    }

    public static final /* synthetic */ void access$setMReportRunnable$p(SnapChatLoginController $this, Runnable runnable) {
        $this.mReportRunnable = runnable;
    }

    public static final /* synthetic */ void access$handleLoginFailed(SnapChatLoginController $this, String errorCode, String description) {
        $this.handleLoginFailed(errorCode, description);
    }

    public static final /* synthetic */ void access$handleLoginSucceed(SnapChatLoginController $this, AccountInfo accountInfo) {
        $this.handleLoginSucceed(accountInfo);
    }

    public static final /* synthetic */ void access$handleReachResult(SnapChatLoginController $this, boolean success) {
        $this.handleReachResult(success);
    }

    public static final /* synthetic */ ILoginActionCallBack access$getMLoginCallBack$p(SnapChatLoginController $this) {
        return $this.mLoginCallBack;
    }

    public static final /* synthetic */ void access$setMLoginCallBack$p(SnapChatLoginController $this, ILoginActionCallBack iLoginActionCallBack) {
        $this.mLoginCallBack = iLoginActionCallBack;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/yy/hiyo/login/snapchat/SnapChatLoginController$Companion;", "", "()V", "ENABLE_DELAY", "", "REPORT_DELAY", "REPORT_LIMIT", "", "TAG", "", "login_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

