/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.guest;

import android.app.Dialog;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.view.Window;
import com.yy.appbase.account.LoginType;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;

public class LoginGuideDialog
implements BaseDialog,
View.OnClickListener {
    private int type = -1;
    private RecycleImageView ivIcon;
    private YYImageView ivClose;
    private YYTextView tvLoginMain;
    private YYTextView tvLoginOther;
    private YYTextView tvLoginTip;
    private String loginTips;
    private String loginIconUrl;
    private int mMainType = -1;
    private LoginGuideCallback callback;

    public LoginGuideDialog(LoginGuideCallback loginGuideCallback) {
        this.callback = loginGuideCallback;
    }

    public void setLoginTipFromType(int type) {
        this.type = type;
    }

    public void setLoginTips(String tips, String iconUrl) {
        this.loginTips = tips;
        this.loginIconUrl = iconUrl;
    }

    public void init(Dialog dialog) {
        Window window = dialog.getWindow();
        dialog.setCanceledOnTouchOutside(false);
        dialog.setCancelable(true);
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                LoginGuideDialog.this.onDialogDismiss();
            }
        });
        if (window == null) {
            return;
        }
        window.setContentView(R.layout.layout_dialog_login_tip);
        this.ivIcon = (RecycleImageView)window.findViewById(R.id.iv_icon);
        this.ivClose = (YYImageView)window.findViewById(R.id.iv_close);
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.tvLoginMain = (YYTextView)window.findViewById(R.id.tv_login_with_type);
        this.tvLoginMain.setOnClickListener((View.OnClickListener)this);
        this.tvLoginOther = (YYTextView)window.findViewById(R.id.tv_login_other_ways);
        this.tvLoginOther.setOnClickListener((View.OnClickListener)this);
        this.tvLoginTip = (YYTextView)window.findViewById(R.id.tv_tip);
        if (this.ivIcon != null && this.tvLoginTip != null) {
            if (this.type == 0) {
                this.ivIcon.setImageResource(R.drawable.login_guide_profile);
                this.tvLoginTip.setText(R.string.login_guest_profile_tip);
            } else if (this.type == 2) {
                this.ivIcon.setImageResource(R.drawable.login_guide_other);
                this.tvLoginTip.setText(R.string.login_guest_message_tip);
            } else if (this.type == 3) {
                this.ivIcon.setImageResource(R.drawable.login_guide_profile);
                this.tvLoginTip.setText(R.string.tip_wemeet_login);
            } else if (this.type == 4 || this.type == 5) {
                this.ivIcon.setImageResource(R.drawable.login_guide_purchase);
                this.tvLoginTip.setText(R.string.tips_login_guide_recharge);
            } else if (this.type == 6) {
                this.ivIcon.setImageResource(R.drawable.login_guide_profile);
                this.tvLoginTip.setText(R.string.title_login_with_chat_room);
            } else if (this.type == 7) {
                this.ivIcon.setImageResource(R.drawable.login_guide_profile);
                this.tvLoginTip.setText(R.string.tip_login_customer_service);
            } else if (this.type == 8) {
                this.ivIcon.setImageResource(R.drawable.login_guide_profile);
                this.tvLoginTip.setText(R.string.tips_send_gift_login);
            } else if (!TextUtils.isEmpty((CharSequence)this.loginTips) && !TextUtils.isEmpty((CharSequence)this.loginIconUrl)) {
                this.tvLoginTip.setText((CharSequence)this.loginTips);
                ImageLoader.loadImage((RecycleImageView)this.ivIcon, (String)this.loginIconUrl, (int)R.drawable.login_guide_other);
            } else {
                this.ivIcon.setImageResource(R.drawable.login_guide_other);
                this.tvLoginTip.setText(R.string.login_guest_main_tip);
            }
        }
        window.setWindowAnimations(R.style.DialogAnimationTopBottom);
        Object mainTypeObj = MsgDispatcher.getInstance().sendMessageSync(LoginMsgDef.MSG_LOGIN_MAIN_GET);
        this.mMainType = mainTypeObj instanceof Integer ? (Integer)mainTypeObj : -1;
        if (this.mMainType != -1) {
            this.tvLoginMain.setVisibility(0);
            this.tvLoginMain.setText((CharSequence)ResourceUtils.getString((int)R.string.login_guest_guide_main_button, (Object[])new Object[]{LoginType.getShowName((int)this.mMainType)}));
        } else {
            this.tvLoginMain.setVisibility(8);
        }
    }

    public int getId() {
        return DialogId.LoginTipDialog;
    }

    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.iv_close) {
            if (this.callback != null) {
                this.callback.onClickClose();
            }
        } else if (i == R.id.tv_login_with_type) {
            if (this.callback != null) {
                this.callback.onLogin(this.mMainType);
            }
        } else if (i == R.id.tv_login_other_ways && this.callback != null) {
            this.callback.onLoginOther();
        }
    }

    private void onDialogDismiss() {
        this.type = -1;
        this.loginTips = null;
        this.loginIconUrl = null;
    }

    public static interface LoginGuideCallback {
        public void onClickClose();

        public void onLogin(int var1);

        public void onLoginOther();
    }
}

