/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.google;

import android.content.Context;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.NavigationUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.google.GoogleTokenData;
import com.yy.hiyo.login.stat.LoginStatistics;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.AuthorizedData;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.MetricCode;
import com.yy.socialplatformbase.platform.IPlatformAvailableCallBack;
import java.util.Map;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class GoogleLoginController
extends AbstractLoginer {
    private static final String TAG = "GoogleLoginController";
    private static final int MAX_LOGIN_ERROR_TIMES_PRTOTECT = 1;
    private static final int GOOGLESERVICE_TOO_OLD_VER = 10;
    private ILoginActionCallBack loginCallBack;
    private volatile int mLoginErrorTimes = 0;

    public GoogleLoginController(Environment baseEnv, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(baseEnv, callBack, loginTypeInfo, 3);
        this.loginCallBack = callBack;
        ThirdPartyPlatformHelper.getInstance().getPlatform(6);
    }

    @Override
    public void openLoginWindow() {
        this.login();
    }

    public void logout() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        if (adapter != null) {
            adapter.logout();
        }
    }

    private void login() {
        final long time = System.currentTimeMillis();
        String s = "start google login";
        BDAConst.bDAGoogle((String)s);
        FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            s = "start google login network unavailable";
            BDAConst.bDAGoogle((String)s, (int)0);
            FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"login!", (Object[])new Object[0]);
        this.authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                MLog.info((Object)GoogleLoginController.TAG, (String)"login success!", (Object[])new Object[0]);
                GoogleLoginController.this.mLoginErrorTimes = 0;
                if (result != null && result.authorizedData != null) {
                    String s = "google login authorization sucess";
                    BDAConst.bDAGoogle((String)s, (int)1);
                    FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
                    GoogleLoginController.this.handleAuthSuc(result);
                } else {
                    String s = "google login authorization sucess, but LoginSuccessResult inval error";
                    BDAConst.bDAGoogle((String)s, (int)0);
                    FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
                    GoogleLoginController.this.handleLoginError("114", "");
                }
            }

            public void onCancel() {
                String s = "google login authorization cancel, time interval = " + (System.currentTimeMillis() - time);
                BDAConst.bDAGoogle((String)s, (int)0);
                FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
                GoogleLoginController.this.handleLoginError("116", "");
            }

            public void onError(int errorCode, Exception e) {
                String s = "google login authorization error, errorCode = " + errorCode + " e = " + e;
                BDAConst.bDAGoogle((String)s, (int)0);
                FeatureLog.i((String)"FTLoginGoogle", (String)s, (Object[])new Object[0]);
                GoogleLoginController.this.mLoginErrorTimes++;
                GoogleLoginController.this.handleLoginError(errorCode == 1 ? "122" : "121", e == null ? "" : e.getMessage());
                if (!SettingFlags.getBoolean((String)"googleloginprotect", (boolean)true)) {
                    return;
                }
                AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
                if (GoogleLoginController.this.mLoginErrorTimes >= 1 && platformAdapter != null && errorCode != 1) {
                    platformAdapter.getPlatformVersion(new IPlatformAvailableCallBack(){

                        public void onCallBack(final boolean isServicesAvailable, int version, final String verName, String packName) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    int verInt;
                                    String[] verDatas;
                                    boolean verTooLow = false;
                                    if (isServicesAvailable && StringUtils.isNotEmpty((String)verName) && (verDatas = verName.split("\\.")).length > 0 && (verInt = StringUtils.parseInt((String)verDatas[0], (int)-1)) > 0 && verInt <= 10) {
                                        verTooLow = true;
                                    }
                                    if (GoogleLoginController.this.mLoginCallBack != null && (!isServicesAvailable || verTooLow)) {
                                        OkCancelDialog tipsDialog = new OkCancelDialog((CharSequence)RuntimeContext.sApplicationContext.getString(R.string.login_google_service_upgrade_tips), (CharSequence)RuntimeContext.sApplicationContext.getString(R.string.dialog_btn_yes), (CharSequence)RuntimeContext.sApplicationContext.getString(R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                                            public void onCancel() {
                                                MLog.info((Object)GoogleLoginController.TAG, (String)"push dialog onCancel", (Object[])new Object[0]);
                                                LoginStatistics.statErrorTips((int)3, (boolean)false);
                                                GoogleLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
                                            }

                                            public void onOk() {
                                                LoginStatistics.statErrorTips((int)3, (boolean)true);
                                                try {
                                                    NavigationUtils.navToBrower((Context)GoogleLoginController.this.mContext, (String)UriProvider.GOOGLE_SERVICE_GOOGLE_PLAY_URI);
                                                }
                                                catch (Exception e) {
                                                    MLog.warn((Object)GoogleLoginController.TAG, (String)"open google play error %s", (Object[])new Object[]{e});
                                                }
                                            }
                                        });
                                        GoogleLoginController.this.mLoginCallBack.showDialog((BaseDialog)tipsDialog);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    @Override
    protected void authorization(final IThirdPartyAuthorizationCallBack callBack) {
        MLog.info((Object)TAG, (String)"authorization!", (Object[])new Object[0]);
        ThirdPartyPlatformHelper.getInstance().getPlatform(6).login(new ILoginCallBack(){

            public void onSuccess(@NotNull LoginSuccessResult result) {
                MLog.info((Object)GoogleLoginController.TAG, (String)"authorization success!", (Object[])new Object[0]);
                if (result.authorizedData != null) {
                    if (callBack != null) {
                        callBack.onSuccess(result);
                    }
                } else {
                    if (callBack != null) {
                        callBack.onError(-1, (Exception)new RuntimeException("null login suc data"));
                    }
                    String metricCode = MetricCode.getSelfCode((String)"203");
                    LoginMetricHelper.reportToMetric((int)3, (String)metricCode);
                }
            }

            public void onCancel() {
                MLog.info((Object)GoogleLoginController.TAG, (String)"[login] cancel", (Object[])new Object[0]);
                if (callBack != null) {
                    callBack.onCancel();
                }
            }

            public void onError(@NotNull LoginErrorResult result) {
                MLog.info((Object)GoogleLoginController.TAG, (String)"[login] onError", (Object[])new Object[0]);
                if (callBack != null) {
                    callBack.onError(result.errorCode, result.exception);
                    LoginMetricHelper.reportToMetric((int)3, (String)result.metricCode);
                }
            }
        });
    }

    private void handleAuthSuc(final LoginSuccessResult result) {
        this.loginCallBack.onLoginStart(this);
        MLog.info((Object)TAG, (String)"[handleAuthSuc] start!", (Object[])new Object[0]);
        if (result != null && result.authorizedData != null && StringUtils.isEmpty((String)result.authorizedData.tokenStr) && StringUtils.isNotEmpty((String)result.authorizedData.idToken)) {
            this.loginServer(result.authorizedData);
        } else {
            MLog.info((Object)TAG, (String)"[handleAuthSuc] exchangeAccessToken!", (Object[])new Object[0]);
            this.exchangeAccessToken(result.authorizedData.tokenStr, new IExchangeAccessTokenCallback(){

                @Override
                public void onExchangeTokenSuc(String accessToken) {
                    MLog.info((Object)GoogleLoginController.TAG, (String)"[handleAuthSuc] onExchangeTokenSuc", (Object[])new Object[0]);
                    LoginMetricHelper.reportToMetric((int)3, (String)"0");
                    result.authorizedData.tokenStr = accessToken;
                    GoogleLoginController.this.loginServer(result.authorizedData);
                }

                @Override
                public void onExchangeTokenFail() {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Message message = Message.obtain();
                            message.what = PlatformMsgDef.MSG_SWTICH_LOGIN_TYPE;
                            message.obj = 7;
                            ThirdPartyPlatformHelper.getInstance().getPlatform(6).handleMessageSync(message);
                        }
                    });
                    GoogleLoginController.this.handleLoginError("121", "can not exchange token");
                    String metricCode = MetricCode.getSelfCode((String)"204");
                    LoginMetricHelper.reportToMetric((int)3, (String)metricCode);
                }
            });
        }
    }

    private void loginServer(AuthorizedData data) {
        String userId = data.userId;
        String token = data.tokenStr;
        String email = data.mail;
        String appId = data.appId;
        String idToken = data.idToken;
        final boolean isIdToken = StringUtils.isNotEmpty((String)idToken);
        final long startTime = System.currentTimeMillis();
        this.loginCallBack.getLoginRequester().loginWithThirdParty(6, appId, token, idToken, userId, email, new ILoginRequestCallBack(){

            public void onSuccess(LoginData data) {
                MLog.info((Object)GoogleLoginController.TAG, (String)"[handleAuthSuc] data: %s", (Object[])new Object[]{data});
                if (data != null) {
                    AccountInfo account = AccountInfo.obtain((LoginData)data);
                    account.loginType = 3;
                    if (GoogleLoginController.this.loginCallBack != null) {
                        GoogleLoginController.this.loginCallBack.onLoginSuccess(GoogleLoginController.this, account);
                    }
                    long time = System.currentTimeMillis() - startTime;
                    LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
                } else {
                    GoogleLoginController.this.handleLoginError("121", "get google user info fail");
                }
            }

            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                MLog.error((Object)GoogleLoginController.TAG, (String)"[handleAuthSuc] code: %s, des: %s", (Object[])new Object[]{errorCode, errorDescription});
                if ("20453".equals(errorCode)) {
                    Message message;
                    if (AccountUtil.getUid() <= 0L) {
                        ThirdPartyPlatformHelper.getInstance().getPlatform(6).logout();
                    }
                    if (isIdToken) {
                        message = Message.obtain();
                        message.what = PlatformMsgDef.MSG_SWTICH_LOGIN_TYPE;
                        message.obj = 8;
                        ThirdPartyPlatformHelper.getInstance().getPlatform(6).handleMessageSync(message);
                    } else {
                        message = Message.obtain();
                        message.what = PlatformMsgDef.MSG_SWTICH_LOGIN_TYPE;
                        message.obj = 7;
                        ThirdPartyPlatformHelper.getInstance().getPlatform(6).handleMessageSync(message);
                    }
                }
                GoogleLoginController.this.handleLoginError(errorCode, errorDescription);
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
            }
        });
    }

    private void handleLoginError(final String errorCode, final String des) {
        MLog.error((Object)TAG, (String)"login error:%s %s", (Object[])new Object[]{errorCode, des});
        ThirdPartyPlatformHelper.getInstance().getPlatform(6).logout();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (GoogleLoginController.this.mLoginCallBack != null) {
                    GoogleLoginController.this.mLoginCallBack.onLoginError(GoogleLoginController.this, errorCode, des);
                }
                GoogleLoginController.this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                GoogleLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
        });
    }

    private void exchangeAccessToken(String authCode, final IExchangeAccessTokenCallback callback) {
        Map params;
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_GET_EXCHANGE_TOKEN_PARAMS;
        message.obj = authCode;
        Object result = adapter.handleMessageSync(message);
        if (result instanceof Map) {
            params = (Map)result;
        } else {
            params = null;
            if (SystemUtils.isShowEnvSetting()) {
                throw new RuntimeException("Why params is null!");
            }
        }
        String url = "https://accounts.google.com/o/oauth2/token";
        HttpUtil.httpReq((String)url, (Map)params, (int)2, (INetRespCallback)new INetRespCallback<GoogleTokenData>(){

            public void onError(Call call, Exception e, int id2) {
                MLog.error((Object)GoogleLoginController.TAG, (String)"[exchangeAccessToken]", (Throwable)e, (Object[])new Object[0]);
                if (callback != null) {
                    callback.onExchangeTokenFail();
                }
            }

            public void onResponse(final String response, BaseResponseBean<GoogleTokenData> res, int id2) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)GoogleLoginController.TAG, (String)"[exchangeAccessToken] response: %s", (Object[])new Object[]{response});
                }
                if (!TextUtils.isEmpty((CharSequence)response)) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String accessToken = "";
                            try {
                                JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
                                accessToken = jsonObject.getString("access_token");
                            }
                            catch (Exception e) {
                                MLog.error((Object)GoogleLoginController.TAG, (String)"[exchangeAccessToken]", (Throwable)e, (Object[])new Object[0]);
                            }
                            final String finalAccessToken = accessToken;
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    if (callback != null) {
                                        if (TextUtils.isEmpty((CharSequence)finalAccessToken)) {
                                            callback.onExchangeTokenFail();
                                        } else {
                                            callback.onExchangeTokenSuc(finalAccessToken);
                                        }
                                    }
                                }
                            });
                        }
                    });
                } else {
                    MLog.error((Object)GoogleLoginController.TAG, (String)"[exchangeAccessToken] empty response", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.onExchangeTokenFail();
                    }
                }
            }

            public boolean needToken() {
                return false;
            }
        });
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        UserInfoBean bean = new UserInfoBean();
        bean.setSex(-1);
        AbsPlatformAdapter googleAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
        if (googleAdapter != null) {
            Message message = Message.obtain();
            message.what = PlatformMsgDef.MSG_GET_ACCOUNT_NICK;
            Object nick = googleAdapter.handleMessageSync(message);
            Message message2 = Message.obtain();
            message2.what = PlatformMsgDef.MSG_GET_ACCOUNT_AVATAR_URL;
            Object avatarUrl = googleAdapter.handleMessageSync(message2);
            if (nick instanceof String) {
                bean.setNick((String)nick);
            } else {
                nick = "";
            }
            if (avatarUrl instanceof String) {
                bean.setAvatar((String)avatarUrl);
            } else {
                avatarUrl = "";
            }
            MLog.info((Object)TAG, (String)("get google nick:" + nick + " avatar:" + avatarUrl), (Object[])new Object[0]);
        }
        if (callBack != null) {
            callBack.onSuccess(bean);
        }
    }

    private static interface IExchangeAccessTokenCallback {
        public void onExchangeTokenSuc(String var1);

        public void onExchangeTokenFail();
    }
}

