/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.SparseArray;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.yy.appbase.R;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.account.LoginType;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.http.dns.OkHttpDns;
import com.yy.appbase.login.IZaloAccountSwitch;
import com.yy.appbase.service.IDBService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.LanguageUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.callback.ILeaveGameCallback;
import com.yy.hiyo.login.AbstractLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.ILoginPageCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginAuthDialog;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.LoginTrack;
import com.yy.hiyo.login.LoginTypeSelectWindow;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.auto.AutoLoginUtil;
import com.yy.hiyo.login.base.IAutoReloginCallBack;
import com.yy.hiyo.login.base.IBindThirdPartyAccountCallBack;
import com.yy.hiyo.login.base.IFacebookLoginCallback;
import com.yy.hiyo.login.base.IGuestAutoLoginCallback;
import com.yy.hiyo.login.base.IGuestLoginChangedCallback;
import com.yy.hiyo.login.base.ILoginController;
import com.yy.hiyo.login.base.ILoginWindowFinish;
import com.yy.hiyo.login.base.IQueryThirdPartyCallBack;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.base.LoginBaseMsgDef;
import com.yy.hiyo.login.base.OnReportCallback;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.login.basicprofile.BasicProfileController;
import com.yy.hiyo.login.basicprofile.IBasicProfileCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.LoginGuestReportInfo;
import com.yy.hiyo.login.facebook.FaceBookLoginController;
import com.yy.hiyo.login.google.GoogleLoginController;
import com.yy.hiyo.login.guest.GuestLoginController;
import com.yy.hiyo.login.line.LineLoginController;
import com.yy.hiyo.login.module.NewUserLoginController;
import com.yy.hiyo.login.nonlogin.NonLoginReport;
import com.yy.hiyo.login.phone.PhoneLoginController;
import com.yy.hiyo.login.phone.windows.LoginFeedbackView;
import com.yy.hiyo.login.relogin.AccountReLoginController;
import com.yy.hiyo.login.relogin.AccountSilentReloginController;
import com.yy.hiyo.login.request.IQueryThirdPartyAccountCallBack;
import com.yy.hiyo.login.request.LoginRequestManager;
import com.yy.hiyo.login.snapchat.SnapChatLoginController;
import com.yy.hiyo.login.solid.SolidManager;
import com.yy.hiyo.login.stat.LoginStatistics;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.login.utils.RegisterUtils;
import com.yy.hiyo.login.utils.TestEnvUidNotInWhiteListDialog;
import com.yy.hiyo.login.vk.VkLoginController;
import com.yy.hiyo.login.zalo.IBindZaloAccount;
import com.yy.hiyo.login.zalo.ZaloBindAccount;
import com.yy.hiyo.login.zalo.ZaloLoginController;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.hiyo.loginrequest.ResponseCode;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.yylite.commonbase.CommonBaseTransfer;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public class LoginController
extends DefaultWindowController
implements ILoginPageCallBack,
ILoginActionCallBack,
ILoginController {
    private static final String TAG = "LoginController";
    private static final String KEY_FACEBOOK_BIND = "key_facebook_accout_bind_";
    private static final String KEY_FACEBOOK_BIND_USERID = "key_facebook_accout_bind_id";
    private static final String KEY_FACEBOOK_HAS_CHECK_BIND = "key_facebook_has_check_bind";
    private static final int LOGIN_FAIL_MIN_TIMES_WHEN_SHOW_LOGIN_GUIDE_BY_BACK_EVENT = 1;
    private static final int LOGIN_FAIL_MAX_TIMES_WHEN_SHOW_GUEST_LOGIN = 2;
    private static final int LOGIN_CONSUME_TIME_WHEN_SHOW_GUEST_LOGIN = 30000;
    private static final int LOGIN_TIPS_TYPE_DEFAULT = 1;
    private static final int LOGIN_TIPS_TYPE_RETRY = 2;
    private AccountSilentReloginController mSilentAccountLoginController;
    private AccountReLoginController mAccountLoginController;
    private PhoneLoginController mPhoneController;
    private PhoneLoginController mWhatsAppController;
    private FaceBookLoginController mFaceBookController;
    private GoogleLoginController mGoogleLoginController;
    private GuestLoginController mGuestLoginController;
    private BasicProfileController mProfileController;
    private LineLoginController mLineLoginController;
    private VkLoginController mVkLoginController;
    private ZaloLoginController mZaloLoginController;
    private SnapChatLoginController mSnapChatLoginController;
    private NewUserLoginController mNewUserLoginController;
    private LoginTypeSelectWindow mSelectWindow;
    private ILoginWindowFinish mWindowFinishCallBack;
    private boolean mNeedRefreshAccountToken = true;
    private boolean mAccountTokenRefreshing = false;
    private boolean mFacebookEnable = true;
    private boolean mOpenPrivacyWeb = true;
    private boolean isFeedbackOpen = false;
    private boolean mHasInterceptBackEvent = false;
    private LoginFeedbackView mLoginFeedbackView;
    private long mStartLoginTime = -1L;
    private int mLoginCallFrom = -1;
    private String mLoginFromGid = "";
    private LoginStatistics mLoginStatistics;
    private LoginSuccessResult mFacebookLoginResult;
    private int mLoginFailTimes = 0;
    private long mLoginFailConsume = 0L;
    private IGuestLoginChangedCallback mGuestLoginChangedCallback = null;
    private int mLoginType;
    private int mLastLoginType = this.mLoginType = -1;
    private String mErrorCode;
    private int mLoginOutBy = -1;
    @Nullable
    private NonLoginReport mNonLoginReport;
    private Runnable notifyLoginSuccess;
    private LoginGuestReportInfo mGuestReportInfo;
    private boolean needPreloadHomeWhenLogin = false;
    private JLoginTypeInfo mLoginTypeInfo = new JLoginTypeInfo();
    private long mRefreshTokenTime = 0L;
    private Runnable mHideFeedbackTask = new Runnable(){

        @Override
        public void run() {
            if (LoginController.this.mLoginFeedbackView != null) {
                LoginController.this.mWindowMgr.removeExtLayerContent((View)LoginController.this.mLoginFeedbackView);
            }
        }
    };

    public LoginController(Environment baseEnv) {
        super(baseEnv);
        this.initRefreshTokenFlag();
        this.registerMessage(LoginMsgDef.MSG_LOGIN_OUT);
        this.registerMessage(LoginMsgDef.MSG_FACEBOOK_BIND_ACCOUNT);
        this.registerMessage(LoginMsgDef.MSG_ZALO_BIND_ACCOUNT);
        this.registerMessage(LoginMsgDef.MSG_GET_FACEBOOK_BIND_STATU);
        this.registerMessage(LoginMsgDef.MSG_FACEBOOK_AUTHORIZATION);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_OPEN_WINDOW);
        this.registerMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
        this.registerMessage(LoginMsgDef.MSG_GUEST_LOGIN_WITH_TYPE);
        this.registerMessage(BaseMsgDef.MSG_FACEBOOK_SWITCH_BIND);
        this.registerMessage(BaseMsgDef.MSG_GET_FACEBOOK_USER_ID);
        this.registerMessage(BaseMsgDef.MSG_FACEBOOK_LOGOUT);
        this.registerMessage(LoginMsgDef.MSG_ACCOUNT_FEED_BACK_COMPLAIN);
        this.registerMessage(LoginMsgDef.MSG_GUEST_LOGIN);
        this.registerMessage(BaseMsgDef.MSG_ZALO_BIND_SWITCH_ACCOUNT);
        this.registerMessage(LoginBaseMsgDef.MSG_UPDATE_LOGINED_ACCOUNT_USERINFO);
        this.registerMessage(LoginBaseMsgDef.MSG_GET_CUR_ACCOUNT_SEX);
        this.registerMessage(LoginBaseMsgDef.MSG_REPORT_LOCATION);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
        this.registerMessage(BaseMsgDef.OPEN_PROFILE_WINDOW_RESET_AGE);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_RELOGIN_DIALOG);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_SET_PWD);
        this.registerMessage(LoginMsgDef.MSG_LOGIN_RESET_PWD);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        if (AccountUtil.getUid() > 0L && !UriProvider.hasRegisterHost()) {
            this.refreshAccountToken();
        } else {
            this.needPreloadHomeWhenLogin = true;
        }
        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_INIT, (Object)this);
    }

    @NotNull
    public JLoginTypeInfo getLoginTypeInfo() {
        return this.mLoginTypeInfo;
    }

    public void onSplashHidden() {
        AccountModel.getInstance().setWsTokenInvalidCallBack(new AccountModel.IWsTokenInvalidCallBack(){

            public void onWsTokenInvalid(long uid, int code) {
                if (AccountUtil.getUid() > 0L && AccountUtil.getUid() == uid) {
                    if (code == 4004) {
                        LoginController.this.loginOut(9);
                    } else {
                        LoginController.this.loginOut(8);
                    }
                }
                if (code == 4010) {
                    LoginController.this.getDialogLinkManager().dismissDialog();
                    TestEnvUidNotInWhiteListDialog.showUidNotInWhiteListDialog(uid, LoginController.this.mContext);
                }
            }
        });
    }

    private PhoneLoginController getPhoneLoginController() {
        if (this.mPhoneController == null) {
            this.mPhoneController = new PhoneLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mPhoneController;
    }

    private PhoneLoginController getWhatsAppController() {
        if (this.mWhatsAppController == null) {
            this.mWhatsAppController = new PhoneLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        this.mWhatsAppController.updateLoginType(8);
        return this.mWhatsAppController;
    }

    private FaceBookLoginController getFacebookLoginController() {
        if (this.mFaceBookController != null) {
            return this.mFaceBookController;
        }
        this.mFaceBookController = new FaceBookLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        return this.mFaceBookController;
    }

    private GoogleLoginController getGoogleLoginController() {
        if (this.mGoogleLoginController == null) {
            this.mGoogleLoginController = new GoogleLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mGoogleLoginController;
    }

    private GuestLoginController getGuestLoginController() {
        if (this.mGuestLoginController == null) {
            this.mGuestLoginController = new GuestLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mGuestLoginController;
    }

    private LineLoginController getLineLoginController() {
        if (this.mLineLoginController == null) {
            this.mLineLoginController = new LineLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mLineLoginController;
    }

    private VkLoginController getVkLoginController() {
        if (this.mVkLoginController == null) {
            this.mVkLoginController = new VkLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mVkLoginController;
    }

    private ZaloLoginController getZaloLoginController() {
        if (this.mZaloLoginController == null) {
            this.mZaloLoginController = new ZaloLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mZaloLoginController;
    }

    private SnapChatLoginController getSnapChatLoginController() {
        if (this.mSnapChatLoginController == null) {
            this.mSnapChatLoginController = new SnapChatLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mSnapChatLoginController;
    }

    private NewUserLoginController getNewUserLoginController() {
        if (this.mNewUserLoginController == null) {
            this.mNewUserLoginController = new NewUserLoginController(this.getEnvironment());
        }
        return this.mNewUserLoginController;
    }

    private AccountReLoginController getAccountReLoginController() {
        if (this.mAccountLoginController == null) {
            this.mAccountLoginController = new AccountReLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mAccountLoginController.updateLoginOutBy(this.mLoginOutBy);
    }

    private AccountSilentReloginController getSilentAccountReLoginController() {
        if (this.mSilentAccountLoginController == null) {
            this.mSilentAccountLoginController = new AccountSilentReloginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        return this.mSilentAccountLoginController;
    }

    private BasicProfileController getProfileController() {
        if (this.mProfileController != null) {
            return this.mProfileController;
        }
        this.mProfileController = new BasicProfileController(this.getEnvironment(), new IBasicProfileCallBack(){

            @Override
            public void onProfileInfoSaved(long uuid) {
                LoginController.this.getProfileController().setProfileHasUpdated(uuid);
                LoginController.this.mProfileController.closeWindow(true);
                LoginController.this.popAllWindow(false);
            }

            @Override
            public LoginStatistics getLoginStatistics() {
                return LoginController.this.mLoginStatistics;
            }
        });
        return this.mProfileController;
    }

    public void realLogout(int by) {
        boolean needSilentReLogin;
        MLog.info((Object)TAG, (String)"loginOut", (Object[])new Object[0]);
        if (this.notifyLoginSuccess != null) {
            this.notifyLoginSuccess.run();
            this.notifyLoginSuccess = null;
        }
        if (this.mLoginOutBy == by && this.mLoginOutBy == 9 && AccountUtil.getUid() <= 0L) {
            return;
        }
        this.mLoginOutBy = by;
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        AccountInfo logoutAccountInfo = AccountInfo.obtain((AccountInfo)accountInfo);
        long oldUid = accountInfo.uuid;
        boolean bl = needSilentReLogin = this.mLoginOutBy == 9 && this.getSilentAccountReLoginController().handleKickOffByOurApp(logoutAccountInfo);
        if (!needSilentReLogin) {
            switch (accountInfo.loginType) {
                case 3: {
                    this.getGoogleLoginController().logout();
                    break;
                }
                case 4: {
                    this.getLineLoginController().logout();
                    break;
                }
                case 5: {
                    this.getVkLoginController().logout();
                    break;
                }
                case 7: {
                    this.getZaloLoginController().logout();
                    break;
                }
            }
            if (this.mFacebookEnable) {
                this.getFacebookLoginController().logout();
            }
        }
        this.getSilentAccountReLoginController().updateLoginOutBy(this.mLoginOutBy);
        AccountModel.getInstance().loginOut();
        ProtoManager.getInstance().disconnect();
        SystemServiceUtils.getNotificationManager((Context)this.mContext).cancelAll();
        ((IDBService)this.getServiceManager().getService(IDBService.class)).logOut();
        if (!needSilentReLogin) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_LOGIN_LOGIN_OUT, (Object)oldUid));
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (Object)oldUid));
            if (this.mLoginOutBy != 12) {
                this.mWindowMgr.popToRootWindow(false);
                this.openLoginSelectWindow(0, true, null);
            }
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mSelectWindow == abstractWindow) {
            this.mLoginFromGid = "";
            this.mSelectWindow = null;
        }
    }

    public synchronized void loginOut(final int from, final Function0 callback) {
        if (RuntimeContext.sIsDebuggable && RuntimeContext.sIsAutoTesting) {
            return;
        }
        MLog.info((Object)TAG, (String)"loginOut from: %d", (Object[])new Object[]{from});
        Log.d((String)TAG, (String)("loginOut from:" + from));
        LoginStatistics.statLoginOutEvent((int)from);
        if (this.getServiceManager() != null && this.getServiceManager().getService(IGameCenterService.class) != null && ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).isPlaying()) {
            ((IGameCenterService)this.getServiceManager().getService(IGameCenterService.class)).leaveCurrentGame(new ILeaveGameCallback(){

                public void onGameLeaved(GameInfo gameInfo, GamePlayContext context) {
                    LoginController.this.realLogout(from);
                    if (callback != null) {
                        callback.invoke();
                    }
                }
            });
        } else {
            this.realLogout(from);
            if (callback != null) {
                callback.invoke();
            }
        }
    }

    public synchronized void loginOut(int from) {
        this.loginOut(from, null);
    }

    public void openLoginSelectWindow(int loginSource, boolean ani, ILoginWindowFinish callBack) {
        this.openLoginSelectWindow(loginSource, Integer.MIN_VALUE, ani, callBack, "");
    }

    public void checkAutoLogin(boolean isCmdMonitor) {
        AutoLoginUtil.checkAutoLogin(this, isCmdMonitor);
    }

    public void startAutoReLogin(IAutoReloginCallBack callBack) {
        this.getSilentAccountReLoginController().handleAutoRelogin(callBack);
    }

    private void openLoginSelectWindow(int loginSource, int guestWindowType, boolean ani, ILoginWindowFinish callBack, String pageType) {
        this.mGuestReportInfo = new LoginGuestReportInfo(loginSource, guestWindowType);
        this.openLoginSelectWindow(ani, callBack, pageType);
    }

    private void openLoginSelectWindow(boolean ani, ILoginWindowFinish callBack, String pageType) {
        AccountInfo accountInfo;
        MLog.info((Object)TAG, (String)"openLoginSelectWindow  mGuestReportInfo: %s", (Object[])new Object[]{this.mGuestReportInfo});
        long uptimeMillis = SystemClock.uptimeMillis();
        HiidoEvent event = HiidoEvent.obtain().eventId("20023769").put("function_id", "login_page_show").put("comsumetime", String.valueOf(uptimeMillis - RuntimeContext.sAppOncreateTime)).put("reward_coins", String.valueOf(((ICoinsService)ServiceManagerProxy.getService(ICoinsService.class)).realGuestRewardCoins()));
        if (this.mGuestReportInfo != null) {
            event.put("login_source", String.valueOf(this.mGuestReportInfo.loginSource));
        }
        HiidoStatis.reportEventNow((HiidoEvent)event);
        if (this.mSelectWindow == null) {
            this.mSelectWindow = new LoginTypeSelectWindow(this.mContext, this.mLoginTypeInfo, this);
            if (this.mGuestLoginController != null) {
                this.mGuestLoginController.enableAutoLogin(false);
            }
        }
        if ((accountInfo = AccountModel.getInstance().getAccountInfo()) != null && accountInfo.loginType == 10) {
            this.mSelectWindow.setCanPopByBackKey(true);
        } else {
            this.mSelectWindow.setCanPopByBackKey(false);
        }
        if (this.mWindowMgr.getCurrentWindow() != this.mSelectWindow) {
            this.mWindowMgr.pushWindow((AbstractWindow)this.mSelectWindow, ani);
            this.getNewUserLoginController().onLoginWindowShow();
            this.mLoginStatistics = new LoginStatistics();
            this.mLoginStatistics.onLoginSelectWindowShow(SystemClock.uptimeMillis());
            if (AccountModel.hasLoginedBefore() > 0) {
                this.getAccountReLoginController().updateCallFrom(10).openLoginWindow();
            }
        }
        if (callBack != null) {
            this.mWindowFinishCallBack = callBack;
        }
        if (!RuntimeContext.sIsAppStartFinishAfterThreeSecond) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLog.handleStartupFiveSecond();
                }
            }, (long)5000L);
        }
    }

    public void loginByGuestType(IGuestAutoLoginCallback callBack) {
        this.getGuestLoginController().startAutoLogin(callBack);
    }

    public void setFeedbackOpen() {
        this.isFeedbackOpen = true;
    }

    public void checkProfileUpdatedAfterStartupFinished() {
        final AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo == null || !accountInfo.isValid()) {
            return;
        }
        this.getProfileController().queryProfileHasUpdated(accountInfo.uuid, new BasicProfileController.IQueryHasProfileSettingUped(){

            @Override
            public void onSuccess(long uuid, boolean hasUpdated) {
                if (hasUpdated || BasicProfileController.getProfileHasUpdatedFlagFromCache(uuid)) {
                    return;
                }
                MLog.info((Object)LoginController.TAG, (String)"check profile no updated!", (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractLoginer loginer = null;
                        if (accountInfo.loginType == 4) {
                            loginer = LoginController.this.getLineLoginController();
                        } else if (accountInfo.loginType == 3) {
                            loginer = LoginController.this.getGoogleLoginController();
                        } else if (accountInfo.loginType == 1) {
                            loginer = LoginController.this.getFacebookLoginController();
                        } else if (accountInfo.loginType == 7) {
                            loginer = LoginController.this.getZaloLoginController();
                        }
                        if (loginer != null) {
                            final LineLoginController innerLoginer = loginer;
                            ((AbstractLoginer)loginer).getUserInfo(accountInfo, new IUserInfoCallBack(){

                                @Override
                                public void onSuccess(UserInfoBean userInfoBean) {
                                    MLog.info((Object)LoginController.TAG, (String)"checkProfileUpdatedAfterStartupFinished ", (Object[])new Object[0]);
                                    LoginController.this.reportLoginStatistics(innerLoginer, userInfoBean);
                                    if (userInfoBean != null) {
                                        LoginController.this.getProfileController().openProfileEditWindow(userInfoBean);
                                    } else {
                                        LoginController.this.getProfileController().openProfileEditWindow();
                                    }
                                }

                                @Override
                                public void onError(String errorCode, String des) {
                                    LoginController.this.reportLoginStatistics(innerLoginer, null);
                                    LoginController.this.getProfileController().openProfileEditWindow();
                                }
                            });
                        } else {
                            LoginController.this.getProfileController().openProfileEditWindow();
                        }
                    }
                });
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SingleToastUtil.showToast((Context)LoginController.this.mContext, (String)ResourceUtils.getString((int)R.string.login_consummate_profile_please));
                    }
                }, (long)300L);
            }

            @Override
            public void onError(long uuid, String errorCode, String errorDes) {
            }
        });
    }

    public boolean interceptBackEvent() {
        if (this.mHasInterceptBackEvent) {
            return false;
        }
        if (AccountModel.hasLoginedBefore() > 0 || AccountUtil.getUid() > 0L) {
            return false;
        }
        if (this.mLoginFailTimes <= 1) {
            this.showLoginGuideByBackEvent();
            return true;
        }
        return false;
    }

    private void showLoginGuideByBackEvent() {
        if (this.interceptLoginTypeSelected()) {
            return;
        }
        this.mHasInterceptBackEvent = true;
        this.getGuestLoginController().openLoginDialog(this.mLastLoginType, true);
    }

    private void reportLoginSex(int sex, int pageId) {
        int reportSex = 0;
        if (sex == 0) {
            reportSex = 2;
        } else if (sex == 1) {
            reportSex = 1;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("page_id", String.valueOf(pageId)).put("enter_gender", String.valueOf(reportSex)));
    }

    public void reportLocation(final String location, final String longitude, final String latitude, final OnReportCallback callback) {
        long uuid = AccountUtil.getUid();
        if (uuid > 0L) {
            this.getProfileController().queryProfileHasUpdated(uuid, new BasicProfileController.IQueryHasProfileSettingUped(){

                @Override
                public void onSuccess(long uuid, boolean hasUpdated) {
                    if (hasUpdated) {
                        LoginController.this.getLoginRequester().reportLocation(location, longitude, latitude, callback);
                    }
                }

                @Override
                public void onError(long uuid, String errorCode, String errorDes) {
                    if (callback != null) {
                        callback.onError(-1, errorDes);
                    }
                }
            });
        } else if (callback != null) {
            callback.onError(-1, "");
        }
    }

    private void initRefreshTokenFlag() {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info == null || StringUtils.isEmpty((String)info.token) || info.uuid <= 0L) {
            this.mNeedRefreshAccountToken = false;
        }
    }

    private void checkToken() {
        if (this.mFacebookEnable) {
            this.getFacebookLoginController().checkToken();
        }
    }

    private void refreshAccountToken() {
        AccountInfo info;
        if (this.mNeedRefreshAccountToken && !this.mAccountTokenRefreshing && (info = AccountModel.getInstance().getAccountInfo()) != null && StringUtils.isNotEmpty((String)info.token) && NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.mAccountTokenRefreshing = true;
            this.mRefreshTokenTime = System.currentTimeMillis();
            final long uid = info.uuid;
            this.getLoginRequester().refreshAccountToken(info.uuid, info.token, info.sessionKey, new ILoginRequestCallBack(){

                public void onSuccess(LoginData data) {
                    AccountInfo infoTwo = AccountModel.getInstance().getAccountInfo();
                    if (infoTwo != null && infoTwo.uuid > 0L && uid == infoTwo.uuid) {
                        MLog.info((Object)LoginController.TAG, (String)"refreshAccountToken %s", (Object[])new Object[]{data});
                        AccountInfo accountInfo = AccountInfo.obtain((LoginData)data);
                        accountInfo.loginType = infoTwo.loginType;
                        LoginController.this.handleUpdateLoginData(accountInfo);
                    }
                    LoginController.this.mNeedRefreshAccountToken = false;
                    LoginController.this.mAccountTokenRefreshing = false;
                    long time = System.currentTimeMillis() - LoginController.this.mRefreshTokenTime;
                    LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/refreshAuth");
                }

                public void onError(String errorCode, String errorDescription, String exceptionDue) {
                    LoginController.this.mAccountTokenRefreshing = false;
                    MLog.error((Object)LoginController.TAG, (String)"refreshAccountToken error:%s", (Object[])new Object[]{errorCode});
                    if (ResponseCode.isTokenInValidError((String)errorCode)) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoginController.this.loginOut(5);
                            }
                        }, (long)(RuntimeContext.sIsAppStartFinished ? 0L : 2000L));
                    } else if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                LoginController.this.refreshAccountToken();
                            }
                        }, (long)600000L);
                    }
                    long time = System.currentTimeMillis() - LoginController.this.mRefreshTokenTime;
                    LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/refreshAuth");
                }
            });
        }
    }

    private void handleUpdateLoginData(AccountInfo accountInfo) {
        this.handleUpdateLoginData(accountInfo, false);
    }

    private void updateLoginDataToAccount(AccountInfo accountInfo, boolean byLogin) {
        if (accountInfo != null && accountInfo.lifecycle > 60L) {
            accountInfo.lifecycle -= 60L;
        }
        AccountModel.getInstance().updateLoginData(accountInfo, byLogin);
    }

    private void handleUpdateLoginData(AccountInfo accountInfo, boolean byLogin) {
        this.updateLoginDataToAccount(accountInfo, byLogin);
        if (this.getLoginRequester() != null) {
            SolidManager.getInstance().startSolidProcess(accountInfo, this.getLoginRequester());
        }
        if (accountInfo != null && accountInfo.lifecycle > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginController.this.mNeedRefreshAccountToken = true;
                    LoginController.this.refreshAccountToken();
                }
            }, (long)(accountInfo.lifecycle * 60L * 1000L));
        }
    }

    private void popAllWindow(boolean autoRelogin) {
        MLog.info((Object)TAG, (String)"popAllWindow", (Object[])new Object[0]);
        if (this.mWindowFinishCallBack != null) {
            this.mWindowFinishCallBack.onLoginWindowFinish();
            this.mWindowFinishCallBack = null;
        }
        if (this.isAfterLoginAndProfileFinishNotify() && this.notifyLoginSuccess != null) {
            this.notifyLoginSuccess.run();
            this.notifyLoginSuccess = null;
        }
        ImeUtil.hideIME((Activity)((Activity)this.mContext));
        if (this.mPhoneController != null) {
            this.mPhoneController.popAllWindow();
        }
        if (this.mWhatsAppController != null) {
            this.mWhatsAppController.popAllWindow();
        }
        if (this.mFaceBookController != null) {
            this.mFaceBookController.popAllWindow();
        }
        if (this.mGuestLoginController != null) {
            this.mGuestLoginController.popAllWindow();
        }
        this.mWindowMgr.popWindow(false, (AbstractWindow)this.mSelectWindow);
        this.getNewUserLoginController().onLoginWindowHide();
        if (!autoRelogin) {
            this.sendMessage(BaseMsgDef.HOMEMAIN_SHOW);
            if (this.mLoginStatistics != null) {
                this.mLoginStatistics.onLoginAllWindowClose();
                this.mLoginStatistics = null;
            }
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_LOGIN_PROCESS_COMPLETED));
        }
    }

    private boolean isFacebookLoginType() {
        AccountInfo info = AccountModel.getInstance().getAccountInfo();
        return info != null && info.loginType == 1;
    }

    private void updateFacebookBindStatu(long uuid, String faceBookUserId) {
        SettingFlags.setBoolean((String)(KEY_FACEBOOK_BIND + uuid), (boolean)true);
        SettingFlags.setStringValue((String)(KEY_FACEBOOK_BIND_USERID + uuid), (String)faceBookUserId);
    }

    private void handleBindFacebook(final IBindThirdPartyAccountCallBack fCallBack) {
        this.getFacebookLoginController().authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                AccountInfo info = AccountModel.getInstance().getAccountInfo();
                if (result == null || info == null) {
                    if (fCallBack != null) {
                        fCallBack.onError(-1, (Exception)new RuntimeException("login result empty!"));
                    }
                    MLog.error((Object)LoginController.TAG, (String)"handleBindFacebook accountInfo null! ", (Object[])new Object[0]);
                    return;
                }
                LoginController.this.mFacebookLoginResult = result;
                final long uuid = info.uuid;
                final String userid = result.authorizedData.userId;
                String tokenStr = result.authorizedData.tokenStr;
                String appId = result.authorizedData.appId;
                String mail = result.authorizedData.mail;
                LoginController.this.getLoginRequester().bingThirdParty(info, 5, appId, tokenStr, userid, mail, new ILoginRequestCallBack(){

                    public void onSuccess(LoginData data) {
                        AccountInfo curInfo = AccountModel.getInstance().getAccountInfo();
                        if (curInfo != null && curInfo.uuid == uuid) {
                            AccountInfo accountInfo = AccountInfo.obtain((LoginData)data);
                            LoginController.this.handleUpdateLoginData(accountInfo);
                        }
                        LoginController.this.updateFacebookBindStatu(uuid, userid);
                        if (fCallBack != null) {
                            fCallBack.onSuccess();
                        }
                        MLog.info((Object)LoginController.TAG, (String)"handleBindFacebook bind success! ", (Object[])new Object[0]);
                    }

                    public void onError(String errorCode, String errorDescription, String exceptionDue) {
                        if (errorCode != null && errorCode.equals("20411")) {
                            LoginController.this.updateFacebookBindStatu(uuid, userid);
                            if (fCallBack != null) {
                                fCallBack.onSuccess();
                            }
                            MLog.info((Object)LoginController.TAG, (String)"handleBindFacebook bind success! ", (Object[])new Object[0]);
                            return;
                        }
                        if (fCallBack != null) {
                            fCallBack.onError(StringUtils.parseInt((String)errorCode), (Exception)new RuntimeException(errorDescription));
                        }
                        MLog.error((Object)LoginController.TAG, (String)"handleBindFacebook bind error:%s %s! ", (Object[])new Object[]{errorCode, errorDescription});
                    }
                });
            }

            public void onCancel() {
                if (fCallBack != null) {
                    fCallBack.onCancel();
                }
            }

            public void onError(int errorCode, Exception e) {
                if (fCallBack != null) {
                    fCallBack.onError(errorCode, e);
                }
                MLog.error((Object)LoginController.TAG, (String)"handleBindFacebook auth error:%d %s", (Object[])new Object[]{errorCode, e != null ? e.toString() : ""});
            }
        });
    }

    private boolean getFacebookBindStatus(Message msg) {
        if (this.isFacebookLoginType()) {
            MLog.info((Object)TAG, (String)"binded facebook Login!", (Object[])new Object[0]);
            return true;
        }
        boolean result = false;
        final AccountInfo info = AccountModel.getInstance().getAccountInfo();
        if (info != null && info.uuid > -1L) {
            result = SettingFlags.getBoolean((String)(KEY_FACEBOOK_BIND + info.uuid), (boolean)false);
        }
        if (!result && info != null) {
            IQueryThirdPartyCallBack callBack = null;
            if (msg != null && msg.obj instanceof IQueryThirdPartyCallBack) {
                callBack = (IQueryThirdPartyCallBack)msg.obj;
            }
            final IQueryThirdPartyCallBack fCallBack = callBack;
            final long uuid = info.uuid;
            this.getLoginRequester().queryThirdParty(info, new IQueryThirdPartyAccountCallBack(){

                @Override
                public void onSuccess(SparseArray<String> thirdPartyUserId) {
                    SettingFlags.setBoolean((String)(LoginController.KEY_FACEBOOK_HAS_CHECK_BIND + info.uuid), (boolean)true);
                    if (thirdPartyUserId != null) {
                        String faceBookUserId = (String)thirdPartyUserId.get(5);
                        if (StringUtils.isNotEmpty((String)faceBookUserId)) {
                            LoginController.this.updateFacebookBindStatu(uuid, faceBookUserId);
                            if (fCallBack != null) {
                                fCallBack.onSuccess(true, faceBookUserId);
                            }
                            MLog.info((Object)LoginController.TAG, (String)"has binded! ", (Object[])new Object[0]);
                        } else {
                            if (fCallBack != null) {
                                fCallBack.onSuccess(false, "");
                            }
                            MLog.info((Object)LoginController.TAG, (String)"has not binded! ", (Object[])new Object[0]);
                        }
                    } else if (fCallBack != null) {
                        fCallBack.onError(-1, (Throwable)new RuntimeException(""));
                        MLog.error((Object)LoginController.TAG, (String)"get bind statu errored empty!", (Object[])new Object[0]);
                    }
                }

                @Override
                public void onError(String errorCode, Throwable e) {
                    if (fCallBack != null) {
                        fCallBack.onError(StringUtils.parseInt((String)errorCode), e);
                    }
                    MLog.error((Object)LoginController.TAG, (String)"get bind statu errored:%s %s", (Object[])new Object[]{errorCode, e != null ? e.toString() : ""});
                }
            });
        } else {
            MLog.info((Object)TAG, (String)"has binded!", (Object[])new Object[0]);
        }
        return result;
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        this.mOpenPrivacyWeb = false;
        if (this.isFeedbackOpen && this.mLoginFeedbackView != null && abstractWindow instanceof LoginTypeSelectWindow) {
            this.showLoginHelp(true);
        }
        this.isFeedbackOpen = false;
        if (AccountModel.hasLoginedBefore() == -1 && this.mNonLoginReport == null) {
            this.mNonLoginReport = new NonLoginReport();
        }
    }

    public void onWindowHidden(AbstractWindow abstractWindow) {
        super.onWindowHidden(abstractWindow);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (LoginController.this.isFeedbackOpen || LoginController.this.mOpenPrivacyWeb || AccountUtil.getUid() > 0L || LoginController.this.mWindowMgr.getCurrentWindow() == LoginController.this.mSelectWindow) {
                    return;
                }
                if (SystemUtils.isShowEnvSetting() && LoginController.this.mWindowMgr.getCurrentWindow() != null && LoginController.this.mWindowMgr.getCurrentWindow().getWindowType() == 104) {
                    return;
                }
                if (!(LoginController.this.getPhoneLoginController().isPhoneRelatedWindowShowing() || LoginController.this.getWhatsAppController().isPhoneRelatedWindowShowing() || LoginController.this.getProfileController().isCurPhoneBasicProfileWindow())) {
                    MLog.info((Object)LoginController.TAG, (String)"onWindowHidden openLoginSelect", (Object[])new Object[0]);
                    LoginController.this.openLoginSelectWindow(true, null, "");
                }
            }
        });
    }

    public void handleMessage(Message msg) {
        if (msg.what == LoginMsgDef.MSG_LOGIN_OUT) {
            this.loginOut(msg.arg1);
        } else if (msg.what == LoginMsgDef.MSG_LOGIN_RELOGIN_DIALOG) {
            this.getAccountReLoginController().updateCallFrom(msg.arg1).openLoginWindow();
        } else if (msg.what == LoginMsgDef.MSG_FACEBOOK_BIND_ACCOUNT) {
            if (this.mFacebookEnable) {
                IBindThirdPartyAccountCallBack callBack = null;
                if (msg.obj instanceof IBindThirdPartyAccountCallBack) {
                    callBack = (IBindThirdPartyAccountCallBack)msg.obj;
                }
                IBindThirdPartyAccountCallBack fCallBack = callBack;
                if (this.isFacebookLoginType()) {
                    if (callBack != null) {
                        callBack.onSuccess();
                    }
                } else {
                    this.handleBindFacebook(fCallBack);
                }
            }
        } else if (msg.what == LoginMsgDef.MSG_ZALO_BIND_ACCOUNT) {
            IBindThirdPartyAccountCallBack callBack = null;
            if (msg.obj instanceof IBindThirdPartyAccountCallBack) {
                callBack = (IBindThirdPartyAccountCallBack)msg.obj;
            }
            this.bindZaloAccount(callBack);
        } else if (msg.what == BaseMsgDef.MSG_ZALO_BIND_SWITCH_ACCOUNT) {
            IZaloAccountSwitch callBack = null;
            if (msg.obj instanceof IZaloAccountSwitch) {
                callBack = (IZaloAccountSwitch)msg.obj;
                this.getZaloLoginController().handleSwitchLoginResult(callBack);
            }
        } else if (msg.what == LoginMsgDef.MSG_FACEBOOK_AUTHORIZATION) {
            if (this.mFacebookEnable) {
                IThirdPartyAuthorizationCallBack callBack = null;
                if (msg.obj instanceof IThirdPartyAuthorizationCallBack) {
                    callBack = (IThirdPartyAuthorizationCallBack)msg.obj;
                }
                this.getFacebookLoginController().authorization(callBack);
            }
        } else if (msg.what == LoginMsgDef.MSG_LOGIN_OPEN_WINDOW) {
            MLog.info((Object)TAG, (String)"handle MSG_LOGIN_OPEN_WINDOW", (Object[])new Object[0]);
            ILoginWindowFinish callBack = null;
            if (msg.obj instanceof ILoginWindowFinish) {
                callBack = (ILoginWindowFinish)msg.obj;
            }
            if (msg.obj instanceof IGuestLoginChangedCallback) {
                this.mGuestLoginChangedCallback = (IGuestLoginChangedCallback)msg.obj;
            }
            int loginSource = 0;
            int guestWindowType = Integer.MIN_VALUE;
            String pageType = "";
            if (msg.getData() != null) {
                loginSource = msg.getData().getInt("key_login_source", 0);
                guestWindowType = msg.getData().getInt("key_guest_window_type", Integer.MIN_VALUE);
                pageType = msg.getData().getString("key_guest_page_type", "");
                this.getNewUserLoginController().setMLoginGameID(msg.getData().getString("key_guest_gameID", ""));
            }
            this.openLoginSelectWindow(loginSource, guestWindowType, true, callBack, pageType);
        } else if (msg.what == LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW) {
            this.showLoginHelp(false);
        } else if (msg.what == LoginMsgDef.MSG_GUEST_LOGIN_WITH_TYPE) {
            int loginType;
            if (msg.obj instanceof IGuestLoginChangedCallback) {
                this.mGuestLoginChangedCallback = (IGuestLoginChangedCallback)msg.obj;
            }
            Bundle bundle = msg.getData();
            int n = loginType = this.mLoginTypeInfo.mainType == null ? LoginTypeData.INVALID.getType() : this.mLoginTypeInfo.mainType.getType();
            if (bundle != null) {
                loginType = bundle.getInt("key_login_type", loginType);
                this.mLoginFromGid = bundle.getString("gid", "");
                int loginSource = bundle.getInt("key_login_source", 1);
                int guestWindowType = bundle.getInt("key_guest_window_type", -1);
                this.mGuestReportInfo = new LoginGuestReportInfo(loginSource, guestWindowType);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", LoginType.getReportName((int)loginType) + "_click").put("click_source", "4").put("login_source", String.valueOf(loginSource)).put("last_login_type", "1").put("guest_window_type", String.valueOf(guestWindowType)));
            }
            if (msg.arg1 > 0) {
                this.mLoginCallFrom = msg.arg1;
            }
            switch (loginType) {
                case 1: {
                    if (!this.mFacebookEnable) break;
                    this.getFacebookLoginController().openLoginWindow();
                    break;
                }
                case 3: {
                    this.getGoogleLoginController().openLoginWindow();
                    break;
                }
                case 2: {
                    this.getPhoneLoginController().openLoginWindow();
                    break;
                }
                case 4: {
                    this.getLineLoginController().openLoginWindow();
                    break;
                }
                case 8: {
                    this.getWhatsAppController().openLoginWindow();
                    break;
                }
                case 5: {
                    this.getVkLoginController().openLoginWindow();
                    break;
                }
                case 9: {
                    this.getSnapChatLoginController().openLoginWindow();
                    break;
                }
                case 7: {
                    this.getZaloLoginController().openLoginWindow();
                    break;
                }
            }
        } else if (msg.what == BaseMsgDef.MSG_FACEBOOK_SWITCH_BIND) {
            if (this.mFacebookEnable && this.mFacebookLoginResult != null) {
                IFacebookLoginCallback callback = null;
                if (msg.obj instanceof IFacebookLoginCallback) {
                    callback = (IFacebookLoginCallback)msg.obj;
                }
                this.getFacebookLoginController().setFacebookLoginCallback(callback);
                this.getFacebookLoginController().handleLoginResult(this.mFacebookLoginResult);
            }
        } else if (msg.what == BaseMsgDef.MSG_FACEBOOK_LOGOUT) {
            if (this.mFacebookEnable) {
                this.getFacebookLoginController().logout();
            }
        } else if (msg.what == LoginBaseMsgDef.MSG_REPORT_LOCATION) {
            HashMap map = (HashMap)msg.obj;
            String city = (String)map.get("city");
            String longitude = (String)map.get("longitude");
            String latitude = (String)map.get("latitude");
            OnReportCallback callback = (OnReportCallback)map.get("callBack");
            this.reportLocation(city, longitude, latitude, callback);
        } else if (msg.what == BaseMsgDef.MSG_ACCOUNT_FEED_BACK_COMPLAIN) {
            this.setFeedbackOpen();
            Message message = Message.obtain();
            message.what = BaseMsgDef.SHOW_WINDOW_FEEDBACK;
            message.arg1 = 1;
            message.arg2 = 4;
            Bundle bundle = new Bundle();
            bundle.putInt("fromBanned", 1);
            message.setData(bundle);
            this.sendMessage(message);
        } else if (msg.what == LoginMsgDef.MSG_GUEST_LOGIN) {
            this.getGuestLoginController().openLoginWindow();
        } else if (msg.what == LoginBaseMsgDef.MSG_UPDATE_LOGINED_ACCOUNT_USERINFO) {
            if (msg.obj instanceof List) {
                AccountModel.getInstance().updateLoginedAccountUserInfo((List)msg.obj);
            }
        } else if (msg.what == LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME) {
            if (this.mSelectWindow != null) {
                this.mSelectWindow.returnFromOtherLoginType();
            }
        } else if (msg.what == LoginMsgDef.OPEN_PROFILE_WINDOW_RESET_AGE) {
            if (NAB.B.equals((Object)NewABDefine.HAGO_AGE_BLOCK.getTest()) && msg.obj instanceof UserInfoBean) {
                this.getProfileController().openProfileEditWindow((UserInfoBean)msg.obj);
            }
        } else if (msg.what == LoginMsgDef.MSG_LOGIN_SET_PWD) {
            this.getPhoneLoginController().onGoPhoneWindow(5);
        } else if (msg.what == LoginMsgDef.MSG_LOGIN_RESET_PWD) {
            this.getPhoneLoginController().onGoPhoneWindow(6);
        }
    }

    private void bindZaloAccount(final IBindThirdPartyAccountCallBack callBack) {
        ZaloBindAccount.bindZaloAccount(this.getZaloLoginController(), new IBindZaloAccount(){

            @Override
            public void onSuccess(AccountInfo accountInfo) {
                LoginController.this.handleUpdateLoginData(accountInfo);
                if (callBack != null) {
                    callBack.onSuccess();
                }
            }

            @Override
            public void onCancel() {
                if (callBack != null) {
                    callBack.onCancel();
                }
            }

            @Override
            public void onError(int errorCode, Exception e) {
                if (callBack != null) {
                    callBack.onError(errorCode, e);
                }
            }
        });
    }

    private void showLoginHelp(boolean fromFeedBack) {
        boolean show = true;
        boolean showGuest = false;
        if (this.mLoginFailConsume <= 0L && this.mStartLoginTime > 0L) {
            this.mLoginFailConsume = System.currentTimeMillis() - this.mStartLoginTime;
        }
        if (AccountModel.hasLoginedBefore() < 0) {
            if (this.mLoginFailConsume > 30000L || this.mLoginFailTimes >= 2) {
                showGuest = true;
            } else if (fromFeedBack) {
                show = false;
            }
        } else if (fromFeedBack) {
            show = false;
        }
        if (AccountUtil.isLoginByGuest()) {
            showGuest = false;
            if (fromFeedBack) {
                show = false;
            }
        }
        if (showGuest &= this.canShowGuestDialog()) {
            this.getGuestLoginController().openLoginDialog(this.mLoginType, false);
        } else if (show) {
            if (this.mLoginFeedbackView == null) {
                this.mLoginFeedbackView = new LoginFeedbackView(this.mContext);
            }
            this.mLoginFeedbackView.setOnFeedbackClick(new View.OnClickListener(){

                public void onClick(View v) {
                    if (v.getId() == R.id.tv_login_feedback) {
                        LoginController.this.showFeedBack();
                    }
                }
            });
            this.mLoginFeedbackView.showFeedback();
            if (this.mLoginFeedbackView != null) {
                this.mWindowMgr.addExtLayerContent((View)this.mLoginFeedbackView);
            }
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mHideFeedbackTask);
            YYTaskExecutor.postToMainThread((Runnable)this.mHideFeedbackTask, (long)5000L);
        }
        if (showGuest) {
            this.reportShowGuestBtn(2);
        }
        this.mLoginType = -1;
    }

    private boolean canShowGuestDialog() {
        return this.mLoginType != 10 && this.mLoginType != -1 && this.mLoginType != 2 && !StringUtils.equal((String)this.mErrorCode, (String)"122");
    }

    private void onLoginTypeSelected(int callFrom, int type, long lastLoginUid) {
        if (this.mHideFeedbackTask != null) {
            this.mHideFeedbackTask.run();
        }
        NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        this.mLoginType = type;
        this.mLastLoginType = type;
        this.mStartLoginTime = System.currentTimeMillis();
        this.mLoginFailConsume = -1L;
        this.mLoginCallFrom = callFrom;
        switch (type) {
            case 1: {
                if (!this.mFacebookEnable) break;
                this.getFacebookLoginController().openLoginWindow();
                break;
            }
            case 2: {
                this.getPhoneLoginController().updateLoginUid(lastLoginUid).openLoginWindow();
                break;
            }
            case 3: {
                this.getGoogleLoginController().openLoginWindow();
                break;
            }
            case 4: {
                this.getLineLoginController().openLoginWindow();
                break;
            }
            case 10: {
                this.getGuestLoginController().openLoginWindow();
                break;
            }
            case 5: {
                this.getVkLoginController().openLoginWindow();
                break;
            }
            case 7: {
                this.getZaloLoginController().openLoginWindow();
                break;
            }
            case 8: {
                this.getWhatsAppController().openLoginWindow();
                break;
            }
            case 9: {
                this.getSnapChatLoginController().openLoginWindow();
                break;
            }
        }
        if (this.mSelectWindow != null) {
            this.mSelectWindow.enterOtherLoginType();
        }
        if (this.mSnapChatLoginController != null) {
            this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT, type, 0);
        }
        LoginTrack.reportLoginTypeSelect(type, this.getLoginTrackExtra(null), this.mGuestReportInfo);
        if (this.mLoginStatistics != null) {
            this.mLoginStatistics.onLoginSelected(type);
        }
    }

    @Override
    public boolean interceptLoginTypeSelected() {
        if (RegisterUtils.isShowCheckingPolicyView() && !RegisterUtils.isPolicyViewCheckedState()) {
            String toastStr = ResourceUtils.getString((int)R.string.login_user_not_checked_privacy, (Object[])new Object[]{ResourceUtils.getString((int)R.string.short_tips_terms_of_service), ResourceUtils.getString((int)R.string.short_tips_privacy_policy)});
            TopToastUtils.showToast((CharSequence)toastStr, (int)1, (int)ResourceUtils.getColor((int)R.color.error_toast_bg), (boolean)false);
            return true;
        }
        return false;
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == LoginMsgDef.MSG_GET_FACEBOOK_BIND_STATU) {
            if (this.mFacebookEnable) {
                return this.getFacebookBindStatus(msg);
            }
            return false;
        }
        if (msg.what == BaseMsgDef.MSG_GET_FACEBOOK_USER_ID) {
            AccountInfo info = AccountModel.getInstance().getAccountInfo();
            if (info != null && info.uuid > -1L) {
                if (SettingFlags.getBoolean((String)(KEY_FACEBOOK_BIND + info.uuid), (boolean)false)) {
                    return SettingFlags.getStringValue((String)(KEY_FACEBOOK_BIND_USERID + info.uuid));
                }
                boolean hasCheck = SettingFlags.getBoolean((String)(KEY_FACEBOOK_HAS_CHECK_BIND + info.uuid), (boolean)false);
                if (!hasCheck) {
                    MLog.info((Object)TAG, (String)"\u7528\u6237\u672a\u68c0\u67e5\u7ed1\u5b9a\u72b6\u6001\uff0c\u68c0\u67e5\u4e00\u6b21", (Object[])new Object[0]);
                    this.getFacebookBindStatus(null);
                }
                return "";
            }
        } else {
            if (LoginMsgDef.MSG_ZALO_BIND_ACCOUNT_STATU == msg.what) {
                IQueryThirdPartyCallBack callBack = null;
                if (msg.obj instanceof IQueryThirdPartyCallBack) {
                    callBack = (IQueryThirdPartyCallBack)msg.obj;
                }
                return ZaloBindAccount.getZaloBindStatu(callBack);
            }
            if (LoginBaseMsgDef.MSG_GET_CUR_ACCOUNT_SEX == msg.what) {
                return AccountModel.getInstance().getAccountInfo().sex;
            }
        }
        return super.handleMessageSync(msg);
    }

    @Override
    public void onLoginTypeSelected(int type) {
        this.onLoginTypeSelected(1, type, 0L);
    }

    @Override
    public void onPrivacyClicked() {
        this.mOpenPrivacyWeb = true;
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(UriProvider.getPrivacyPolicyUrl(), "");
    }

    @Override
    public void onTermsOfServiceClicked() {
        this.mOpenPrivacyWeb = true;
        ((IWebService)this.getServiceManager().getService(IWebService.class)).loadUrl(UriProvider.getTermsOfServiceUrl(), "");
    }

    @Override
    public void onEvnSettingClicked() {
        this.sendMessage(BaseMsgDef.SHOW_ENV_SETTINGS_WINDOW);
    }

    @Override
    public void onCloseClicked() {
        this.mWindowMgr.popWindow(false, (AbstractWindow)this.mSelectWindow);
        if (this.mWindowFinishCallBack != null) {
            this.mWindowFinishCallBack.onLoginWindowClosed();
        }
    }

    @Override
    public void reportShowGuestBtn(int position) {
        HiidoEvent event = HiidoEvent.obtain().eventId("20023769").put("function_id", "guest_login_show").put("click_source", "1").put("position", String.valueOf(position));
        if (this.mGuestReportInfo != null) {
            event = this.mGuestReportInfo.generateHiidoEvent(event);
        }
        HiidoStatis.reportEventNow((HiidoEvent)event);
    }

    @Override
    public LoginRequestManager getLoginRequester() {
        return LoginRequestManager.getInstance();
    }

    @Override
    public LoginStatistics getLoginStater() {
        return this.mLoginStatistics;
    }

    @Override
    public void loginByOtherType(int callFrom, int loginType, long lastLoginUid) {
        this.onLoginTypeSelected(callFrom, loginType, lastLoginUid);
    }

    @Override
    public void loginByOtherType(int callFrom, int loginType) {
        this.onLoginTypeSelected(callFrom, loginType, 0L);
    }

    @Override
    public void showFeedBack() {
        if (this.mLoginFeedbackView != null) {
            this.mWindowMgr.removeExtLayerContent((View)this.mLoginFeedbackView);
        }
        this.setFeedbackOpen();
        this.sendMessage(BaseMsgDef.SHOW_WINDOW_FEEDBACK, 1, 2, null);
    }

    @Override
    public void onLoginStart(AbstractLoginer loginer) {
        this.onLoginStart(loginer, false);
    }

    @Override
    public void onLoginStart(AbstractLoginer loginer, boolean silent) {
        if (!silent) {
            this.getDialogLinkManager().dismissDialog();
            MLog.info((Object)TAG, (String)"login start!", (Object[])new Object[0]);
            this.getDialogLinkManager().showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.logining), false, false, null));
        }
    }

    @Override
    public void onLoginSuccess(final AbstractLoginer loginer, final AccountInfo accountInfo) {
        if (accountInfo == null || !accountInfo.isValid()) {
            this.onLoginError(loginer, "114", "");
            return;
        }
        final Runnable logoutAction = new Runnable(){

            @Override
            public void run() {
                LoginController.this.getNewUserLoginController().onLoginSuccess();
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        if (accountInfo.auth_app) {
                            LoginController.this.doHandleLoginSuccess(loginer, accountInfo);
                        } else {
                            new LoginAuthDialog(LoginController.this.getEnvironment().getContext(), accountInfo.isNewRegister(), v -> {
                                LoginController.this.doHandleLoginSuccess(loginer, accountInfo);
                                YYTaskExecutor.execute(() -> LoginController.this.getLoginRequester().reportLoginAuth(loginer, accountInfo), (long)5000L);
                            }, v -> LoginController.this.onLoginError(loginer, "-10086", ""), accountInfo.uuid).show();
                        }
                        LanguageLocaleHelper.saveRealCountry((String)accountInfo.realCountry);
                        LoginTrack.checkReportAbnormalAccount(accountInfo);
                    }
                };
                int waitForHomePage = SettingFlags.getIntValue((String)"homepagepreload_opt", (int)-1);
                if (waitForHomePage <= 1000 && SystemUtils.isShowEnvSetting()) {
                    waitForHomePage = 3000;
                }
                if (waitForHomePage > 1000 && LoginController.this.needPreloadHomeWhenLogin) {
                    LoginController.this.updateLoginDataToAccount(accountInfo, true);
                    CommonBaseTransfer.onLogin((long)AccountUtil.getUid());
                    OkHttpDns.getInstance().onLoginSuccess();
                    ((IDBService)LoginController.this.getServiceManager().getService(IDBService.class)).loginIn();
                    if (LoginController.this.mWindowFinishCallBack != null) {
                        LoginController.this.mWindowFinishCallBack.preloadHomeData();
                    }
                    LoginController.this.needPreloadHomeWhenLogin = false;
                    MLog.info((Object)LoginController.TAG, (String)"handle login success, wait for home preload!", (Object[])new Object[0]);
                    YYTaskExecutor.postToMainThread((Runnable)command, (long)waitForHomePage);
                } else {
                    command.run();
                }
            }
        };
        if (AccountUtil.getUid() > 0L && AccountUtil.getUid() != accountInfo.uuid) {
            MLog.info((Object)TAG, (String)"\u5207\u6362\u8d26\u53f7\u767b\u5f55\u6210\u529f\uff0c\u5148\u767b\u51fa\u4e4b\u524d\u7684\u8d26\u53f7", (Object[])new Object[0]);
            this.loginOut(12, new Function0(){

                public Object invoke() {
                    logoutAction.run();
                    return null;
                }
            });
        } else {
            logoutAction.run();
        }
    }

    private void doHandleLoginSuccess(final AbstractLoginer loginer, AccountInfo accountInfo) {
        this.mLoginOutBy = -1;
        this.mLoginFailTimes = 0;
        if (this.mLoginFeedbackView != null) {
            this.mWindowMgr.removeExtLayerContent((View)this.mLoginFeedbackView);
            this.mLoginFeedbackView = null;
        }
        MLog.info((Object)TAG, (String)"login success", (Object[])new Object[0]);
        final long oldUid = AccountModel.getInstance().getAccountInfo().uuid;
        this.handleUpdateLoginData(accountInfo, true);
        CommonBaseTransfer.onLogin((long)AccountUtil.getUid());
        OkHttpDns.getInstance().onLoginSuccess();
        int statLoginType = loginer.getSelectLoginType();
        LoginTrack.reportLoginSuccess(statLoginType, System.currentTimeMillis() - this.mStartLoginTime, this.getLoginTrackExtra(loginer), this.mGuestReportInfo);
        if (this.mLoginStatistics != null) {
            this.mLoginStatistics.onLoginSuccess(statLoginType, loginer.getCurLoginAccount(), loginer.getLoginSuccessResult());
        }
        ((IDBService)this.getServiceManager().getService(IDBService.class)).loginIn();
        this.notifyLoginSuccess = new Runnable(){

            @Override
            public void run() {
                if (loginer != LoginController.this.getSilentAccountReLoginController()) {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_LOGIN_SUCCESS));
                    if (oldUid != AccountModel.getInstance().getAccountInfo().uuid) {
                        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (Object)oldUid));
                    }
                }
            }
        };
        if (!this.isAfterLoginAndProfileFinishNotify()) {
            this.notifyLoginSuccess.run();
            this.notifyLoginSuccess = null;
        }
        if (AccountUtil.isLoginByGuest()) {
            this.getDialogLinkManager().dismissDialog();
            this.popAllWindow(loginer == this.getSilentAccountReLoginController());
            return;
        }
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.WHATSAPP_LOGIN_LOGIN, (Object)loginer);
        MLog.info((Object)TAG, (String)"onLoginSuccess resultType=%d, stateLoginType=%d", (Object[])new Object[]{accountInfo.resultType, statLoginType});
        this.handleUserProfileAfterLogined(loginer, accountInfo);
        if (this.mGuestLoginChangedCallback != null) {
            this.mGuestLoginChangedCallback.onSuccess();
            this.mGuestLoginChangedCallback = null;
        }
        if (this.mWindowFinishCallBack != null) {
            this.mWindowFinishCallBack.onLoginSuccess();
        }
    }

    private void handleUserProfileAfterLogined(final AbstractLoginer loginer, final AccountInfo accountInfo) {
        boolean isLogined;
        boolean bl = isLogined = accountInfo.resultType == 1;
        if (isLogined) {
            this.getProfileController().queryProfileHasUpdated(accountInfo.uuid, new BasicProfileController.IQueryHasProfileSettingUped(){

                @Override
                public void onSuccess(long uuid, boolean hasUpdated) {
                    LoginController.this.getDialogLinkManager().dismissDialog();
                    MLog.info((Object)LoginController.TAG, (String)"login success check profile : hasUpdated %s", (Object[])new Object[]{hasUpdated ? "true" : "false"});
                    if (hasUpdated) {
                        LoginController.this.getProfileController().setProfileHasUpdated(accountInfo.uuid);
                        LoginController.this.popAllWindow(loginer == LoginController.this.getSilentAccountReLoginController());
                        if (loginer != LoginController.this.getSilentAccountReLoginController()) {
                            ServiceManagerProxy.getInstance().observeService(IHomeService.class, IHomeService::toGame);
                        }
                    } else {
                        LoginController.this.openProfileEditWindow(loginer, accountInfo);
                    }
                }

                @Override
                public void onError(long uuid, String errorCode, String errorDes) {
                    LoginController.this.getDialogLinkManager().dismissDialog();
                    MLog.info((Object)LoginController.TAG, (String)"login success check profile erorr!", (Object[])new Object[0]);
                    LoginController.this.popAllWindow(loginer == LoginController.this.getSilentAccountReLoginController());
                    if (RuntimeContext.sIsDebuggable) {
                        LoginController.this.onLoginError(loginer, errorCode, errorDes);
                    }
                }
            });
        } else {
            MLog.info((Object)TAG, (String)"onLoginSuccess resultType=%d", (Object[])new Object[]{accountInfo.resultType});
            this.openProfileEditWindow(loginer, accountInfo);
            if (AccountModel.getInstance().getAccountInfo().loginType != 2) {
                HiidoStatis.reportEventNow((HiidoEvent)HiidoEvent.obtain().eventId("20025801").put("data_source_id", "2"));
            }
        }
    }

    private void reportLoginStatistics(@NonNull AbstractLoginer loginer, @Nullable UserInfoBean userInfoBean) {
        int pageId = 0;
        if (loginer == this.mPhoneController) {
            pageId = 1;
        } else if (loginer == this.mGoogleLoginController) {
            pageId = 2;
        } else if (loginer == this.mLineLoginController) {
            pageId = 3;
        } else if (loginer == this.mFaceBookController) {
            pageId = 4;
        } else if (loginer == this.mZaloLoginController) {
            pageId = 5;
        }
        if (pageId != 0) {
            int sex = -1;
            if (userInfoBean != null) {
                sex = userInfoBean.getSex();
            }
            this.reportLoginSex(sex, pageId);
        }
    }

    private void openProfileEditWindow(final AbstractLoginer loginer, final AccountInfo accountInfo) {
        loginer.getUserInfo(accountInfo, new IUserInfoCallBack(){

            @Override
            public void onSuccess(UserInfoBean userInfoBean) {
                LoginController.this.getDialogLinkManager().dismissDialog();
                if (loginer == LoginController.this.mVkLoginController) {
                    LoginController.this.getProfileController().setProfileHasUpdated(accountInfo.uuid);
                    LoginController.this.popAllWindow(loginer == LoginController.this.getSilentAccountReLoginController());
                } else {
                    if (LoginController.this.mLoginStatistics != null) {
                        LoginController.this.mLoginStatistics.onProfileShowed();
                    }
                    LoginController.this.getProfileController().openProfileEditWindow(userInfoBean);
                }
                LoginController.this.reportLoginStatistics(loginer, userInfoBean);
            }

            @Override
            public void onError(String errorCode, String des) {
                LoginController.this.getDialogLinkManager().dismissDialog();
                if (LoginController.this.mLoginStatistics != null) {
                    LoginController.this.mLoginStatistics.onProfileShowed();
                }
                LoginController.this.getProfileController().openProfileEditWindow();
                LoginController.this.reportLoginStatistics(loginer, null);
            }
        });
    }

    @Override
    public void onLoginError(AbstractLoginer loginer, String errorCode, String errorDescription) {
        this.onLoginError(loginer, false, errorCode, errorDescription);
    }

    @Override
    public void onLoginError(AbstractLoginer loginer, boolean noTips, String errorCode, String errorDescription) {
        this.mErrorCode = errorCode;
        this.getDialogLinkManager().dismissDialog();
        ++this.mLoginFailTimes;
        if (loginer == this.mPhoneController || loginer == this.mWhatsAppController) {
            this.mLoginFailConsume = System.currentTimeMillis() - this.mStartLoginTime;
        }
        int loginType = loginer.getSelectLoginType();
        loginer.increaseErrorTimes();
        ArrayMap trackExtra = new ArrayMap();
        trackExtra.put("gid", this.mLoginFromGid);
        if (loginer instanceof PhoneLoginController) {
            boolean autoFillSms = ((PhoneLoginController)loginer).isAutoFillSms();
            trackExtra.put("autofillsms", autoFillSms ? "1" : "0");
        } else if (loginType == 6) {
            this.mLoginCallFrom = this.getAccountReLoginController().getCallFrom();
            trackExtra.put("history_id", this.getAccountReLoginController().getCurLoginAccount());
        }
        trackExtra.put("click_source", String.valueOf(this.mLoginCallFrom));
        LoginTrack.reportLoginError(loginType, System.currentTimeMillis() - this.mStartLoginTime, (Map<String, String>)trackExtra, this.mGuestReportInfo);
        String originErrorDes = errorDescription;
        String actualDesc = this.getErrorDescription(loginer, errorCode, errorDescription);
        if (StringUtils.isEmpty((String)originErrorDes)) {
            originErrorDes = actualDesc;
        }
        if (!noTips) {
            if (StringUtils.equal((String)errorCode, (String)"122")) {
                OkDialog dialog = new OkDialog((CharSequence)actualDesc, true, null);
                dialog.setShowCancel(false);
                this.getDialogLinkManager().showDialog((BaseDialog)dialog);
            } else if (StringUtils.equals((String)errorCode, (String)"120") || StringUtils.equals((String)errorCode, (String)"119") || StringUtils.equal((String)errorCode, (String)"20004") || StringUtils.equal((String)errorCode, (String)"20105") || StringUtils.equal((String)errorCode, (String)"30001")) {
                TopToastUtils.showToast((CharSequence)actualDesc, (int)1, (int)ResourceUtils.getColor((int)R.color.error_toast_bg), (boolean)false);
            } else {
                SingleToastUtil.showToast((Context)this.mContext, (String)actualDesc);
            }
        }
        if (this.mLoginStatistics != null) {
            this.mLoginStatistics.onLoginError(loginType, loginer.getCurLoginAccount(), errorCode, originErrorDes, loginer.getLoginSuccessResult(), loginer.getLoginErrorResult());
        }
    }

    private String getErrorDescription(AbstractLoginer loginer, String errorCode, String orinDesc) {
        String errorDes;
        if (loginer == this.mGuestLoginController) {
            errorDes = ResourceUtils.getString((int)R.string.guest_login_error);
        } else if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            errorDes = ResourceUtils.getString((int)R.string.check_network_and_retry);
        } else if (StringUtils.equals((String)errorCode, (String)"111")) {
            errorDes = ResourceUtils.getString((int)R.string.check_network_and_retry);
        } else if (StringUtils.equals((String)errorCode, (String)"114") || StringUtils.equals((String)errorCode, (String)"113") || StringUtils.equals((String)errorCode, (String)"112") || StringUtils.equals((String)errorCode, (String)"115")) {
            errorDes = ResourceUtils.getString((int)R.string.login_params_parse_error_and_retry);
        } else if (StringUtils.equals((String)errorCode, (String)"117")) {
            errorDes = ResourceUtils.getString((int)R.string.facebook_authorization_error);
            if (SettingFlags.getIntValue((String)"logintipstype", (int)1) == 2 && loginer.getLoginErrorTimes() <= 1) {
                errorDes = ResourceUtils.getString((int)R.string.tips_facebook_authorization_error_retry);
            }
        } else if (StringUtils.equal((String)errorCode, (String)"121")) {
            errorDes = ResourceUtils.getString((int)R.string.google_authorization_error);
            if (SettingFlags.getIntValue((String)"logintipstype", (int)1) == 2 && loginer.getLoginErrorTimes() <= 1) {
                errorDes = ResourceUtils.getString((int)R.string.tips_google_authorization_error_retry);
            }
        } else if (StringUtils.equal((String)errorCode, (String)"122")) {
            errorDes = ResourceUtils.getString((int)R.string.google_service_error);
        } else if (StringUtils.equals((String)errorCode, (String)"119")) {
            errorDes = ResourceUtils.getString((int)R.string.login_code_invalid_check_tips);
        } else if (StringUtils.equals((String)errorCode, (String)"120")) {
            errorDes = ResourceUtils.getString((int)R.string.login_phone_code_invalid_tips);
        } else if (StringUtils.equal((String)errorCode, (String)"20004")) {
            errorDes = ResourceUtils.getString((int)R.string.login_phone_invalid_new_tips);
        } else if (StringUtils.equals((String)errorCode, (String)"211")) {
            errorDes = ResourceUtils.getString((int)R.string.line_authorization_error);
        } else if (StringUtils.equals((String)errorCode, (String)"66666")) {
            errorDes = ResourceUtils.getString((int)R.string.tip_login_server_overloaded);
        } else if (StringUtils.equal((String)"116", (String)errorCode) && loginer.getSelectLoginType() == 1) {
            errorDes = ResourceUtils.getString((int)R.string.facebook_authorization_error);
            if (SettingFlags.getIntValue((String)"logintipstype", (int)1) == 2 && loginer.getLoginErrorTimes() <= 1) {
                errorDes = ResourceUtils.getString((int)R.string.tips_facebook_authorization_error_retry);
            }
        } else {
            errorDes = StringUtils.equal((String)"20105", (String)errorCode) ? ResourceUtils.getString((int)R.string.login_phone_pwd_error_excess_warning) : (StringUtils.equal((String)"30001", (String)errorCode) ? ResourceUtils.getString((int)R.string.login_phone_pwd_error_risk_warning) : (StringUtils.equal((String)"20104", (String)errorCode) ? ResourceUtils.getString((int)R.string.login_phone_password_login_fail_wraning) : (StringUtils.isNotEmpty((String)orinDesc) ? ResourceUtils.getString((int)R.string.login_error) + " " + orinDesc : ResourceUtils.getString((int)R.string.login_error))));
        }
        return errorDes;
    }

    @Override
    public void showDialog(BaseDialog baseDialog) {
        if (baseDialog == null) {
            return;
        }
        MLog.info((Object)TAG, (String)"login showDialog!", (Object[])new Object[0]);
        this.getDialogLinkManager().dismissDialog();
        this.getDialogLinkManager().showDialog(baseDialog);
    }

    private void openPhoneLoginWindow(int loginType) {
        MLog.info((Object)TAG, (String)"openPhoneLoginWindow", (Object[])new Object[0]);
        if (this.mPhoneController == null) {
            this.mPhoneController = new PhoneLoginController(this.getEnvironment(), this, this.mLoginTypeInfo);
        }
        this.mPhoneController.updateLoginType(loginType);
        this.mPhoneController.openLoginWindow();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS) {
            this.refreshAccountToken();
            this.getZaloLoginController().tryUpdateZaloFriendList();
        } else if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
            if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) && RuntimeContext.sIsAppStartFinished) {
                this.refreshAccountToken();
            }
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            this.checkToken();
        } else if (notification.id == NotificationDef.N_FOREGROUND_CHANGE && notification.extObj instanceof Boolean && this.mLoginStatistics != null) {
            this.mLoginStatistics.onChangeBackground(((Boolean)notification.extObj).booleanValue());
        }
    }

    public boolean onWindowKeyEvent(int keyCode, KeyEvent event) {
        boolean retVal = false;
        if (keyCode == 4 && event.getAction() == 1) {
            retVal = AbstractWindow.isHaveKeyDownEvent() ? this.onWindowBackKeyEvent() : true;
        }
        return retVal;
    }

    private boolean isEnableLoginOptimizeAbTest() {
        return LanguageUtils.isHindi() || LanguageUtils.isIndonesian();
    }

    private boolean isAfterLoginAndProfileFinishNotify() {
        return SettingFlags.getBoolean((String)"key_loginfnap", (boolean)true);
    }

    private void checkCountry(final AccountInfo accountInfo) {
        if (accountInfo == null) {
            return;
        }
        int registerSize = FP.size((CharSequence)accountInfo.registerCountry);
        int realSize = FP.size((CharSequence)accountInfo.realCountry);
        if (registerSize <= 0 || registerSize > 3 || realSize <= 0 || realSize > 3) {
            MLog.error((Object)TAG, (String)"checkCountry %s, %s", (Object[])new Object[]{accountInfo.registerCountry, accountInfo.realCountry});
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    LoginController.this.reportAbnorCountry(accountInfo);
                }
            });
        }
    }

    private void reportAbnorCountry(AccountInfo accountInfo) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "login_country");
        statContent.put("sfield", accountInfo.registerCountry);
        statContent.put("sfieldtwo", accountInfo.realCountry);
        HiidoStatis.reportContent((StatisContent)statContent);
        if (SystemUtils.isShowEnvSetting()) {
            throw new RuntimeException("\u540e\u53f0\u4e0b\u53d1\u975e\u6cd5\u56fd\u5bb6\u7801 " + accountInfo.registerCountry + ", " + accountInfo.realCountry);
        }
    }

    private Map<String, String> getLoginTrackExtra(AbstractLoginer loginer) {
        ArrayMap trackExtra = new ArrayMap();
        trackExtra.put("gid", this.mLoginFromGid);
        if (loginer != null) {
            if (loginer instanceof PhoneLoginController) {
                boolean autoFillSms = ((PhoneLoginController)loginer).isAutoFillSms();
                trackExtra.put("autofillsms", autoFillSms ? "1" : "0");
            } else if (loginer.getSelectLoginType() == 6) {
                this.mLoginCallFrom = this.getAccountReLoginController().getCallFrom();
                trackExtra.put("history_id", this.getAccountReLoginController().getCurLoginAccount());
            }
        }
        trackExtra.put("click_source", String.valueOf(this.mLoginCallFrom));
        return trackExtra;
    }
}

