/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import androidx.annotation.NonNull;
import com.yy.appbase.core.DefaultWindowController;
import com.yy.appbase.data.BirthdayDefines;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.utils.RegisterUtils;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;

public abstract class AbstractLoginer
extends DefaultWindowController {
    protected ILoginActionCallBack mLoginCallBack;
    protected int mSelectLoginType;
    protected long mSelectLoginUid = 0L;
    private int mLoginErrorTimes = 0;
    private JLoginTypeInfo mLoginTypeInfo;
    protected LoginSuccessResult mLoginSuccessResult;
    protected LoginErrorResult mLoginErrorResult;

    public AbstractLoginer(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo, int loginType) {
        super(env);
        this.mLoginCallBack = callBack;
        this.mLoginTypeInfo = loginTypeInfo;
        this.mSelectLoginType = loginType;
    }

    public AbstractLoginer updateLoginType(int loginType) {
        this.mSelectLoginType = loginType;
        return this;
    }

    public AbstractLoginer updateLoginUid(long loginUid) {
        this.mSelectLoginUid = loginUid;
        return this;
    }

    public ILoginActionCallBack getLoginCallBack() {
        return this.mLoginCallBack;
    }

    public void setLoginCallBack(ILoginActionCallBack callBack) {
        this.mLoginCallBack = callBack;
    }

    public abstract void openLoginWindow();

    public void popAllWindow() {
    }

    protected void authorization(IThirdPartyAuthorizationCallBack callBack) {
    }

    @NonNull
    public JLoginTypeInfo getLoginTypeInfo() {
        return this.mLoginTypeInfo;
    }

    public String getCurLoginAccount() {
        return "";
    }

    public void increaseErrorTimes() {
        ++this.mLoginErrorTimes;
    }

    public int getLoginErrorTimes() {
        return this.mLoginErrorTimes;
    }

    public int getSelectLoginType() {
        return this.mSelectLoginType;
    }

    public LoginSuccessResult getLoginSuccessResult() {
        return this.mLoginSuccessResult;
    }

    public LoginErrorResult getLoginErrorResult() {
        return this.mLoginErrorResult;
    }

    public abstract void getUserInfo(AccountInfo var1, IUserInfoCallBack var2);

    protected UserInfoBean transform(UserDetainInfo detainInfo) {
        String year = "";
        String month = "";
        String day = "";
        if (StringUtils.isNotEmpty((String)detainInfo.getBirthday())) {
            String[] birthdayValues = detainInfo.getBirthday().split("/");
            if (birthdayValues.length == 3) {
                month = birthdayValues[0];
                day = birthdayValues[1];
                year = birthdayValues[2];
            } else if (birthdayValues.length == 2) {
                month = birthdayValues[0];
                day = birthdayValues[1];
            } else if (birthdayValues.length == 1) {
                year = birthdayValues[0];
            }
        }
        if (StringUtils.isEmpty((String)year) || year.length() < 4) {
            year = String.valueOf(BirthdayDefines.getDefaultYear());
        }
        if (StringUtils.isEmpty((String)month) || month.length() > 2) {
            month = "01";
        }
        if (StringUtils.isEmpty((String)day) || day.length() > 2) {
            day = "01";
        }
        UserInfoBean userInfo = new UserInfoBean();
        int sex = StringUtils.equals((String)detainInfo.getGender(), (String)"male") ? 1 : (StringUtils.equals((String)detainInfo.getGender(), (String)"female") ? 0 : 3);
        userInfo.setSex(sex);
        userInfo.setNick(RegisterUtils.getLengthFixedStr(detainInfo.getName()));
        userInfo.setBirthday(year + "-" + month + "-" + day);
        if (detainInfo.getIconUrl() != null) {
            userInfo.setAvatar(detainInfo.getIconUrl());
        } else {
            userInfo.setAvatar("");
        }
        return userInfo;
    }
}

