/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.guest;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.LayoutRes;
import com.yy.appbase.account.LoginTypeData;
import com.yy.appbase.ui.press.ClickScaleAnimProvider;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogId;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.bean.LoginBigButtonInfo;
import com.yy.hiyo.login.view.LoginBigButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GuestLoginDialog
implements BaseDialog,
View.OnClickListener {
    private static final String TAG = "GuestLoginView";
    private IGuestLoginListener mOnGuestLoginListener;
    private View mRootView;
    private LinearLayout mOtherWaysLayout;
    private YYImageView mCloseBtn;
    private boolean mDelayCancelable = false;
    private int mShowType;
    private JLoginTypeInfo mLoginTypeInfo;
    private boolean mOnlyGuest;

    public GuestLoginDialog(Context context, JLoginTypeInfo loginTypeInfo, int showType, boolean delayCancelable) {
        this.mLoginTypeInfo = loginTypeInfo;
        this.mShowType = showType;
        this.mDelayCancelable = delayCancelable;
        this.mRootView = View.inflate((Context)context, (int)this.getLayoutId(), null);
        this.initView(this.mRootView);
        this.initListener();
        this.bindLoginType();
        ArrayList<LoginTypeData> secondList = new ArrayList<LoginTypeData>(2);
        if (this.mShowType == LoginTypeData.GUEST.getType()) {
            this.mOnlyGuest = true;
        } else {
            this.mOnlyGuest = false;
            LoginTypeData data = LoginTypeData.of((int)showType);
            if (data.checkValid()) {
                secondList.add(data);
            }
        }
        secondList.add(LoginTypeData.GUEST);
        this.showSecondLogin(secondList);
    }

    @LayoutRes
    private int getLayoutId() {
        return R.layout.guest_login_page;
    }

    public void init(final Dialog dialog) {
        dialog.getWindow().setLayout(-1, -1);
        dialog.setContentView(this.mRootView, new ViewGroup.LayoutParams(-1, -1));
        dialog.setCanceledOnTouchOutside(false);
        if (this.mDelayCancelable) {
            dialog.setCancelable(true);
            YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                public void run() {
                    if (dialog.isShowing()) {
                        dialog.setCancelable(true);
                    }
                }
            }, (long)1200L);
        }
        dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                GuestLoginDialog.this.unbindLoginType();
            }
        });
        Animation animation = AnimationUtils.loadAnimation((Context)this.mRootView.getContext(), (int)R.anim.slide_in_from_top_overshoot);
        this.mRootView.startAnimation(animation);
    }

    public int getId() {
        return DialogId.GuestLoginDialog;
    }

    public void onClick(View v) {
        if (v instanceof LoginBigButton) {
            LoginBigButtonInfo buttonInfo;
            LoginBigButton bigButton = (LoginBigButton)v;
            if (this.mOnGuestLoginListener != null && (buttonInfo = bigButton.getData()) != null) {
                this.mOnGuestLoginListener.onLoginClick(buttonInfo.loginType.getType());
            }
        }
    }

    private void initView(View container) {
        this.mCloseBtn = (YYImageView)container.findViewById(R.id.close_btn);
        TextView titleText = (TextView)container.findViewById(R.id.dialog_title);
        this.mOtherWaysLayout = (LinearLayout)container.findViewById(R.id.dialog_other_ways);
        String title = ResourceUtils.getString((int)R.string.login_try_other_ways_span);
        titleText.setText((CharSequence)GuestLoginDialog.capitalizeString(title));
    }

    private static String capitalizeString(String string2) {
        char[] chars = string2.toLowerCase().toCharArray();
        boolean needUpper = true;
        for (int i = 0; i < chars.length; ++i) {
            if (needUpper && Character.isLetter(chars[i])) {
                chars[i] = Character.toUpperCase(chars[i]);
                needUpper = false;
                continue;
            }
            if (!Character.isWhitespace(chars[i])) continue;
            needUpper = true;
        }
        return String.valueOf(chars);
    }

    private void initListener() {
        this.mCloseBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (GuestLoginDialog.this.mOnGuestLoginListener != null) {
                    GuestLoginDialog.this.mOnGuestLoginListener.onCloseClick();
                }
            }
        });
    }

    public void setOnGuestLoginListener(IGuestLoginListener onGuestLoginListener) {
        this.mOnGuestLoginListener = onGuestLoginListener;
    }

    private void bindLoginType() {
        MLog.debug((Object)TAG, (String)"bindLoginType", (Object[])new Object[0]);
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
            Kvo.addKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
        }
    }

    private void unbindLoginType() {
        MLog.debug((Object)TAG, (String)"unbindLoginType", (Object[])new Object[0]);
        if (this.mLoginTypeInfo != null) {
            Kvo.removeKvoBinding((KvoSource)this.mLoginTypeInfo, (Object)this, (String)"receiveLoginUpdateUpdate");
        }
    }

    @KvoMethodAnnotation(name="updateTypeList", sourceClass=JLoginTypeInfo.class)
    public void receiveLoginUpdateUpdate(KvoEventIntent event) {
        List updateList = (List)event.newValue();
        if (!FP.empty((Collection)updateList)) {
            for (LoginTypeData u : updateList) {
                this.updateLoginType(u);
            }
        }
    }

    private void showSecondLogin(List<LoginTypeData> secondTypeList) {
        if (secondTypeList != null) {
            LinearLayout container = this.mOtherWaysLayout;
            container.removeAllViews();
            if (secondTypeList.size() > 0) {
                for (LoginTypeData loginType : secondTypeList) {
                    if (loginType == null) continue;
                    LoginBigButton btn = LoginBigButton.create(loginType);
                    LoginBigButtonInfo info = btn.getData();
                    if (loginType == LoginTypeData.GUEST && !this.mOnlyGuest && info != null) {
                        info.textColor = R.color.login_guest_text;
                        info.btnIconResId = 0;
                        info.btnBackgroundResId = 0;
                        btn.setData(info);
                    }
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(ResolutionUtils.dip2Px((float)180.0f), ResolutionUtils.dip2Px((float)40.0f));
                    btn.setLayoutParams((ViewGroup.LayoutParams)lp);
                    btn.setOnClickListener(this);
                    container.addView((View)btn);
                    ClickScaleAnimProvider.apply((View)btn);
                }
            }
        }
    }

    private void updateLoginType(LoginTypeData data) {
        LinearLayout container = this.mOtherWaysLayout;
        for (int i = 0; i < container.getChildCount(); ++i) {
            if (!(container.getChildAt(i) instanceof LoginBigButton)) continue;
            LoginBigButton bigButton = (LoginBigButton)container.getChildAt(i);
            if (data.isVisible()) {
                bigButton.setVisibility(0);
                continue;
            }
            bigButton.setVisibility(8);
        }
    }

    public static interface IGuestLoginListener {
        public void onCloseClick();

        public void onLoginClick(int var1);
    }
}

