/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login;

import android.app.Dialog;
import android.content.Context;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.yy.hiyo.login.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class LoginAuthDialog
extends Dialog {
    private View.OnClickListener mOkListener;
    private View.OnClickListener mCancelListener;
    private long mUid;

    public LoginAuthDialog(@NonNull Context context, boolean newRegister, View.OnClickListener okListener, View.OnClickListener cancelListener, long uid) {
        super(context);
        this.mUid = uid;
        this.mOkListener = okListener;
        this.mCancelListener = cancelListener;
        this.init(newRegister);
    }

    private void init(boolean newRegister) {
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
        Window window = this.getWindow();
        if (window == null) {
            return;
        }
        window.setGravity(17);
        this.setContentView(R.layout.dialog_login_auth);
        TextView content = (TextView)this.findViewById(R.id.dla_content);
        if (!newRegister) {
            content.setText(R.string.text_login_auth_olduser);
        } else {
            content.setText(R.string.text_login_auth_newuser);
        }
        this.findViewById(R.id.dla_close).setOnClickListener(v -> this.cancelLogin());
        this.findViewById(R.id.dla_ok).setOnClickListener(v -> {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "authorization_agree").put("uid", this.mUid + ""));
            this.dismiss();
            if (this.mOkListener != null) {
                this.mOkListener.onClick(null);
            }
        });
    }

    public void show() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "authorization_show").put("uid", this.mUid + ""));
        super.show();
    }

    private void cancelLogin() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "authorization_cancel").put("uid", this.mUid + ""));
        this.dismiss();
        if (this.mCancelListener != null) {
            this.mCancelListener.onClick(null);
        }
    }
}

