/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.utils;

import android.content.Context;
import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.BirthdayDefines;
import com.yy.appbase.data.UserInfoBean;
import com.yy.base.logger.MLog;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.R;
import java.util.Random;

public class RegisterUtils {
    private static final String TAG = "RegisterUtils";
    public static final int NAME_LIMIT_LENGTH = 35;
    private static final String[] letterList = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};

    public static String getLengthFixedStr(String text, int limit) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            char[] chars = text.toCharArray();
            if (chars.length <= limit) {
                return text;
            }
            String fixedStr = text.substring(0, limit);
            return fixedStr;
        }
        return "";
    }

    public static String getLengthFixedStr(String text) {
        return RegisterUtils.getLengthFixedStr(text, 35);
    }

    public static UserInfoBean getDefaultUserInfo(Context context, UserInfoBean userInfo) {
        return RegisterUtils.getDefaultUserInfo(context, userInfo, -1);
    }

    public static UserInfoBean getDefaultUserInfo(Context context, UserInfoBean userInfo, int defaultGender) {
        if (userInfo != null) {
            if (TextUtils.isEmpty((CharSequence)userInfo.getAvatar())) {
                userInfo.setAvatar(RegisterUtils.getRandomAvatarUrl(context));
            }
            if (TextUtils.isEmpty((CharSequence)userInfo.getNick())) {
                userInfo.setNick(RegisterUtils.getRandomName());
            }
            if (TextUtils.isEmpty((CharSequence)userInfo.getBirthday())) {
                userInfo.setBirthday(BirthdayDefines.defaultBirthday());
            }
            if (userInfo.getUid() <= 0L) {
                userInfo.setUid(AccountUtil.getUid());
            }
            if (defaultGender >= 0) {
                userInfo.setSex(defaultGender);
            } else {
                userInfo.setSex(RegisterUtils.getRandomGender());
            }
            return userInfo;
        }
        UserInfoBean info = new UserInfoBean();
        info.setUid(AccountUtil.getUid());
        info.setNick(RegisterUtils.getRandomName());
        info.setAvatar(RegisterUtils.getRandomAvatarUrl(context));
        if (defaultGender >= 0) {
            info.setSex(defaultGender);
        } else {
            info.setSex(RegisterUtils.getRandomGender());
        }
        info.setBirthday(BirthdayDefines.defaultBirthday());
        return info;
    }

    public static UserInfoBean getDefaultUserInfo(Context context) {
        MLog.debug((Object)TAG, (String)"getDefaultUserInfo", (Object[])new Object[0]);
        return RegisterUtils.getDefaultUserInfo(context, null);
    }

    public static String getRandomAvatarUrl(Context context) {
        String[] avatars = context.getResources().getStringArray(R.array.default_avatar);
        if (context != null) {
            int index = new Random().nextInt(4);
            return avatars[index];
        }
        return avatars[0];
    }

    public static String getRandomName() {
        int index1 = new Random().nextInt(26);
        int index2 = new Random().nextInt(26);
        int index3 = new Random().nextInt(26);
        int index4 = new Random().nextInt(26);
        String curTime = String.valueOf(System.currentTimeMillis());
        String timeStr = "1234";
        if (!curTime.isEmpty() && curTime.length() > 4) {
            timeStr = curTime.substring(curTime.length() - 4, curTime.length());
        }
        String name = letterList[index1] + letterList[index2] + letterList[index3] + letterList[index4] + timeStr;
        return name;
    }

    public static int getRandomGender() {
        return new Random().nextInt(2);
    }

    public static boolean isShowCheckingPolicyView() {
        return CountryCodeUtils.isCountryAmerica() || CountryCodeUtils.isCountryAustralia() || CountryCodeUtils.isCountryNewZealand() || CountryCodeUtils.isCountryBritain() || CountryCodeUtils.isCountryCanada();
    }

    public static boolean isPolicyViewCheckedState() {
        return SettingFlags.getBoolean((String)"key_login_user_select_privacy_policy", (boolean)true);
    }

    public static void updatePolicyViewCheckedState(boolean isChecked) {
        SettingFlags.setBoolean((String)"key_login_user_select_privacy_policy", (boolean)isChecked);
    }
}

