/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.phone.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.base.utils.NextBtn;
import com.yy.hiyo.login.phone.windows.SplashLightAnim;

public class NextSplashLightBtn
extends YYFrameLayout {
    private static final String TAG = "NextSplashLightBtn";
    private static final int ANIM_DELAY = 3000;
    private NextBtn mNextBtn;
    private View mLightView;
    private SplashLightAnim mNextBtnAnim;
    private long mAnimDuration = 1000L;

    public NextSplashLightBtn(Context context) {
        super(context);
        this.createView(context);
    }

    public NextSplashLightBtn(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.createView(context);
    }

    public NextSplashLightBtn(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context context) {
        NextSplashLightBtn.inflate((Context)context, (int)R.layout.login_next_light_btn, (ViewGroup)this);
        this.mNextBtn = (NextBtn)this.findViewById(R.id.btn);
        this.mNextBtn.hideArrow();
        this.mLightView = this.findViewById(R.id.btn_light);
        StateListDrawable bgColorDrawable = new StateListDrawable();
        bgColorDrawable.addState(new int[]{16842919}, ResourceUtils.getDrawable((int)R.drawable.next_btn_press));
        bgColorDrawable.addState(new int[]{16842910}, ResourceUtils.getDrawable((int)R.drawable.next_btn_normal));
        bgColorDrawable.addState(new int[0], ResourceUtils.getDrawable((int)R.drawable.next_btn_disenable));
        this.mNextBtn.setBg((Drawable)bgColorDrawable);
    }

    public NextBtn getNextBtn() {
        return this.mNextBtn;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        MLog.debug((Object)TAG, (String)"onAttachedToWindow", (Object[])new Object[0]);
        this.post(new Runnable(){

            @Override
            public void run() {
                NextSplashLightBtn.this.checkAnim(NextSplashLightBtn.this.isEnabled());
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        MLog.debug((Object)TAG, (String)"onDetachedFromWindow", (Object[])new Object[0]);
        if (this.mNextBtnAnim != null) {
            this.mNextBtnAnim.stop();
            this.mNextBtnAnim = null;
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        MLog.debug((Object)TAG, (String)("setEnabled: " + enabled), (Object[])new Object[0]);
        this.mNextBtn.setEnabled(enabled);
        this.checkAnim(enabled);
    }

    public NextSplashLightBtn setBackground(int normalDrawable, int pressDrawable, int disableDrawable) {
        StateListDrawable bgColorDrawable = new StateListDrawable();
        bgColorDrawable.addState(new int[]{16842919}, ResourceUtils.getDrawable((int)pressDrawable));
        bgColorDrawable.addState(new int[]{16842910}, ResourceUtils.getDrawable((int)normalDrawable));
        bgColorDrawable.addState(new int[0], ResourceUtils.getDrawable((int)disableDrawable));
        this.mNextBtn.setBg((Drawable)bgColorDrawable);
        return this;
    }

    public NextSplashLightBtn setText(CharSequence text) {
        this.mNextBtn.setText(text);
        return this;
    }

    private void checkAnim(boolean enabled) {
        if (enabled) {
            if (this.mNextBtnAnim == null) {
                this.mNextBtnAnim = SplashLightAnim.of(this.mLightView, this.mNextBtn.getMeasuredWidth(), 3000L);
                this.setNextBtnAnimDuration(this.mAnimDuration);
            }
            this.mNextBtnAnim.stop();
            this.mNextBtnAnim.start();
        } else if (this.mNextBtnAnim != null) {
            this.mNextBtnAnim.stop();
            this.mNextBtnAnim = null;
        }
    }

    public static ViewGroup.MarginLayoutParams createMarginParam(ViewGroup.MarginLayoutParams params) {
        int btnHeight = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_height);
        boolean btnTopMargin = false;
        int btnBottomMargin = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_bottommargin);
        int leftPadding = ResourceUtils.getDimen((int)R.dimen.login_phone_window_leftpadding);
        params.width = -1;
        params.height = btnHeight;
        params.topMargin = 0;
        params.bottomMargin = btnBottomMargin;
        params.leftMargin = leftPadding;
        params.rightMargin = leftPadding;
        return params;
    }

    public void setNextBtnAnimDuration(long duration) {
        this.mAnimDuration = duration;
        if (this.mNextBtnAnim != null) {
            this.mNextBtnAnim.setDuration(duration);
        }
    }
}

