/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.facebook;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.featurelog.BDAConst;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.login.AbstractHandleUserInfoLoginer;
import com.yy.hiyo.login.ILoginActionCallBack;
import com.yy.hiyo.login.IUserInfoCallBack;
import com.yy.hiyo.login.LoginApi;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.R;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.base.IFacebookLoginCallback;
import com.yy.hiyo.login.base.IThirdPartyAuthorizationCallBack;
import com.yy.hiyo.login.bean.JLoginTypeInfo;
import com.yy.hiyo.login.stat.LoginStatistics;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.UserDetainInfo;
import com.yy.socialplatformbase.callback.ILoginCallBack;
import com.yy.socialplatformbase.data.LoginErrorResult;
import com.yy.socialplatformbase.data.LoginSuccessResult;
import com.yy.socialplatformbase.data.MetricCode;
import com.yy.socialplatformbase.platform.IPlatformAvailableCallBack;
import org.jetbrains.annotations.NotNull;

public class FaceBookLoginController
extends AbstractHandleUserInfoLoginer {
    private static final int MAX_LOGIN_ERROR_TIMES_PRTOTECT = 2;
    private static final int FACEBOOK_TOO_OLD_VER = 81;
    private static final String TAG = "FaceBookLoginController";
    private static final String FACEBOOK_DIR = "facebook";
    private volatile int mLoginErrorTimes = 0;
    private volatile boolean mIsLogining = false;
    private ILoginActionCallBack mMyCallBack;
    private IFacebookLoginCallback mFacebookLoginCallback;
    private long mCurTime = System.currentTimeMillis();
    private boolean isForeground = RuntimeContext.sIsForeground;

    public FaceBookLoginController(Environment env, ILoginActionCallBack callBack, JLoginTypeInfo loginTypeInfo) {
        super(env, callBack, loginTypeInfo, 1);
        this.mMyCallBack = callBack;
        ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            if (!this.isForeground && RuntimeContext.sIsForeground) {
                this.enableEventLog(true);
            }
            this.isForeground = RuntimeContext.sIsForeground;
        }
    }

    @Override
    public void openLoginWindow() {
        String s = "start login";
        BDAConst.bDALoginFacebook((String)s);
        FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
        this.mCurTime = System.currentTimeMillis();
        this.startLogin();
    }

    public void setFacebookLoginCallback(IFacebookLoginCallback callback) {
        this.mFacebookLoginCallback = callback;
    }

    public void logout() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (adapter != null) {
            adapter.logout();
        }
    }

    public void checkToken() {
        AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
        if (adapter != null) {
            adapter.checkToken();
        }
    }

    private void startLogin() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
            SingleToastUtil.showToast((Context)this.mContext, (String)ResourceUtils.getString((int)R.string.check_network_and_retry));
            String s = "network unavailable";
            BDAConst.bDALoginFacebook((String)s, (int)0);
            FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
            return;
        }
        if (this.mIsLogining) {
            String s = "logining";
            BDAConst.bDALoginFacebook((String)s);
            FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
            return;
        }
        this.mIsLogining = true;
        this.authorization(new IThirdPartyAuthorizationCallBack(){

            public void onSuccess(LoginSuccessResult result) {
                FaceBookLoginController.this.mIsLogining = false;
                FaceBookLoginController.this.mLoginErrorTimes = 0;
                if (result != null && result.authorizedData != null) {
                    FaceBookLoginController.this.handleLoginResult(result);
                } else {
                    FaceBookLoginController.this.handleLoginError("114", "login data invalid");
                }
            }

            public void onCancel() {
                FaceBookLoginController.this.mIsLogining = false;
                FaceBookLoginController.this.handleLoginError("116", "user cancel");
            }

            public void onError(int errorCode, Exception e) {
                if (SettingFlags.getBoolean((String)"facebookloginprotect", (boolean)true)) {
                    FaceBookLoginController.this.mLoginErrorTimes++;
                    FaceBookLoginController.this.handleLoginError("117", e != null ? e.toString() : "error empty!");
                    AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
                    if (FaceBookLoginController.this.mLoginErrorTimes >= 2 && platformAdapter != null) {
                        platformAdapter.getPlatformVersion(new IPlatformAvailableCallBack(){

                            public void onCallBack(final boolean isServicesAvailable, int version, final String verName, final String packName) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        int verInt;
                                        String[] verDatas;
                                        FaceBookLoginController.this.mIsLogining = false;
                                        boolean verTooLow = false;
                                        if (isServicesAvailable && StringUtils.equal((String)packName, (String)"com.facebook.katana") && StringUtils.isNotEmpty((String)verName) && (verDatas = verName.split("\\.")).length > 0 && (verInt = StringUtils.parseInt((String)verDatas[0], (int)-1)) > 0 && verInt <= 81) {
                                            verTooLow = true;
                                        }
                                        if (FaceBookLoginController.this.mMyCallBack != null && (!isServicesAvailable || verTooLow)) {
                                            OkCancelDialog tipsDialog = new OkCancelDialog((CharSequence)RuntimeContext.sApplicationContext.getString(R.string.login_facebook_service_upgrade_tips), (CharSequence)RuntimeContext.sApplicationContext.getString(R.string.dialog_ok), (CharSequence)RuntimeContext.sApplicationContext.getString(R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

                                                public void onCancel() {
                                                    LoginStatistics.statErrorTips((int)1, (boolean)false);
                                                    MLog.info((Object)FaceBookLoginController.TAG, (String)"push dialog onCancel", (Object[])new Object[0]);
                                                    FaceBookLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
                                                }

                                                public void onOk() {
                                                    LoginStatistics.statErrorTips((int)1, (boolean)true);
                                                    FaceBookLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
                                                }
                                            });
                                            FaceBookLoginController.this.mMyCallBack.showDialog((BaseDialog)tipsDialog);
                                        }
                                    }
                                });
                            }
                        });
                    } else {
                        FaceBookLoginController.this.mIsLogining = false;
                        FaceBookLoginController.this.handleLoginError("117", e != null ? e.toString() : "error empty!");
                    }
                } else {
                    FaceBookLoginController.this.mIsLogining = false;
                    FaceBookLoginController.this.handleLoginError("117", e != null ? e.toString() : "error empty!");
                }
            }
        });
    }

    @Override
    public void authorization(final IThirdPartyAuthorizationCallBack callBack) {
        final long startTime = System.currentTimeMillis();
        MLog.info((Object)TAG, (String)"authorization start!", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                FaceBookLoginController.this.logout();
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)FaceBookLoginController.TAG, (String)"authorization start2!", (Object[])new Object[0]);
                FaceBookLoginController.this.mLoginErrorResult = null;
                FaceBookLoginController.this.mLoginSuccessResult = null;
                FaceBookLoginController.this.enableEventLog(false);
                AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
                if (adapter != null) {
                    adapter.login(new ILoginCallBack(){

                        public void onSuccess(@NotNull LoginSuccessResult result) {
                            FaceBookLoginController.this.mLoginSuccessResult = result;
                            MLog.info((Object)FaceBookLoginController.TAG, (String)"authorization success!", (Object[])new Object[0]);
                            FaceBookLoginController.this.enableEventLog(true);
                            if (result.authorizedData != null) {
                                if (callBack != null) {
                                    long time = System.currentTimeMillis() - FaceBookLoginController.this.mCurTime;
                                    String s = "facebook authorization sucess time = " + time;
                                    BDAConst.bDALoginFacebook((String)s, (int)1);
                                    FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                                    if (RuntimeContext.sIsDebuggable) {
                                        ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("Facebook login time = " + time), (int)1);
                                    }
                                    callBack.isClientAuthorize = result.authorizedData.isClientAuthorize;
                                    callBack.errorTime = result.authorizedData.errorTime;
                                    callBack.onSuccess(result);
                                    LoginMetricHelper.reportToMetric((int)2, (String)"0");
                                }
                            } else {
                                String s = "facebook authorization sucess, but result authorizedData is null";
                                BDAConst.bDALoginFacebook((String)s, (int)0);
                                FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                                if (callBack != null) {
                                    callBack.isClientAuthorize = result.authorizedData.isClientAuthorize;
                                    callBack.errorTime = result.authorizedData.errorTime;
                                    callBack.onError(-1, (Exception)new RuntimeException(""));
                                    String metricCode = MetricCode.getSelfCode((String)"100");
                                    LoginMetricHelper.reportToMetric((int)2, (String)metricCode);
                                }
                            }
                        }

                        public void onCancel() {
                            MLog.info((Object)FaceBookLoginController.TAG, (String)"authorization cancel!", (Object[])new Object[0]);
                            FaceBookLoginController.this.enableEventLog(true);
                            String s = "authorization cancel, time interval = " + (System.currentTimeMillis() - startTime);
                            BDAConst.bDALoginFacebook((String)s, (int)0);
                            FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                            if (callBack != null) {
                                callBack.onCancel();
                            }
                        }

                        public void onError(LoginErrorResult result) {
                            FaceBookLoginController.this.mLoginErrorResult = result;
                            MLog.info((Object)FaceBookLoginController.TAG, (String)"authorization onError!", (Object[])new Object[0]);
                            FaceBookLoginController.this.enableEventLog(true);
                            String s = "authorization onError, due = " + (result != null ? result.toString() : "");
                            BDAConst.bDALoginFacebook((String)s, (int)0);
                            FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                            if (result != null && callBack != null) {
                                callBack.isClientAuthorize = result.isClientAuthorize;
                                callBack.errorTime = result.errorTime;
                                callBack.onError(result.errorCode, result.exception);
                                LoginMetricHelper.reportToMetric((int)2, (String)result.metricCode);
                            }
                        }
                    });
                }
            }
        });
    }

    private void enableEventLog(boolean enable) {
        if (!SettingFlags.getBoolean((String)"fb_login_disable_event_close", (boolean)false)) {
            AbsPlatformAdapter adapter = ThirdPartyPlatformHelper.getInstance().getPlatform(5);
            Message message = Message.obtain();
            message.what = PlatformMsgDef.MSG_ENABLE_AUTO_LOG_APP_EVENTS;
            message.obj = enable;
            adapter.handleMessageSync(message);
        }
    }

    public void handleLoginResult(LoginSuccessResult result) {
        MLog.info((Object)TAG, (String)"handleLoginResult!", (Object[])new Object[0]);
        this.mMyCallBack.onLoginStart(this);
        String userid = result.authorizedData.userId;
        String tokenStr = result.authorizedData.tokenStr;
        String appId = result.authorizedData.appId;
        String mail = result.authorizedData.mail;
        final long startTime = System.currentTimeMillis();
        this.mMyCallBack.getLoginRequester().loginWithThirdParty(5, appId, tokenStr, userid, mail, new ILoginRequestCallBack(){

            public void onSuccess(LoginData data) {
                MLog.info((Object)FaceBookLoginController.TAG, (String)"loginWithThirdParty onSuccess!", (Object[])new Object[0]);
                if (data == null) {
                    String s = "login LoginData is null";
                    BDAConst.bDALoginFacebook((String)s, (int)0);
                    FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                    FaceBookLoginController.this.handleLoginError("117", "get facebook userinfo error!");
                    return;
                }
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)"0", (String)"login/thirdpartyAuth");
                LoginData facebookLoginData = data;
                AccountInfo accountInfo = AccountInfo.obtain((LoginData)facebookLoginData);
                accountInfo.loginType = 1;
                MLog.info((Object)FaceBookLoginController.TAG, (String)"loginWithThirdParty onSuccess2!", (Object[])new Object[0]);
                String s = "login authorization info to service sucess";
                BDAConst.bDALoginFacebook((String)s, (int)1);
                FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                if (FaceBookLoginController.this.mLoginCallBack != null) {
                    FaceBookLoginController.this.mLoginCallBack.onLoginSuccess(FaceBookLoginController.this, accountInfo);
                }
                if (FaceBookLoginController.this.mFacebookLoginCallback != null) {
                    FaceBookLoginController.this.mFacebookLoginCallback.onSuccess();
                    FaceBookLoginController.this.mFacebookLoginCallback = null;
                }
                LoginApi.getInstance().sendFbRegisterPushMsg();
            }

            public void onError(String errorCode, String errorDescription, String exceptionDue) {
                String s = "login authorization info to service fail, errorCode = " + errorCode + "  exceptionDue = " + exceptionDue;
                BDAConst.bDALoginFacebook((String)s, (int)0);
                FeatureLog.i((String)"FTLoginFacebook", (String)s, (Object[])new Object[0]);
                FaceBookLoginController.this.handleLoginError(errorCode, errorDescription);
                long time = System.currentTimeMillis() - startTime;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)errorCode, (String)"login/thirdpartyAuth");
            }
        });
    }

    private void handleLoginError(final String errorCode, final String des) {
        MLog.error((Object)TAG, (String)"login error:%s %s", (Object[])new Object[]{errorCode, des});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (FaceBookLoginController.this.mLoginCallBack != null) {
                    FaceBookLoginController.this.mLoginCallBack.onLoginError(FaceBookLoginController.this, errorCode, des);
                }
                if (FaceBookLoginController.this.mFacebookLoginCallback != null) {
                    FaceBookLoginController.this.mFacebookLoginCallback.onError(errorCode, des);
                    FaceBookLoginController.this.mFacebookLoginCallback = null;
                }
                FaceBookLoginController.this.sendMessage(LoginMsgDef.MSG_SHOW_LOGIN_FEEDBACK_TIPSVIEW);
                FaceBookLoginController.this.sendMessage(LoginMsgDef.MSG_LOGIN_TYPE_SELECT_RESUME);
            }
        });
    }

    @Override
    public void getUserInfo(AccountInfo accountInfo, IUserInfoCallBack callBack) {
        this.getUserInfo(false, 5, accountInfo, callBack);
    }

    @Override
    public void handleLoginWithUpdateUserInfo(IUserInfoCallBack callBack, String iconPath, AccountInfo accountInfo, UserDetainInfo info) {
        if (info == null || accountInfo == null || !accountInfo.isValid()) {
            this.handleUpdateHagoUserInfoError(callBack, "117", "get facebook userinfo error!");
            return;
        }
        UserInfoBean userInfo = this.transform(info);
        userInfo.setUid(accountInfo.uuid);
        if (callBack != null) {
            callBack.onSuccess(userInfo);
        }
    }

    @Override
    public String getIconDir() {
        return FACEBOOK_DIR;
    }

    @Override
    public String getThirdpartyError() {
        return "117";
    }
}

