/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.loginrequest;

import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import java.util.Map;

public class LoginUtil {
    private static final String TAG = "LoginUtil";
    private static final String KEY_SIM_COUNTRY = "sim_country";
    private static final String KEY_SYS_COUNTRY = "sys_country";
    private static final String KEY_NETWORK_COUNTRY = "network_country";
    private static final String KEY_SYS_LANG = "sys_lang";
    private static final String VAL_VPN_TRUE = "1";
    private static final String VAL_VPN_FALSE = "0";
    private static final String KEY_VPN = "vpn";

    public static void initCountryCodeParam(Map<String, String> params) {
        if (params != null) {
            String simCountryIso = SystemUtils.getSimCountryIso();
            String localeCountry = SystemUtils.getLocaleCountry();
            String networkCountry = SystemUtils.getNetworkCountry();
            String lang = SystemUtils.getLang();
            boolean ignoreCountryCode = SettingFlags.getBoolean((String)"ENV_LOGIN_IGNORE_COUNTRY_CODE", (boolean)false);
            if (SystemUtils.isShowEnvSetting() && ignoreCountryCode) {
                simCountryIso = localeCountry;
                networkCountry = localeCountry;
            }
            params.put(KEY_SIM_COUNTRY, simCountryIso);
            params.put(KEY_SYS_COUNTRY, localeCountry);
            params.put(KEY_NETWORK_COUNTRY, networkCountry);
            params.put(KEY_SYS_LANG, lang);
            params.put(KEY_VPN, SystemUtils.isCurrUseVpn() ? VAL_VPN_TRUE : VAL_VPN_FALSE);
            MLog.info((Object)TAG, (String)"initCountryCodeParam %b, %b, params:%s", (Object[])new Object[]{ignoreCountryCode, SystemUtils.isShowEnvSetting(), params});
        }
    }
}

