/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.loginrequest;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.hiyo.loginrequest.IRetryStrategy;

public class LoginRetryStrategy {
    public static IRetryStrategy obtainRetryStrategy() {
        return new IRetryStrategy(){

            @Override
            public int getMaxRetryTimes() {
                AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
                if (configData != null) {
                    return configData.getIntValue("lrrretrytimes", 2);
                }
                return 2;
            }

            @Override
            public int getReadTimeOut(int curRetryTimes, Exception lastErrorExc) {
                return LoginRetryStrategy.getConnectTime(curRetryTimes, lastErrorExc);
            }

            @Override
            public int getWriteTimeOut(int curRetryTimes, Exception lastErrorExc) {
                return LoginRetryStrategy.getConnectTime(curRetryTimes, lastErrorExc);
            }

            @Override
            public int getConnectTimeOut(int curRetryTimes, Exception lastErrorExc) {
                return LoginRetryStrategy.getConnectTime(curRetryTimes, lastErrorExc);
            }

            @Override
            public boolean isSwitchOn() {
                AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
                if (configData != null) {
                    return configData.getBoolValue("lrrretryswitch", false);
                }
                return false;
            }
        };
    }

    private static int getConnectTime(int curRetryTimes, Exception lastErrorExc) {
        int defaultTimeGap = 5000;
        int defaultTime = curRetryTimes <= 0 ? defaultTimeGap : defaultTimeGap + curRetryTimes * defaultTimeGap;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
        if (configData != null) {
            if (curRetryTimes <= 0) {
                return configData.getIntValue("lrrfirstct", defaultTime);
            }
            if (curRetryTimes == 1) {
                return configData.getIntValue("lrrsecondct", defaultTime);
            }
            return configData.getIntValue("lrrfthreect", defaultTime);
        }
        return defaultTime;
    }
}

