/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.loginrequest;

import android.os.SystemClock;
import android.text.format.DateUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.CommonPerfUtils;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DES3Utils;
import com.yy.base.utils.SHAUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Request;
import com.yy.grace.Response;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.account.LoginData;
import com.yy.hiyo.login.stat.metric.LoginMetricHelper;
import com.yy.hiyo.loginrequest.IBaseLoginRequester;
import com.yy.hiyo.loginrequest.ILoginRequestCallBack;
import com.yy.hiyo.loginrequest.IReportAntiCallBack;
import com.yy.hiyo.loginrequest.IRetryStrategy;
import com.yy.hiyo.loginrequest.LoginRetryStrategy;
import com.yy.hiyo.loginrequest.LoginUtil;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public class BaseLoginRequestManager
implements IBaseLoginRequester {
    protected static final String TAG = "BaseLoginRequestManager";
    public static final String METRICCODE_SUCCESS = "0";
    public static final String METRICCODE_UNKNOWN_ERROR = "99999";
    protected static final String KEY_TS = "ts";
    protected static final String KEY_DEVICE_ID = "device_id";
    protected static final String KEY_DEVICE_TYPE = "dev_type";
    protected static final String KEY_APPID = "appId";
    protected static final String KEY_APPNAME = "app";
    protected static final String KEY_UID = "uid";
    protected static final String KEY_SEX = "sex";
    protected static final String KEY_TIMESTAMP = "timestamp";
    protected static final int USE_IP_RETRY_TIMES = 2;
    protected static final int ERROR_INFO_MAX_LEN = 200;
    protected static final String KEY_RESPONSE_RESULT = "result_code";
    protected static final String KEY_RESPONSE_RESULT_DESC = "result_desc";
    protected static final String KEY_RESPONSE_WHATSAPP = "send_wa";
    protected static final String KEY_RESPONSE_S_SESSION = "s_session";
    public static final String KEY_RESPONSE_UUID = "uuid";
    protected static final String KEY_RESPONSE_S_T = "s_t";
    protected static final String KEY_RESPONSE_NICK = "nick";
    protected static final String KEY_RESPONSE_BIRTHDAY = "birthday";
    protected static final String KEY_RESPONSE_SEX = "sex";
    protected static final String KEY_RESPONSE_AVATAR = "avatar";
    protected static final String KEY_RESPONSE_GUEST = "guest";
    protected static final String KEY_RESPONSE_RESULT_TYPE = "result_type";
    protected static final String KEY_RESPONSE_REGISTER_COUNTRY = "register_country";
    protected static final String KEY_RESPONSE_REAL_COUNTRY = "real_country";
    protected static final String KEY_RESPONSE_HOST = "host";
    protected static final String KEY_ANTI = "anti";
    protected static final String KEY_AUTH_APP = "auth_app";
    protected static final String KEY_RESPONSE_PWD = "password";
    public static final String KEY_RESPONSE_LOGIN_TIMESTAMP = "timestamp";
    protected static final String KEY_RESPONSE_LIFECYCLE = "life_cycle";
    protected static final String KEY_RESPONSE_S_SESSIONKEY_KEY = "sSessionKey";
    protected static final String KEY_S_T = "s_t";
    protected static final String KEY_C_AUTH = "c_auth";
    protected static final String KEY_THIRD_PARTY_TS = "ts";
    protected static final String KEY_THIRD_PARTY_OPEN_SOURCE = "open_source";
    protected static final String KEY_THIRD_PARTY_APP_ID = "open_key";
    protected static final String KEY_THIRD_PARTY_ACCESS_TOKEN = "access_token";
    protected static final String KEY_THIRD_PARTY_ID_TOKEN = "id_token";
    protected static final String KEY_THIRD_PARTY_USERID = "open_id";
    protected static final String KEY_THIRD_PARTY_USER_MAIL = "mail";
    protected static final String KEY_RESPONSE_THIRD_PARTY_BIND_INFO = "bind_info";
    public static final String KEY_GUEST_C_AUTH = "guest_c_auth";
    public static final String KEY_GUEST_S_T = "guest_s_t";
    protected static final String SUCCESS_RESULT_CODE = "0000";
    protected static final String MY_DEVICE_TYPE = "11";
    protected static final String APPID_VALUE = "ikxd";
    public static final String TOKEN_SPLIT = ",";
    protected IRetryStrategy mRetryStrategy = LoginRetryStrategy.obtainRetryStrategy();

    @Override
    public void refreshAccountToken(final long uuid, final String token, final String sessionKey, final ILoginRequestCallBack callBack) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MLog.info((Object)BaseLoginRequestManager.TAG, (String)"refresh account token", (Object[])new Object[0]);
                RefreshTokenItem item = new RefreshTokenItem();
                item.url = UriProvider.LoginRefreshAuth;
                item.listenCallBack(callBack);
                item.uuid = uuid;
                item.token = token;
                item.sessionKey = sessionKey;
                BaseLoginRequestManager.this.refreshAccountToken(item);
            }
        });
    }

    private void refreshAccountToken(final RefreshTokenItem item) {
        final String url = item.url;
        ClientToken clientToken = null;
        if (StringUtils.isNotEmpty((String)item.token)) {
            clientToken = this.getClientTokenParams(item.uuid, item.token, item.sessionKey);
        }
        Map<String, String> params = this.createRefreshTokenParams(item.token, clientToken);
        final ClientToken fClientToken = clientToken;
        HashMap<String, String> headers = null;
        if (item.curUseIp) {
            headers = new HashMap<String, String>();
            headers.put("Host", item.ipHost);
        }
        Request request = GraceWrapper.postForString((String)url, params, headers).group((Request.Group)BizScenc.NORMAL_LOGIN).build();
        GraceWrapper.getGrace().newCall(request).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)BaseLoginRequestManager.TAG, (String)("refreshAccountToken response =" + response), (Object[])new Object[0]);
                }
                MLog.info((Object)BaseLoginRequestManager.TAG, (String)"refreshAccountToken onResponse url: %s ", (Object[])new Object[]{item.url});
                YYTaskExecutor.execute(() -> {
                    String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner((String)response.body(), item2.sessionKey, item2.callBack);
                    boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                    CommonPerfUtils.statLoginEvent((int)3, (boolean)result, (int)item2.curRetryTimes, (String)(result ? "" : "parse data error:" + resultCode), (int)-1, (String)url, (String)String.valueOf(resultCode));
                    if (!result && fClientToken != null) {
                        MLog.error((Object)BaseLoginRequestManager.TAG, (String)"refresh params uuid:%s, time:%s, clientJson:%s, sessionkey:%s", (Object[])new Object[]{String.valueOf(fClientToken2.uuid), String.valueOf(fClientToken2.time), fClientToken2.clientJosn, fClientToken2.sessionKey});
                    }
                });
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    if (item2.curRetryTimes < item2.maxRetryTimes && !RuntimeContext.sIsDebuggable) {
                        MLog.error((Object)"LoginRequestManager ", (String)"refresh token retry by error =", (Throwable)e, (Object[])new Object[0]);
                        ++item2.curRetryTimes;
                        BaseLoginRequestManager.this.refreshAccountToken(item);
                    } else {
                        MLog.error((Object)"LoginRequestManager", (String)"refresh token error =", (Throwable)e, (Object[])new Object[0]);
                        if (item2.callBack != null) {
                            item2.callBack.onError("111", "", "" + e);
                            CommonPerfUtils.statLoginEvent((int)3, (boolean)false, (int)item2.curRetryTimes, (String)(e != null ? e.toString() : ""), (int)-1, (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                        }
                    }
                });
            }
        });
    }

    @Override
    public void loginWithThirdParty(int platformId, String appIdFromPlatform, String token, String userId, String mail, ILoginRequestCallBack callBack) {
        this.loginWithThirdParty(platformId, appIdFromPlatform, token, null, userId, mail, callBack);
    }

    @Override
    public void loginWithThirdParty(int platformId, String appIdFromPlatform, String accessToken, String idToken, String userId, String mail, ILoginRequestCallBack callBack) {
        CommonPerfUtils.statThirdpartyLoginStartEvent((int)10, (boolean)false);
        LoginThirdPartyItem item = new LoginThirdPartyItem();
        item.platformId = platformId;
        item.appIdFromPlatform = appIdFromPlatform;
        item.token = accessToken;
        item.idToken = idToken;
        item.userId = userId;
        item.mail = mail;
        item.errorInfo = "";
        item.startTime = SystemClock.elapsedRealtime();
        item.listenCallBack(callBack);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[loginWithThirdParty] platformId: %d, appId: %s, token: %s, userId: %s, email: %s", (Object[])new Object[]{item.platformId, item.appIdFromPlatform, item.token, item.userId, item.mail});
        }
        if (this.mRetryStrategy == null || !this.mRetryStrategy.isSwitchOn()) {
            this.loginWithThirdPartyInner(item, item.maxRetryTimes);
        } else {
            this.loginWithThirdPartyInner(item, this.mRetryStrategy);
        }
    }

    private void loginWithThirdPartyInner(final LoginThirdPartyItem item, final int maxRetrytimes) {
        final String url = UriProvider.LoginWithThirdPlatform;
        final String sessionSecret = SHAUtils.getSHA256((String)item.userId);
        Map<String, String> params = this.createThirdPartyLoginParams(item.platformId, item.appIdFromPlatform, item.token, item.idToken, item.userId, item.mail, sessionSecret);
        GraceWrapper.getGrace().newCall(GraceWrapper.postForString((String)url, params, null).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"LoginRequestManager", (String)("login thirdpartyresponse =" + response), (Object[])new Object[0]);
                }
                String body = (String)response.body();
                String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, item.callBack);
                boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                int useTime = (int)(SystemClock.elapsedRealtime() - item.startTime);
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String string = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)1, (boolean)result, (int)(item2.curRetryTimes + item2.retryWithIpTimes), (String)reason, (int)useTime, (String)url, (String)String.valueOf(resultCode));
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> BaseLoginRequestManager.this.handleLoginError(e, item, null, maxRetrytimes));
            }
        });
    }

    private void loginWithThirdPartyInner(final LoginThirdPartyItem item, final IRetryStrategy retryStrategy) {
        final String url = UriProvider.LoginWithThirdPlatform;
        final String sessionSecret = SHAUtils.getSHA256((String)item.userId);
        Map<String, String> params = this.createThirdPartyLoginParams(item.platformId, item.appIdFromPlatform, item.token, item.idToken, item.userId, item.mail, sessionSecret);
        Request.Builder builder = GraceWrapper.postForString((String)url, params, null).group((Request.Group)BizScenc.NORMAL_LOGIN);
        if (retryStrategy != null) {
            builder.connectTimeout((long)retryStrategy.getConnectTimeOut(item.curRetryTimes, null), TimeUnit.MILLISECONDS);
            builder.readTimeout((long)retryStrategy.getReadTimeOut(item.curRetryTimes, null), TimeUnit.MILLISECONDS);
            builder.writeTimeout((long)retryStrategy.getWriteTimeOut(item.curRetryTimes, null), TimeUnit.MILLISECONDS);
        }
        GraceWrapper.getGrace().newCall(builder.build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"LoginRequestManager", (String)("login thirdpartyresponse =" + response), (Object[])new Object[0]);
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String body = (String)response.body();
                    String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, item2.callBack);
                    boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - item2.startTime);
                    String string = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)1, (boolean)result, (int)(item2.curRetryTimes + item2.retryWithIpTimes), (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> BaseLoginRequestManager.this.handleLoginError(e, item, retryStrategy, 0));
            }
        });
    }

    private void loginWithThirdPartyByIp(final String url, final LoginThirdPartyItem item, int theMaxRetryTimes) {
        ++item.retryWithIpTimes;
        final int maxRetryTimes = theMaxRetryTimes;
        final String sessionSecret = SHAUtils.getSHA256((String)item.userId);
        Map<String, String> params = this.createThirdPartyLoginParams(item.platformId, item.appIdFromPlatform, item.token, item.idToken, item.userId, item.mail, sessionSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", UriProvider.LOGIN_IP_HOST);
        GraceWrapper.getGrace().newCall(GraceWrapper.postForString((String)url, params, headers).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"LoginRequestManager", (String)("login thirdpartyresponse ip =" + response), (Object[])new Object[0]);
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String body = (String)response.body();
                    String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, item2.callBack);
                    boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - item2.startTime);
                    String string = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)1, (boolean)result, (int)(item2.curRetryTimes + item2.retryWithIpTimes), (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    String curError;
                    String string = curError = e != null ? e.toString() : "";
                    if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                        curError = curError.substring(0, 200);
                    }
                    item2.errorInfo = item2.errorInfo != null ? item2.errorInfo + "_useip_" + curError : curError;
                    if (maxRetryTimes <= item2.retryWithIpTimes || !BaseLoginRequestManager.this.canUseIp()) {
                        if (item2.callBack != null) {
                            MLog.error((Object)"LoginRequestManager ", (String)"login thirdparty ip error =", (Throwable)e, (Object[])new Object[0]);
                            item2.callBack.onError("111", "", "" + e);
                            CommonPerfUtils.statLoginEvent((int)1, (boolean)false, (int)(item2.curRetryTimes + item2.retryWithIpTimes), (String)item2.errorInfo, (int)((int)(SystemClock.elapsedRealtime() - item2.startTime)), (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                        }
                    } else {
                        MLog.error((Object)"LoginRequestManager ", (String)"will retry login thirdparty ip error =", (Throwable)e, (Object[])new Object[0]);
                        BaseLoginRequestManager.this.loginWithThirdPartyByIp("http://47.52.230.226/uaas/login/thirdpartyAuth", item, maxRetryTimes);
                    }
                });
            }
        });
    }

    @Override
    public void reportAnti(String anti, AccountInfo accountInfo, final @NonNull IReportAntiCallBack callBack) {
        MLog.info((Object)TAG, (String)"reportAnti", (Object[])new Object[0]);
        String url = UriProvider.LoginReportAnti;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(KEY_ANTI, anti);
        ClientToken clientToken = this.getClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey);
        String st = "";
        String auth = "";
        if (clientToken != null) {
            st = clientToken.st;
            auth = clientToken.auth;
        }
        params.put("s_t", st);
        params.put(KEY_C_AUTH, auth);
        params.put(KEY_APPID, APPID_VALUE);
        final long start = System.currentTimeMillis();
        GraceWrapper.getGrace().newCall(GraceWrapper.postForString((String)url, params, null).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                callBack.onSuccess((String)response.body());
                long time = System.currentTimeMillis() - start;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)BaseLoginRequestManager.METRICCODE_SUCCESS, (String)"login/reportAnti");
            }

            public void onFailure(Call<String> call, Throwable e) {
                callBack.onFailed(e);
                long time = System.currentTimeMillis() - start;
                LoginMetricHelper.reportToMetric((int)1, (long)time, (String)BaseLoginRequestManager.METRICCODE_UNKNOWN_ERROR, (String)"login/reportAnti");
            }
        });
    }

    protected String handleLoginTokenDatasInner(String response, String sessionSecret, boolean fromPhoneLogin, ILoginRequestCallBack callBack) {
        String resultCode = null;
        String resultDesc = null;
        String sSession = "";
        String st = "";
        String nick = "";
        String birthday = "";
        int sex = -1;
        String avatar = "";
        boolean guest = false;
        int resultType = -1;
        String registerCountry = "";
        String realCountry = "";
        String anti = "";
        boolean authApp = false;
        boolean hasPhonePwd = SettingFlags.getBoolean((String)"5f1dd2abdc7f9b386cc634fc83791d09", (boolean)false);
        try {
            JSONObject jsonObject = JsonParser.obtainJSONObject((String)response);
            resultCode = jsonObject.optString(KEY_RESPONSE_RESULT);
            resultDesc = jsonObject.optString(KEY_RESPONSE_RESULT_DESC);
            sSession = jsonObject.optString(KEY_RESPONSE_S_SESSION);
            st = jsonObject.optString("s_t");
            nick = jsonObject.optString(KEY_RESPONSE_NICK);
            birthday = jsonObject.optString(KEY_RESPONSE_BIRTHDAY);
            sex = jsonObject.optInt("sex", -1);
            avatar = jsonObject.optString(KEY_RESPONSE_AVATAR);
            guest = jsonObject.optBoolean(KEY_RESPONSE_GUEST);
            resultType = jsonObject.optInt(KEY_RESPONSE_RESULT_TYPE, -1);
            anti = jsonObject.optString(KEY_ANTI);
            authApp = jsonObject.optBoolean(KEY_AUTH_APP, true);
            if (fromPhoneLogin) {
                hasPhonePwd = jsonObject.optInt(KEY_RESPONSE_PWD, 0) == 1;
            }
            MLog.info((Object)TAG, (String)"handleLoginTokenDatasInner anti: %s", (Object[])new Object[]{anti});
            long createTime = jsonObject.optLong("guestCreateTime", 0L);
            if (resultType == -1 && createTime > 0L) {
                boolean sameDay = DateUtils.isToday((long)createTime);
                MLog.info((Object)TAG, (String)"guest login!!!, createTime:%d, sameDay:%b", (Object[])new Object[]{createTime, sameDay});
                resultType = sameDay ? 2 : 1;
            }
            MLog.info((Object)TAG, (String)"handleLoginTokenDatas resultType=%d", (Object[])new Object[]{resultType});
            JSONObject hostObj = jsonObject.optJSONObject(KEY_RESPONSE_HOST);
            if (hostObj != null) {
                String localHost = hostObj.optString("local_host");
                String preRegisterHost = hostObj.optString("cproxy_host");
                String registerHost = hostObj.optString("register_host_v2");
                if (StringUtils.isEmpty((String)registerHost)) {
                    registerHost = hostObj.optString("register_host");
                }
                if (hostObj.has("lcid")) {
                    String lcid = hostObj.optString("lcid");
                    SettingFlags.setStringValue((String)"lcid", (String)lcid);
                    MLog.info((Object)TAG, (String)"lcid:%s", (Object[])new Object[]{lcid});
                }
                int idc = hostObj.optInt("register_idc");
                String webgameHost = hostObj.optString("game_host");
                String turnoverHost = hostObj.optString("turnover_host");
                BaseLoginRequestManager.updateUrl(localHost, preRegisterHost, registerHost, idc, webgameHost, turnoverHost);
                registerCountry = hostObj.optString(KEY_RESPONSE_REGISTER_COUNTRY);
                realCountry = hostObj.optString(KEY_RESPONSE_REAL_COUNTRY);
                MLog.info((Object)TAG, (String)"handleLoginTokenDatas registerCountry=%s,realCountry:%s", (Object[])new Object[]{registerCountry, realCountry});
            } else {
                MLog.info((Object)TAG, (String)"handleLoginTokenDatas no RESPONSE_HOST!", (Object[])new Object[0]);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
            resultCode = "112";
            resultDesc = null;
        }
        if (resultCode == null || !resultCode.equals("00000")) {
            if (StringUtils.equals((String)resultCode, (String)"20101")) {
                resultCode = "120";
            } else if (StringUtils.equals((String)resultCode, (String)"20102")) {
                resultCode = "119";
            } else if (StringUtils.equals((String)resultCode, (String)"20004")) {
                resultCode = "200";
            } else if (resultCode == null) {
                resultCode = "";
            }
            if (callBack != null) {
                callBack.onError(resultCode, resultDesc, resultDesc);
            }
            MLog.error((Object)TAG, (String)"handleLoginTokenDatas %s, %s ", (Object[])new Object[]{resultCode, resultDesc});
            return resultCode;
        }
        LoginData loginItem = new LoginData();
        if (StringUtils.isEmpty((String)sSession) || StringUtils.isEmpty((String)st)) {
            resultCode = "113";
            resultDesc = null;
        } else {
            loginItem.localTimestamp = System.currentTimeMillis();
            String sSessionDecode = null;
            long timestamp = loginItem.localTimestamp;
            long uuid = -1L;
            long lifecycle = -1L;
            String sSessionKey = "";
            String loginToken = "";
            if (!StringUtils.isEmpty((String)sessionSecret)) {
                try {
                    sSessionDecode = DES3Utils.decrypt((String)sSession, (String)sessionSecret);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                }
            }
            if (!StringUtils.isEmpty(sSessionDecode)) {
                try {
                    JSONObject loginData = JsonParser.obtainJSONObject((String)sSessionDecode);
                    uuid = loginData.optLong(KEY_RESPONSE_UUID, -1L);
                    sSessionKey = loginData.optString(KEY_RESPONSE_S_SESSIONKEY_KEY);
                    lifecycle = StringUtils.parseLong((String)loginData.optString(KEY_RESPONSE_LIFECYCLE), (long)-1L);
                }
                catch (Exception e) {
                    MLog.error((Object)TAG, (Throwable)e);
                    resultCode = "112";
                    resultDesc = null;
                }
                if (uuid > 0L) {
                    JSONObject tokenJoson = JsonParser.obtainJSONObject();
                    try {
                        tokenJoson.put(KEY_RESPONSE_UUID, uuid);
                        tokenJoson.put("timestamp", timestamp);
                        String clientJson = tokenJoson.toString();
                        String clientToken = DES3Utils.encrypt((String)clientJson, (String)sSessionKey);
                        if (StringUtils.isNotEmpty((String)clientJson) && StringUtils.isNotEmpty((String)clientToken)) {
                            loginToken = URLEncoder.encode(clientToken + TOKEN_SPLIT + st, "UTF-8");
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)TAG, (Throwable)e);
                    }
                }
            }
            loginItem.uuid = uuid;
            loginItem.lifecycle = lifecycle;
            loginItem.loginToken = loginToken;
            loginItem.sessionKey = sSessionKey;
            loginItem.guest = guest;
            loginItem.resultType = resultType;
            loginItem.nick = nick;
            loginItem.avatar = avatar;
            loginItem.birthday = birthday;
            loginItem.sex = sex;
            loginItem.registerCountry = registerCountry;
            loginItem.realCountry = realCountry;
            loginItem.anti = anti;
            loginItem.auth_app = authApp;
            loginItem.hasPhonePwd = hasPhonePwd;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)("login data:" + loginItem.toString()), (Object[])new Object[0]);
        }
        if (!loginItem.isValid()) {
            resultCode = "114";
            resultDesc = null;
        }
        if (!resultCode.equals("00000")) {
            if (callBack != null) {
                callBack.onError(resultCode, resultDesc, resultDesc);
            }
            MLog.error((Object)TAG, (String)"handleLoginTokenDatas %s, %s ", (Object[])new Object[]{resultCode, resultDesc});
            return resultCode;
        }
        if (callBack != null) {
            callBack.onSuccess(loginItem);
        }
        return SUCCESS_RESULT_CODE;
    }

    protected String handleLoginTokenDatasInner(String response, String sessionSecret, ILoginRequestCallBack callBack) {
        return this.handleLoginTokenDatasInner(response, sessionSecret, false, callBack);
    }

    protected void handleLoginError(Throwable e, LoginThirdPartyItem item, IRetryStrategy retryStrategy, int theMaxRetryTimes) {
        int maxRetryTimes;
        MLog.info((Object)"LoginRequestManager", (String)("login thirdparty error =" + e), (Object[])new Object[0]);
        int n = maxRetryTimes = retryStrategy != null ? retryStrategy.getMaxRetryTimes() : theMaxRetryTimes;
        if (maxRetryTimes <= item.curRetryTimes) {
            if (this.canUseIp()) {
                this.loginWithThirdPartyByIp(UriProvider.THIRDPARTYAUTH_LOGIN_IP_ONE, item, 1);
            } else if (item.callBack != null) {
                MLog.error((Object)"LoginRequestManager ", (String)"login thirdparty error =", (Throwable)e, (Object[])new Object[0]);
                item.callBack.onError("111", "", "" + e);
                CommonPerfUtils.statLoginEvent((int)1, (boolean)false, (int)(item.curRetryTimes + item.retryWithIpTimes), (String)item.errorInfo, (int)((int)(SystemClock.elapsedRealtime() - item.startTime)), (String)UriProvider.LoginWithThirdPlatform, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
            }
        } else {
            String curError;
            String string = curError = e != null ? e.toString() : "";
            if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                curError = curError.substring(0, 200);
            }
            boolean useIp = this.useIp(item.errorInfo, curError);
            item.errorInfo = item.errorInfo != null ? item.errorInfo + "__" + curError : curError;
            if (useIp && this.canUseIp()) {
                this.loginWithThirdPartyByIp(UriProvider.THIRDPARTYAUTH_LOGIN_IP_ONE, item, 2);
            } else {
                ++item.curRetryTimes;
                if (retryStrategy != null) {
                    this.loginWithThirdPartyInner(item, retryStrategy);
                } else {
                    this.loginWithThirdPartyInner(item, maxRetryTimes);
                }
            }
        }
    }

    protected Map<String, String> createRefreshTokenParams(String token, ClientToken clientToken) {
        HashMap<String, String> params = new HashMap<String, String>(6);
        if (StringUtils.isEmpty((String)token) || clientToken == null) {
            return params;
        }
        String st = clientToken.st;
        params.put("s_t", st);
        params.put(KEY_C_AUTH, clientToken.auth);
        params.put(KEY_APPID, APPID_VALUE);
        params.put(KEY_APPNAME, this.getAppName());
        params.put(KEY_UID, String.valueOf(AccountUtil.getUid()));
        return params;
    }

    protected Map<String, String> createRefreshTokenParams(long uuid, String token, String sessionKey) {
        HashMap<String, String> params = new HashMap<String, String>(6);
        if (StringUtils.isEmpty((String)token)) {
            return params;
        }
        ClientToken clientToken = this.getClientTokenParams(uuid, token, sessionKey);
        if (clientToken != null) {
            params.put("s_t", clientToken.st);
            params.put(KEY_C_AUTH, clientToken.auth);
        }
        params.put(KEY_APPID, APPID_VALUE);
        params.put(KEY_APPNAME, this.getAppName());
        params.put(KEY_UID, String.valueOf(AccountUtil.getUid()));
        return params;
    }

    protected Map<String, String> createThirdPartyLoginParams(int platformId, String appIdFromPlatform, String token, String idToken, String userId, String mail, String secretKey) {
        ClientToken clientToken;
        HashMap<String, String> params = new HashMap<String, String>(14);
        if (StringUtils.isEmpty((String)token) && StringUtils.isEmpty((String)idToken)) {
            return params;
        }
        String openSecretKey = secretKey;
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String ts = "";
        try {
            ts = DES3Utils.encrypt((String)curTimeStr, (String)openSecretKey);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        params.put("ts", ts);
        params.put(KEY_THIRD_PARTY_USERID, userId != null ? userId : "");
        if (StringUtils.isNotEmpty((String)mail)) {
            params.put(KEY_THIRD_PARTY_USER_MAIL, mail);
        }
        params.put(KEY_THIRD_PARTY_OPEN_SOURCE, String.valueOf(platformId));
        if (StringUtils.isNotEmpty((String)token)) {
            params.put(KEY_THIRD_PARTY_ACCESS_TOKEN, token);
        }
        if (StringUtils.isNotEmpty((String)idToken)) {
            params.put(KEY_THIRD_PARTY_ID_TOKEN, idToken);
        }
        params.put(KEY_THIRD_PARTY_APP_ID, appIdFromPlatform);
        params.put(KEY_DEVICE_ID, this.getDeviceId());
        params.put(KEY_DEVICE_TYPE, MY_DEVICE_TYPE);
        params.put(KEY_APPID, APPID_VALUE);
        params.put(KEY_APPNAME, this.getAppName());
        LoginUtil.initCountryCodeParam(params);
        AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
        if (accountInfo != null && accountInfo.isValid() && accountInfo.loginType == 10 && (clientToken = this.getClientTokenParams(accountInfo.uuid, accountInfo.token, accountInfo.sessionKey)) != null) {
            params.put(KEY_GUEST_S_T, clientToken.st);
            params.put(KEY_GUEST_C_AUTH, clientToken.auth);
            MLog.info((Object)TAG, (String)"createThirdPartyLoginParams s_t:%s, c_auth:%s", (Object[])new Object[]{clientToken.st, clientToken.auth});
        }
        return params;
    }

    protected ClientToken getClientTokenParams(long uuid, String token, String sessionKey) {
        String tokenDecode = null;
        try {
            tokenDecode = URLDecoder.decode(token, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        if (StringUtils.isEmpty((String)tokenDecode)) {
            return null;
        }
        String[] tokenDatas = tokenDecode.split(TOKEN_SPLIT);
        if (tokenDatas.length < 2) {
            return null;
        }
        String clientToken = null;
        ClientToken clientTokenData = new ClientToken();
        JSONObject tokenJoson = JsonParser.obtainJSONObject();
        try {
            long time = System.currentTimeMillis();
            tokenJoson.put(KEY_RESPONSE_UUID, uuid);
            tokenJoson.put("timestamp", time);
            String clientJosn = tokenJoson.toString();
            clientTokenData.uuid = uuid;
            clientTokenData.time = time;
            clientTokenData.clientJosn = clientJosn;
            clientTokenData.sessionKey = sessionKey;
            try {
                clientToken = DES3Utils.encrypt((String)clientJosn, (String)sessionKey);
            }
            catch (UnsupportedEncodingException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        clientTokenData.st = tokenDatas[1];
        clientTokenData.auth = clientToken;
        return clientTokenData;
    }

    protected String getDeviceId() {
        return HiidoUtils.getHdid();
    }

    protected boolean canUseIp() {
        if (EnvSettings.instance().getUriSettingValue() == EnvSettingType.Test) {
            return false;
        }
        return SettingFlags.getBoolean((String)"loginuseip", (boolean)true);
    }

    protected boolean useIp(String oldErrorInfo, String curErrorInfo) {
        boolean result = false;
        if (StringUtils.isNotEmpty((String)oldErrorInfo) && StringUtils.isNotEmpty((String)curErrorInfo)) {
            if (oldErrorInfo.contains("java.net.ConnectException") && curErrorInfo.contains("java.net.ConnectException")) {
                result = true;
            } else if (oldErrorInfo.contains("java.net.UnknownHostException") && curErrorInfo.contains("java.net.UnknownHostException")) {
                result = true;
            } else if (oldErrorInfo.contains("java.net.SocketTimeoutException") && curErrorInfo.contains("java.net.SocketTimeoutException")) {
                result = true;
            } else if (oldErrorInfo.contains("javax.net.ssl.SSLHandshakeException") && curErrorInfo.contains("javax.net.ssl.SSLHandshakeException")) {
                result = true;
            }
        }
        return result;
    }

    public static void updateUrl(String localHost, String preRegisterHost, String registerHost, int idc, String webgameHost, String turnoverHost) {
        String testHost;
        MLog.error((Object)TAG, (String)"localHost = %s,preRegisterHost=%s, registerHost=%s,idc =%s,webgameHost=%s,turnoverHost%s", (Object[])new Object[]{localHost, preRegisterHost, registerHost, idc, webgameHost, turnoverHost});
        String registerHostBackUp = registerHost;
        try {
            registerHostBackUp = registerHost.replaceFirst("i-", "i-proxy-");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean testProxy = false;
        if (RuntimeContext.sIsDebuggable && EnvSettings.instance().getUriSettingValue() != EnvSettingType.Dev && (StringUtils.isEmpty((String)preRegisterHost) || StringUtils.equal((String)preRegisterHost, (String)registerHost)) && SettingFlags.getIntValue((String)"testserverproxy", (int)0) == 1) {
            if (StringUtils.equal((String)preRegisterHost, (String)registerHost)) {
                preRegisterHost = registerHostBackUp;
            }
            registerHost = registerHostBackUp;
            localHost = registerHostBackUp;
            testProxy = true;
        }
        if (!testProxy && RuntimeContext.sIsDebuggable && StringUtils.isNotEmpty((String)(testHost = SettingFlags.getStringValue((String)"setserverhost", null)))) {
            if (StringUtils.equal((String)preRegisterHost, (String)registerHost)) {
                preRegisterHost = testHost;
            }
            registerHost = testHost;
            localHost = testHost;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)("registerHostBackUp = " + registerHostBackUp), (Object[])new Object[0]);
        }
        UriProvider.updateUrl((String)localHost, (String)preRegisterHost, (String)registerHost, (String)registerHostBackUp, (int)idc, (String)webgameHost, (String)turnoverHost);
    }

    private String getAppName() {
        return AppKeysDef.getAppName();
    }

    @Override
    public void loginGuest(ILoginRequestCallBack callBack) {
        this.loginGuest(-1, callBack);
    }

    @Override
    public void loginGuest(int sex, final ILoginRequestCallBack callBack) {
        ILoginRequestCallBack actualCallBack = null;
        if (callBack != null) {
            actualCallBack = new ILoginRequestCallBack(){

                @Override
                public void onSuccess(final LoginData data) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(data);
                        }
                    });
                }

                @Override
                public void onError(final String errorCode, final String errorDescription, final String exceptionDue) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onError(errorCode, errorDescription, exceptionDue);
                        }
                    });
                }
            };
        }
        this.loginGuestInner(actualCallBack, 0, 1, SystemClock.elapsedRealtime(), sex);
    }

    private void loginGuestInner(final ILoginRequestCallBack callBack, final int retryTimes, final int maxRetryTimes, final long startTime, final int sex) {
        final String url = UriProvider.LoginGuestAuth;
        final String sessionSecret = SHAUtils.getSHA256((String)this.getDeviceId());
        Map<String, String> params = this.createLoginGuestParams();
        if (sex == 0 || sex == 1) {
            params.put("sex", "" + sex);
        }
        if (RuntimeContext.isHagoPartySdk() && AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().uuid > 0L) {
            if (callBack != null) {
                callBack.onError("-11110", "loginGuestInner had login " + AccountModel.getInstance().getAccountInfo().uuid, "");
            }
            return;
        }
        GraceWrapper.getGrace().newCall(GraceWrapper.postForString((String)url, params, null).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"LoginRequestManager", (String)("login guest =" + response), (Object[])new Object[0]);
                }
                if (RuntimeContext.isHagoPartySdk() && AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().uuid > 0L) {
                    if (callBack != null) {
                        callBack.onError("-11110", "onResponse had login " + AccountModel.getInstance().getAccountInfo().uuid, "");
                    }
                    return;
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    if (RuntimeContext.isHagoPartySdk() && AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().uuid > 0L) {
                        if (callBack != null) {
                            callBack.onError("-11110", "onResponse had login " + AccountModel.getInstance().getAccountInfo().uuid, "");
                        }
                        return;
                    }
                    String body = (String)response.body();
                    String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, callBack);
                    boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - startTime);
                    String string = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)2, (boolean)result, (int)retryTimes, (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                if (RuntimeContext.isHagoPartySdk() && AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().uuid > 0L) {
                    if (callBack != null) {
                        callBack.onError("-11110", "onFail had login " + AccountModel.getInstance().getAccountInfo().uuid, "");
                    }
                    return;
                }
                YYTaskExecutor.execute(() -> {
                    if (RuntimeContext.isHagoPartySdk() && AccountModel.getInstance().getAccountInfo() != null && AccountModel.getInstance().getAccountInfo().uuid > 0L) {
                        if (callBack != null) {
                            callBack.onError("-11110", "onFail had login " + AccountModel.getInstance().getAccountInfo().uuid, "");
                        }
                        return;
                    }
                    if (maxRetryTimes > retryTimes) {
                        BaseLoginRequestManager.this.loginGuestInner(callBack, retryTimes + 1, maxRetryTimes, startTime, sex);
                    } else if (BaseLoginRequestManager.this.canUseIp()) {
                        MLog.error((Object)"LoginRequestManager", (String)"use ip by login guest error =", (Throwable)e, (Object[])new Object[0]);
                        BaseLoginRequestManager.this.loginWithGuestByIp(UriProvider.GUEST_LOGIN_IP_ONE, callBack, 0, 1, startTime);
                    } else {
                        String curError;
                        MLog.error((Object)"LoginRequestManager", (String)"login guest error =", (Throwable)e, (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError("111", "", "" + e);
                        }
                        String string = curError = e != null ? e.toString() : "";
                        if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                            curError = curError.substring(0, 200);
                        }
                        CommonPerfUtils.statLoginEvent((int)2, (boolean)false, (int)retryTimes, (String)curError, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                    }
                });
            }
        });
    }

    private void loginWithGuestByIp(final String url, final ILoginRequestCallBack callBack, final int retryTimes, final int maxRetryTimes, final long startTime) {
        final String sessionSecret = SHAUtils.getSHA256((String)this.getDeviceId());
        Map<String, String> params = this.createLoginGuestParams();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", UriProvider.LOGIN_IP_HOST);
        GraceWrapper.getGrace().newCall(GraceWrapper.postForString((String)url, params, headers).group((Request.Group)BizScenc.NORMAL_LOGIN).build()).enqueue((Callback)new Callback<String>(){

            public void onResponse(Call<String> call, Response<String> response) {
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"LoginRequestManager", (String)("use ip login guest =" + response), (Object[])new Object[0]);
                }
                YYTaskExecutor.execute(() -> {
                    String reason;
                    String body = (String)response.body();
                    String resultCode = BaseLoginRequestManager.this.handleLoginTokenDatasInner(body, sessionSecret, callBack);
                    boolean result = BaseLoginRequestManager.SUCCESS_RESULT_CODE.equals(resultCode);
                    int useTime = (int)(SystemClock.elapsedRealtime() - startTime);
                    String string = reason = result ? "" : "has response but parse error!";
                    if (!result && StringUtils.isNotEmpty((String)body)) {
                        reason = reason + response;
                    }
                    CommonPerfUtils.statLoginEvent((int)2, (boolean)result, (int)retryTimes, (String)reason, (int)useTime, (String)url, (String)resultCode);
                }, (long)3000L);
            }

            public void onFailure(Call<String> call, Throwable e) {
                YYTaskExecutor.execute(() -> {
                    if (maxRetryTimes > retryTimes && BaseLoginRequestManager.this.canUseIp()) {
                        MLog.error((Object)"LoginRequestManager", (String)"will retry by login guest error =", (Throwable)e, (Object[])new Object[0]);
                        BaseLoginRequestManager.this.loginWithGuestByIp("http://47.52.230.226/uaas/login/guestAuth", callBack, retryTimes + 1, maxRetryTimes, startTime);
                    } else {
                        String curError;
                        MLog.error((Object)"LoginRequestManager", (String)"use ip login guest error =", (Throwable)e, (Object[])new Object[0]);
                        if (callBack != null) {
                            callBack.onError("111", "", "" + e);
                        }
                        String string = curError = e != null ? e.toString() : "";
                        if (StringUtils.isNotEmpty((String)curError) && curError.length() > 200) {
                            curError = curError.substring(0, 200);
                        }
                        CommonPerfUtils.statLoginEvent((int)2, (boolean)false, (int)retryTimes, (String)curError, (int)((int)(SystemClock.elapsedRealtime() - startTime)), (String)url, (String)String.valueOf(NetworkUtils.getErrorCodeByExc((Throwable)e)));
                    }
                });
            }
        });
    }

    private Map<String, String> createLoginGuestParams() {
        String curTimeStr = String.valueOf(System.currentTimeMillis());
        String deviceId = this.getDeviceId();
        String desSecret = SHAUtils.getSHA256((String)deviceId);
        String curTimeStrDES3 = "";
        try {
            curTimeStrDES3 = DES3Utils.encrypt((String)curTimeStr, (String)desSecret);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
        String ts = curTimeStrDES3;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ts", ts);
        params.put(KEY_DEVICE_ID, deviceId);
        params.put(KEY_DEVICE_TYPE, MY_DEVICE_TYPE);
        params.put("timestamp", curTimeStr);
        params.put(KEY_APPID, APPID_VALUE);
        params.put(KEY_APPNAME, AppKeysDef.getAppName());
        LoginUtil.initCountryCodeParam(params);
        return params;
    }

    public static class BasicItem {
        public volatile int maxRetryTimes = 0;
        public volatile int curRetryTimes = 0;
        public volatile String url;
        public String ipHost = UriProvider.LOGIN_IP_HOST;
        public volatile boolean curUseIp = false;
    }

    private static class LoginThirdPartyItem
    extends BasicLoginItem {
        public int platformId;
        public String appIdFromPlatform;
        public String token;
        public String idToken;
        public String userId;
        public String mail;
        public volatile int retryWithIpTimes = 0;
        public String errorInfo = "";
        public long startTime;

        LoginThirdPartyItem() {
            this.maxRetryTimes = 2;
        }
    }

    protected static class BasicLoginItem
    extends BasicItem {
        public ILoginRequestCallBack callBack;

        protected BasicLoginItem() {
        }

        public void listenCallBack(final ILoginRequestCallBack callBack) {
            this.callBack = callBack == null ? null : new ILoginRequestCallBack(){

                @Override
                public void onSuccess(final LoginData data) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onSuccess(this.packData(data));
                        }
                    });
                }

                @Override
                public void onError(final String errorCode, final String errorDescription, final String exceptionDue) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callBack.onError(errorCode, errorDescription, exceptionDue);
                        }
                    });
                }
            };
        }

        protected LoginData packData(LoginData data) {
            return data;
        }
    }

    protected static class RefreshTokenItem
    extends BasicLoginItem {
        public long uuid;
        public String token;
        public String sessionKey;

        RefreshTokenItem() {
            this.maxRetryTimes = 1;
        }
    }

    public static class ClientToken {
        public String auth;
        public String st;
        public long uuid;
        public long time;
        public String sessionKey;
        public String clientJosn;
    }
}

