/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.account;

import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.login.account.AccountInfo;
import java.util.ArrayList;
import java.util.List;

@DontProguardClass
public class AccountList {
    private static final int MAX_NUM = 50;
    public List<AccountInfo> accountInfos = new ArrayList<AccountInfo>(3);

    private synchronized ArrayList<AccountInfo> getAccountsInner() {
        if (this.accountInfos == null) {
            this.accountInfos = new ArrayList<AccountInfo>(3);
        }
        return (ArrayList)this.accountInfos;
    }

    public synchronized AccountInfo findAccountInfo(long uid) {
        if (this.accountInfos == null || this.accountInfos.size() <= 0) {
            return null;
        }
        for (AccountInfo info : this.accountInfos) {
            if (info.uuid != uid) continue;
            return info;
        }
        return null;
    }

    public synchronized boolean addAccount(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return false;
        }
        AccountInfo info = this.deleteAccount(accountInfo.uuid);
        this.fillExtendParams(accountInfo, info);
        this.getAccountsInner().add(0, accountInfo);
        if (this.getAccountsInner().size() > 50) {
            this.getAccountsInner().remove(this.getAccountsInner().size() - 1);
        }
        return true;
    }

    private void fillExtendParams(AccountInfo accountInfo, AccountInfo info) {
        if (info != null && accountInfo != null) {
            if (StringUtils.isNotEmpty((String)info.userName) && StringUtils.isEmpty((String)accountInfo.userName)) {
                accountInfo.userName = info.userName;
            }
            if (StringUtils.isNotEmpty((String)info.iconUrl) && StringUtils.isEmpty((String)accountInfo.iconUrl)) {
                accountInfo.iconUrl = info.iconUrl;
            }
            if (info.vid > 0L && accountInfo.vid <= 0L) {
                accountInfo.vid = info.vid;
                accountInfo.sex = info.sex;
            }
        }
    }

    public synchronized boolean updateAccount(AccountInfo accountInfo) {
        if (accountInfo == null) {
            return false;
        }
        AccountInfo accountFinded = this.findAccountInfo(accountInfo.uuid);
        if (accountFinded != null) {
            this.fillExtendParams(accountInfo, accountFinded);
            int index = this.getAccountsInner().indexOf(accountFinded);
            this.getAccountsInner().remove(accountFinded);
            this.getAccountsInner().add(index, accountInfo);
        } else {
            this.getAccountsInner().add(0, accountInfo);
            if (this.getAccountsInner().size() > 50) {
                this.getAccountsInner().remove(this.getAccountsInner().size() - 1);
            }
        }
        return true;
    }

    public synchronized void updateAccounts(List<AccountInfo> infos) {
        if (infos == null || infos.size() <= 0) {
            return;
        }
        for (AccountInfo info : infos) {
            this.updateAccount(info);
        }
    }

    public synchronized AccountInfo deleteAccount(long uid) {
        AccountInfo info = this.findAccountInfo(uid);
        if (info != null) {
            this.getAccountsInner().remove(info);
            return info;
        }
        return null;
    }

    public synchronized boolean clear() {
        if (this.accountInfos == null || this.accountInfos.size() <= 0) {
            return false;
        }
        this.getAccountsInner().clear();
        return true;
    }

    public synchronized List<AccountInfo> getAccounts() {
        if (this.accountInfos == null || this.accountInfos.size() <= 0) {
            return new ArrayList<AccountInfo>(0);
        }
        return new ArrayList<AccountInfo>(this.accountInfos);
    }

    public synchronized boolean isEmpty() {
        return this.accountInfos == null || this.accountInfos.size() <= 0;
    }
}

