/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.base.language;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.os.LocaleList;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.LocaleUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import java.util.Locale;

public class LanguageLocaleHelper {
    private static final String TAG = "LanguageLocaleHelper";
    private static final String PRE_FILE = "locale_language_config";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_USER_REAL_COUNTRY = "user_real_country";
    private static String mSelectedLanguage = null;
    private static SharedPreferences preferences;
    private static boolean isInited;
    private static String userRealCountry;

    private static void init(Context context) {
        if (!isInited) {
            isInited = true;
            preferences = context.getSharedPreferences(PRE_FILE, 0);
            mSelectedLanguage = preferences.getString(KEY_LANGUAGE, null);
        }
    }

    public static Context wrapContext(Context base) {
        LanguageLocaleHelper.init(base);
        if (LanguageLocaleHelper.hasSetLanguage()) {
            return LanguageLocaleHelper.setLocaleLanguage(base, mSelectedLanguage);
        }
        return base;
    }

    private static Context setLocaleLanguage(Context base, String language) {
        Locale locale = new Locale(language, Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
        return LocaleUtil.applyLocale((Context)base, (Locale)locale);
    }

    @SuppressLint(value={"ApplySharedPref"})
    public static boolean saveLanguage(String language) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"saveLanguage from %s, to %s", (Object[])new Object[]{mSelectedLanguage, language});
        }
        if (StringUtils.equal((String)mSelectedLanguage, (String)language)) {
            return false;
        }
        Locale locale = new Locale(language, Locale.getDefault().getCountry(), Locale.getDefault().getVariant());
        Locale.setDefault(locale);
        preferences.edit().putString(KEY_LANGUAGE, language).commit();
        return true;
    }

    String getLanguage() {
        return preferences.getString(KEY_LANGUAGE, "");
    }

    private static boolean hasSetLanguage() {
        return !FP.empty((CharSequence)preferences.getString(KEY_LANGUAGE, ""));
    }

    public static boolean canShowEntry() {
        return LanguageLocaleHelper.hasSetLanguage() || LocaleUtil.isHindi();
    }

    public static void saveRealCountry(String country) {
        if (StringUtils.equals((String)country, (String)userRealCountry)) {
            return;
        }
        userRealCountry = country;
        if (preferences != null) {
            preferences.edit().putString(KEY_USER_REAL_COUNTRY, userRealCountry).apply();
        }
    }

    private static String getCountry() {
        String real;
        if (StringUtils.isNotEmpty((String)userRealCountry)) {
            return userRealCountry;
        }
        if (preferences != null && StringUtils.isNotEmpty((String)(real = preferences.getString(KEY_USER_REAL_COUNTRY, "")))) {
            userRealCountry = real;
        }
        if (StringUtils.isEmpty((String)userRealCountry)) {
            userRealCountry = SystemUtils.getDeviceCountry();
        }
        return userRealCountry;
    }

    private static Locale getContextLocale(Context context) {
        Locale locale = null;
        Configuration configuration = context.getResources().getConfiguration();
        if (configuration == null) {
            return Locale.getDefault();
        }
        if (Build.VERSION.SDK_INT >= 24) {
            LocaleList list = configuration.getLocales();
            locale = list.get(0);
        } else {
            locale = configuration.locale;
        }
        return locale == null ? Locale.getDefault() : locale;
    }

    static {
        isInited = false;
        userRealCountry = "";
    }
}

