/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.base.utils;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.yy.base.memoryrecycle.views.YYButton;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.login.base.R;

public class NextBtn
extends YYFrameLayout {
    private YYButton mBtn;

    public NextBtn(Context context) {
        super(context);
        this.init(context);
    }

    public NextBtn(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public NextBtn(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    private void init(Context context) {
        int btnTextSize = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_textsize);
        int arrowWidth = ResourceUtils.getDimen((int)R.dimen.login_select_type_arrow_height);
        int arrowTopMargin = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_arrow_topmargin);
        this.mBtn = new YYButton(context);
        this.mBtn.setTextColor(ResourceUtils.getColor((int)R.color.common_white_text));
        this.mBtn.setTextSize(0, (float)btnTextSize);
        this.mBtn.getPaint().setFakeBoldText(true);
        this.mBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.login_phone_window_next_btn));
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.gravity = 17;
        this.mBtn.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.addView((View)this.mBtn);
        Drawable arrowDrawable = ResourceUtils.getDrawable((int)R.drawable.register_icon_arrow_white);
        arrowDrawable.setBounds(0, arrowTopMargin, arrowWidth, arrowWidth + arrowTopMargin);
        this.mBtn.setCompoundDrawables(null, null, arrowDrawable, null);
        this.mBtn.setBackgroundDrawable(null);
        StateListDrawable bgColorDrawable = new StateListDrawable();
        bgColorDrawable.addState(new int[]{16842919}, ResourceUtils.getDrawable((int)R.drawable.next_btn_press));
        bgColorDrawable.addState(new int[]{16842910}, ResourceUtils.getDrawable((int)R.drawable.next_btn_normal));
        bgColorDrawable.addState(new int[0], ResourceUtils.getDrawable((int)R.drawable.next_btn_unable));
        this.setBackgroundDrawable((Drawable)bgColorDrawable);
        this.mBtn.setClickable(false);
    }

    public LinearLayout.LayoutParams createLLayoutParams() {
        int btnTopMargin = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_topmargin);
        return this.createLLayoutParams(btnTopMargin);
    }

    public LinearLayout.LayoutParams createLLayoutParams(int topMargin) {
        int btnHeight = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_height);
        int btnTopMargin = topMargin;
        int btnBottomMargin = ResourceUtils.getDimen((int)R.dimen.login_phone_next_btn_bottommargin);
        int leftPadding = ResourceUtils.getDimen((int)R.dimen.login_phone_window_leftpadding);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, btnHeight);
        layoutParams.topMargin = btnTopMargin;
        layoutParams.bottomMargin = btnBottomMargin;
        layoutParams.leftMargin = leftPadding;
        layoutParams.rightMargin = leftPadding;
        return layoutParams;
    }

    public final void setText(CharSequence text) {
        this.mBtn.setText(text);
    }

    public void hideArrow() {
        this.mBtn.setCompoundDrawables(null, null, null, null);
    }

    public void setBg(Drawable drawable2) {
        this.setBackgroundDrawable(drawable2);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }
}

