/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.account;

import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.login.account.LoginData;

public class PhoneLoginData
extends LoginData {
    public String phoneNumFull = "";
    public String countryCode = "";
    public String password = "";
    public String passwordSha = "";
    public int phoneMode;

    public PhoneLoginData() {
    }

    public PhoneLoginData(LoginData data) {
        super(data);
        if (data instanceof PhoneLoginData) {
            PhoneLoginData exist = (PhoneLoginData)data;
            this.phoneNumFull = exist.phoneNumFull;
            this.countryCode = exist.countryCode;
            this.password = exist.password;
            this.passwordSha = exist.passwordSha;
            this.phoneMode = exist.phoneMode;
        }
    }

    public String getPhoneNum() {
        String phoneNum = this.phoneNumFull;
        if (StringUtils.isNotEmpty((String)phoneNum)) {
            phoneNum = phoneNum.substring(this.countryCode != null ? this.countryCode.length() : 0);
        }
        return phoneNum;
    }

    public String getPhoneNumFull() {
        return this.phoneNumFull;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.phoneNumFull) && !StringUtils.isEmpty((String)this.countryCode);
    }

    @Override
    public String toString() {
        if (!RuntimeContext.sIsDebuggable) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append("phoneNumFull:").append(this.phoneNumFull).append(" ").append("countryCode:").append(this.countryCode).append(" ").append("passwordHash:").append(this.passwordSha).append(" ").append("phoneMode:").append(this.phoneMode).append(" ").append(super.toString());
        return builder.toString();
    }
}

