/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.login.stat.metric;

import android.text.TextUtils;
import com.yy.base.logger.MLog;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class LoginMetricHelper {
    private static final String FACEBOOK_SDK_URI = "login/facebook";
    private static final String GOOGLE_SDK_URI = "login/google";
    private static final String LINE_SDK_URI = "login/line";
    private static final String VK_SDK_URI = "login/vk";
    private static final String SNAPCHAT_SDK_URI = "login/snapchat";
    public static final String PHONE_SEND_SMS_URI = "login/sendSms";
    public static final String PHONE_SMS_AUTH_URI = "login/smsAuth";
    public static final String LOGIN_REPOERT_ANTI = "login/reportAnti";
    public static final String LOGIN_REFRESH_AUTH_URI = "login/refreshAuth";
    public static final String LOGIN_THIRD_PARTY_AUTH_URI = "login/thirdpartyAuth";
    private static final String FACEBOOK_CODE_START = "5000_";
    private static final String GOOGLE_CODE_START = "5001_";
    private static final String LINE_CODE_START = "5002_";
    private static final String VK_CODE_START = "5003_";
    private static final String ACCOUNT_KIT_START = "5004_";
    private static final String SNAPCHAT_CODE_START = "5005_";
    private static final String SERVICE_CODE_START = "0000_";
    public static final int LOGIN_METRIC_SERVICE_TYPE = 1;
    public static final int LOGIN_METRIC_FACEBOOK_TYPE = 2;
    public static final int LOGIN_METRIC_GOOGLE_TYPE = 3;
    public static final int LOGIN_METRIC_LINE_TYPE = 4;
    public static final int LOGIN_METRIC_VK_TYPE = 5;
    public static final int LOGIN_METRIC_SNAPCHAT_TYPE = 6;

    public static void reportToMetric(int metricType, String code) {
        LoginMetricHelper.reportToMetric(metricType, 0L, code, "");
    }

    public static void reportToMetric(int metricType, long time, String code, String uri) {
        code = LoginMetricHelper.getCodeStartByMetricType(metricType) + code;
        if (TextUtils.isEmpty((CharSequence)(uri = LoginMetricHelper.getUriByMetricType(metricType, uri)))) {
            return;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"LoginMetricHelper", (String)"reportToMetric uri: %s  time: %s  code: %s", (Object[])new Object[]{uri, time, code});
        }
    }

    private static String getCodeStartByMetricType(int metricType) {
        if (metricType == 2) {
            return FACEBOOK_CODE_START;
        }
        if (metricType == 3) {
            return GOOGLE_CODE_START;
        }
        if (metricType == 4) {
            return LINE_CODE_START;
        }
        if (metricType == 5) {
            return VK_CODE_START;
        }
        if (metricType == 6) {
            return SNAPCHAT_CODE_START;
        }
        return SERVICE_CODE_START;
    }

    private static String getUriByMetricType(int metricType, String uri) {
        if (metricType == 2) {
            return FACEBOOK_SDK_URI;
        }
        if (metricType == 3) {
            return GOOGLE_SDK_URI;
        }
        if (metricType == 4) {
            return LINE_SDK_URI;
        }
        if (metricType == 5) {
            return VK_SDK_URI;
        }
        if (metricType == 6) {
            return SNAPCHAT_SDK_URI;
        }
        return uri;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface MetricType {
    }
}

