/*
 * Decompiled with CFR 0.152.
 */
package com.yy.location;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.core.content.PermissionChecker;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.location.OnLocationCallback;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class LocationUtils {
    private static final String TAG = "LocationService";
    private static final int REQUEST_CODE_ASK_PERMISSIONS = 101;

    public static boolean isOpenLocService(Context context) {
        boolean isGps = false;
        boolean isNetwork = false;
        if (context != null) {
            if (SystemServiceUtils.getLocationManager((Context)context) != null) {
                isGps = SystemServiceUtils.getLocationManager((Context)context).isProviderEnabled("gps");
                isNetwork = SystemServiceUtils.getLocationManager((Context)context).isProviderEnabled("network");
            }
            if (isGps && isNetwork) {
                return true;
            }
        }
        return false;
    }

    public static boolean checkLocationPermission(Context context) {
        if (context == null) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 23) {
            boolean b1 = 0 == PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION");
            boolean b2 = 0 == PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
            return b1 || b2;
        }
        int target = context.getApplicationInfo().targetSdkVersion;
        if (target < 23) {
            boolean b1 = 0 == PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION");
            boolean b2 = 0 == PermissionChecker.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
            return b1 || b2;
        }
        boolean b1 = 0 == ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION");
        boolean b2 = 0 == ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION");
        return b1 || b2;
    }

    public static void gotoLocationServiceSettings(Activity activity) {
        if (activity != null && Build.VERSION.SDK_INT >= 23) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_COARSE_LOCATION"}, (int)101);
            ActivityCompat.requestPermissions((Activity)activity, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)101);
        }
    }

    public static void openPermissionSetting(Context ctx) {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                LocationUtils.openDefaultSetting(ctx);
            } else {
                String manufacture = Build.MANUFACTURER;
                if (manufacture.equalsIgnoreCase("Meizu")) {
                    Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
                    intent.addCategory("android.intent.category.DEFAULT");
                    intent.putExtra("packageName", ctx.getPackageName());
                    ctx.startActivity(intent);
                } else if (manufacture.equalsIgnoreCase("VIVO")) {
                    Intent intent = new Intent();
                    intent.setFlags(0x10000000);
                    intent.putExtra("package", ctx.getPackageName());
                    ComponentName comp = new ComponentName("com.vivo.permissionmanager", "com.vivo.permissionmanager.activity.PurviewTabActivity");
                    intent.setComponent(comp);
                    ctx.startActivity(intent);
                } else if (manufacture.equalsIgnoreCase("OPPO")) {
                    Intent intent = new Intent();
                    intent.addFlags(0x10000000);
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(Uri.fromParts((String)"package", (String)ctx.getPackageName(), null));
                    ctx.startActivity(intent);
                } else if (manufacture.equalsIgnoreCase("HUAWEI")) {
                    Intent intent = new Intent();
                    intent.addFlags(0x10000000);
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(Uri.fromParts((String)"package", (String)ctx.getPackageName(), null));
                    ctx.startActivity(intent);
                } else if (manufacture.equalsIgnoreCase("xiaomi")) {
                    LocationUtils.openDefaultSetting(ctx);
                } else {
                    Intent intent = new Intent();
                    intent.addFlags(0x10000000);
                    intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
                    intent.setData(Uri.fromParts((String)"package", (String)ctx.getPackageName(), null));
                    ctx.startActivity(intent);
                }
            }
        }
        catch (Exception e) {
            LocationUtils.openDefaultSetting(ctx);
        }
    }

    private static void openDefaultSetting(Context ctx) {
        try {
            Intent intent = new Intent();
            intent.addFlags(0x10000000);
            intent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
            intent.setData(Uri.fromParts((String)"package", (String)ctx.getPackageName(), null));
            ctx.startActivity(intent);
        }
        catch (Exception e1) {
            MLog.error((Object)TAG, (Throwable)e1);
        }
    }

    public static void getLocationStrFromLatAndLon(long uid, String latAndLon, final OnLocationCallback callback) {
        if (!TextUtils.isEmpty((CharSequence)latAndLon)) {
            final String[] location = latAndLon.split("_");
            if (Geocoder.isPresent()) {
                if (location != null && location.length > 1 && LocationUtils.isCorrectLatAndLon(location)) {
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Geocoder geocoder = new Geocoder(RuntimeContext.sApplicationContext, Locale.getDefault());
                            try {
                                List addresses = geocoder.getFromLocation(StringUtils.safeParseDouble((String)location[1]), StringUtils.safeParseDouble((String)location[0]), 1);
                                if (addresses != null && addresses.size() > 0) {
                                    final Address address = (Address)addresses.get(0);
                                    if (callback != null) {
                                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                callback.onLocation(address.getLocality());
                                            }
                                        });
                                    }
                                } else {
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            callback.onLocation("");
                                        }
                                    });
                                }
                            }
                            catch (IOException e) {
                                MLog.error((Object)LocationUtils.TAG, (Throwable)e);
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        callback.onLocation("");
                                    }
                                });
                            }
                        }
                    });
                } else if (callback != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            callback.onLocation("");
                        }
                    });
                }
            } else {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.onLocation("");
                    }
                });
            }
        } else if (callback != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    callback.onLocation("");
                }
            });
        }
    }

    private static boolean isCorrectLatAndLon(String[] location) {
        return !(StringUtils.safeParseDouble((String)location[1]) < -90.0 || StringUtils.safeParseDouble((String)location[1]) > 90.0 || StringUtils.safeParseDouble((String)location[0]) < -180.0) && !(StringUtils.safeParseDouble((String)location[0]) > 180.0);
    }

    public static double getDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        float[] res = new float[1];
        Location.distanceBetween((double)latitude1, (double)longitude1, (double)latitude2, (double)longitude2, (float[])res);
        return res[0] / 1000.0f;
    }
}

