/*
 * Decompiled with CFR 0.152.
 */
package com.yy.im.module.room.holder;

import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.honor.HonorInfo;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.UserInfoModule;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnAlbumCallback;
import com.yy.appbase.service.callback.OnGetInsPhotosCallback;
import com.yy.appbase.service.callback.OnGetLatestHonorCallback;
import com.yy.appbase.service.callback.OnProfileCallback;
import com.yy.appbase.ui.adapter.BaseItemBinder;
import com.yy.appbase.ui.utils.LayoutUtil;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.im.R;
import com.yy.im.model.h;
import com.yy.im.module.room.holder.ChatBaseHolder;
import com.yy.im.module.room.holder.dp;
import com.yy.im.module.room.holder.dq;
import com.yy.im.module.room.holder.dr;
import com.yy.im.module.room.holder.ds;
import com.yy.im.module.room.holder.dt;
import com.yy.im.module.room.holder.du;
import com.yy.im.module.room.holder.dw;
import com.yy.location.LocationUtils;
import com.yy.location.OnLocationCallback;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

@DontProguardClass
public class ChatProfileHolder
extends ChatBaseHolder
implements View.OnClickListener {
    private YYRelativeLayout rlytCard;
    private YYRelativeLayout rlytCardInfo;
    private YYTextView tvUserName;
    private YYTextView tvAge;
    private YYTextView tvAddress;
    private YYTextView tvTime;
    private YYTextView tvSign;
    private YYImageView viewBg;
    private YYImageView ivOverlap;
    private RoundConerImageView ivAvatar;
    private RecycleImageView ivHonor;
    private Drawable drawableFemale;
    private Drawable drawableMale;
    private IUserInfoService userInfoService;
    private long mUid;
    private List<String> urlList;
    private HonorInfo mHonorInfo;
    private boolean isGetphotos = false;
    private boolean isGetHonrInfo = false;
    private boolean isgetInstagramPhotos = false;
    private boolean isgetUserInfo = false;
    private UserInfoBean userInfo;

    public ChatProfileHolder(View view, IMvpContext iMvpContext) {
        super(view, iMvpContext);
        this.rlytCard = (YYRelativeLayout)view.findViewById(R.id.rlyt_card);
        this.rlytCardInfo = (YYRelativeLayout)view.findViewById(R.id.rlyt_card_info);
        this.ivAvatar = (RoundConerImageView)view.findViewById(R.id.iv_user_avatar);
        this.tvUserName = (YYTextView)view.findViewById(R.id.tv_user_name);
        this.tvAge = (YYTextView)view.findViewById(R.id.tv_user_age);
        this.tvSign = (YYTextView)view.findViewById(R.id.tv_sign);
        this.tvAddress = (YYTextView)view.findViewById(R.id.tv_user_address);
        this.tvTime = (YYTextView)view.findViewById(R.id.tv_time);
        this.viewBg = (YYImageView)view.findViewById(R.id.iv_profile_card_bg);
        this.ivOverlap = (YYImageView)view.findViewById(R.id.iv_overlap);
        this.ivHonor = (RecycleImageView)view.findViewById(R.id.iv_user_honor);
        this.drawableFemale = ResourceUtils.getDrawable((int)R.drawable.icon_female_white);
        this.drawableFemale.setBounds(0, 0, this.drawableFemale.getIntrinsicWidth(), this.drawableFemale.getIntrinsicHeight());
        this.drawableMale = ResourceUtils.getDrawable((int)R.drawable.icon_male_white);
        this.drawableMale.setBounds(0, 0, this.drawableMale.getIntrinsicWidth(), this.drawableMale.getIntrinsicHeight());
    }

    public static BaseItemBinder<h, ChatProfileHolder> getBinder(IMvpContext iMvpContext) {
        return new dp(iMvpContext);
    }

    public void setData(h h2) {
        super.setData((Object)h2);
        UserInfoBean userInfoBean = this.getUserInfo(h2.a.getUid());
        this.mUid = h2.a.getUid();
        if (userInfoBean == null) {
            ((UserInfoModule)KvoModuleManager.getModule(UserInfoModule.class)).getUserInfo(this.mUid, (OnProfileCallback)new dq(this, h2));
        } else {
            this.fillUserInfo(h2, userInfoBean);
        }
        this.userInfoService = (IUserInfoService)this.getServiceManager().getService(IUserInfoService.class);
        this.getPhotos();
        this.handleHonor();
    }

    private void fillUserInfo(h h2, UserInfoBean userInfoBean) {
        this.isgetUserInfo = true;
        this.userInfo = userInfoBean;
        this.reportProfileCardShow();
        this.showAvatar((RecycleImageView)this.ivAvatar, userInfoBean);
        this.setFormatTimeInfo((TextView)this.tvTime, h2);
        this.tvUserName.setText((CharSequence)(userInfoBean == null ? "" : userInfoBean.getNick()));
        this.ivAvatar.setTag(R.id.chat_message_data, (Object)h2);
        this.viewBg.setTag(R.id.chat_message_data, (Object)h2);
        this.rlytCardInfo.setTag(R.id.chat_message_data, (Object)h2);
        this.rlytCard.setTag(R.id.chat_message_data, (Object)h2);
        this.ivAvatar.setOnClickListener((View.OnClickListener)this);
        this.viewBg.setOnClickListener((View.OnClickListener)this);
        this.rlytCardInfo.setOnClickListener((View.OnClickListener)this);
        this.rlytCard.setOnClickListener((View.OnClickListener)this);
        this.tvAge.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.tvAddress.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        if (userInfoBean == null || TextUtils.isEmpty((CharSequence)userInfoBean.getSign())) {
            this.tvSign.setVisibility(8);
        } else {
            this.tvSign.setVisibility(0);
            this.tvSign.setText((CharSequence)userInfoBean.getSign());
        }
        if (userInfoBean != null && userInfoBean.getHideLocation() == 1L) {
            this.tvAddress.setVisibility(8);
        } else {
            this.tvAddress.setVisibility(0);
            if (userInfoBean != null) {
                String string2 = userInfoBean.getLocationCity();
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    this.tvAddress.setText((CharSequence)string2);
                } else {
                    LocationUtils.getLocationStrFromLatAndLon((long)userInfoBean.getUid(), (String)userInfoBean.getExtend(), (OnLocationCallback)new dr(this, userInfoBean));
                }
            } else {
                this.tvAddress.setText(R.string.profile_no_location);
            }
        }
        if (userInfoBean == null || userInfoBean.getSex() == 0) {
            this.tvAge.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)(userInfoBean == null ? "" : userInfoBean.getBirthday()))}));
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.tvAge, (Drawable)this.drawableFemale, null, null, null);
            this.tvAge.setBackgroundResource(R.drawable.bg_pink_corner);
            this.viewBg.setImageResource(R.drawable.ico_im_profile_card_female_bg);
        } else {
            this.tvAge.setText((CharSequence)StringUtils.formatWitUSLocal((String)"%d", (Object[])new Object[]{DateUtils.getAge((String)userInfoBean.getBirthday())}));
            LayoutUtil.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this.tvAge, (Drawable)this.drawableMale, null, null, null);
            this.tvAge.setBackgroundResource(R.drawable.bg_blue_corner);
            this.viewBg.setImageResource(R.drawable.ico_im_profile_card_male_bg);
        }
    }

    private void getPhotos() {
        if (this.userInfoService == null) {
            return;
        }
        this.urlList = new ArrayList<String>();
        this.userInfoService.getAlbum(this.mUid, (OnAlbumCallback)new ds(this));
        this.userInfoService.getInstagramPhotos(this.mUid, (OnGetInsPhotosCallback)new dt(this));
    }

    private void updateAvatarOvetlapStatus(List<String> list) {
        if (list != null) {
            this.urlList.addAll(list);
        }
        if (this.urlList != null && !this.urlList.isEmpty()) {
            this.ivOverlap.setVisibility(0);
        } else {
            this.ivOverlap.setVisibility(8);
        }
    }

    private void handleHonor() {
        if (this.userInfoService == null) {
            return;
        }
        this.ivHonor.setVisibility(8);
        this.userInfoService.getLatestHonor(this.mUid, (OnGetLatestHonorCallback)new du(this));
    }

    private void reportProfileCardShow() {
        if (this.isGetHonrInfo && this.isGetphotos && this.isgetInstagramPhotos && this.isgetUserInfo && this.userInfo != null) {
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_card_show").put("act_photo_num", String.valueOf(FP.size(this.urlList) + 1)).put("act_uid", String.valueOf(this.userInfo.getUid()));
            if (this.mHonorInfo != null) {
                hiidoEvent.put("honor_id", String.valueOf(this.mHonorInfo.getId()));
            } else {
                hiidoEvent.put("honor_id", String.valueOf(0));
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
            this.isgetUserInfo = false;
            this.isgetInstagramPhotos = false;
            this.isGetphotos = false;
            this.isGetHonrInfo = false;
        }
    }

    private void initHonor(HonorInfo honorInfo) {
        if (honorInfo == null) {
            this.ivHonor.setVisibility(8);
            ViewGroup.LayoutParams layoutParams2 = this.tvUserName.getLayoutParams();
            layoutParams2.width = -2;
            this.tvUserName.setLayoutParams(layoutParams2);
            return;
        }
        ViewGroup.LayoutParams layoutParams3 = this.tvUserName.getLayoutParams();
        layoutParams3.width = -1;
        this.tvUserName.setLayoutParams(layoutParams3);
        this.ivHonor.setVisibility(0);
        this.ivHonor.setTag((Object)honorInfo);
        this.ivHonor.setOnClickListener((View.OnClickListener)new dw(this));
        ImageLoader.loadImage((RecycleImageView)this.ivHonor, (String)honorInfo.getSicon());
    }

    public void onClick(View view) {
        if (view.getTag(R.id.chat_message_data) instanceof h) {
            h h2 = (h)view.getTag(R.id.chat_message_data);
            HiidoEvent hiidoEvent = HiidoEvent.obtain().eventId("20023799").put("function_id", "profile_card_click").put("act_uid", String.valueOf(h2.a.getUid()));
            if (this.urlList != null) {
                hiidoEvent.put("act_photo_num", String.valueOf(FP.size(this.urlList) + 1));
            }
            if (this.mHonorInfo != null) {
                hiidoEvent.put("honor_id", String.valueOf(this.mHonorInfo.getId()));
            } else {
                hiidoEvent.put("honor_id", String.valueOf(0));
            }
            HiidoStatis.reportEvent((HiidoEvent)hiidoEvent);
            if (this.getEventCallback() != null) {
                this.getEventCallback().a(h2.a.getUid(), 8);
            }
        }
    }

    static /* synthetic */ void access$000(ChatProfileHolder chatProfileHolder, h h2, UserInfoBean userInfoBean) {
        chatProfileHolder.fillUserInfo(h2, userInfoBean);
    }

    static /* synthetic */ YYTextView access$100(ChatProfileHolder chatProfileHolder) {
        return chatProfileHolder.tvAddress;
    }

    static /* synthetic */ long access$200(ChatProfileHolder chatProfileHolder) {
        return chatProfileHolder.mUid;
    }

    static /* synthetic */ void access$300(ChatProfileHolder chatProfileHolder, List list) {
        chatProfileHolder.updateAvatarOvetlapStatus(list);
    }

    static /* synthetic */ boolean access$402(ChatProfileHolder chatProfileHolder, boolean bl2) {
        chatProfileHolder.isGetphotos = bl2;
        return chatProfileHolder.isGetphotos;
    }

    static /* synthetic */ void access$500(ChatProfileHolder chatProfileHolder) {
        chatProfileHolder.reportProfileCardShow();
    }

    static /* synthetic */ boolean access$602(ChatProfileHolder chatProfileHolder, boolean bl2) {
        chatProfileHolder.isgetInstagramPhotos = bl2;
        return chatProfileHolder.isgetInstagramPhotos;
    }

    static /* synthetic */ void access$700(ChatProfileHolder chatProfileHolder, HonorInfo honorInfo) {
        chatProfileHolder.initHonor(honorInfo);
    }

    static /* synthetic */ boolean access$802(ChatProfileHolder chatProfileHolder, boolean bl2) {
        chatProfileHolder.isGetHonrInfo = bl2;
        return chatProfileHolder.isGetHonrInfo;
    }

    static /* synthetic */ HonorInfo access$902(ChatProfileHolder chatProfileHolder, HonorInfo honorInfo) {
        chatProfileHolder.mHonorInfo = honorInfo;
        return chatProfileHolder.mHonorInfo;
    }
}

