/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.homepage.newmain.data;

import android.util.Pair;
import android.util.SparseIntArray;
import androidx.lifecycle.MutableLiveData;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.bbs.base.service.IBbsService;
import com.yy.hiyo.channel.module.recommend.base.IDiscoverTabService;
import com.yy.hiyo.home.base.HomeABSetting;
import com.yy.hiyo.home.base.IHomeDataItem;
import com.yy.hiyo.home.base.LiveAbTest;
import com.yy.hiyo.home.base.homepage.data.IHomeMainModel;
import com.yy.hiyo.home.base.homepage.data.listener.IHomeDataChangedListener;
import com.yy.hiyo.module.homepage.newmain.data.Aso;
import com.yy.hiyo.module.homepage.newmain.data.ado;
import com.yy.hiyo.module.homepage.statistic.Aco;
import java.util.List;

public enum HomeMainModelCenter implements IHomeMainModel
{
    INSTANCE;

    private static final String TAG = "FTHomePage.Data HomeMainModelCenter";
    private Aso mModelImpl;
    private SparseIntArray mHomeItemTypeMap;
    private LiveAbTest bottomChannel;

    private HomeMainModelCenter() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"uid %d, country %s, sIsAppStarted %b, sIsServicesInited %b", (Object[])new Object[]{AccountUtil.getUid(), SystemUtils.getHagoCountry(), RuntimeContext.sIsAppStarted, RuntimeContext.sIsServicesInited});
        }
        this.init();
    }

    private void init() {
        this.mModelImpl = new Aso();
        this.initItemTypeMap();
    }

    private void initItemTypeMap() {
        this.mHomeItemTypeMap = new SparseIntArray();
        this.mHomeItemTypeMap.put(9, 20002);
        this.mHomeItemTypeMap.put(6, 20009);
        this.mHomeItemTypeMap.put(7, 20010);
        this.mHomeItemTypeMap.put(20001, 20008);
        this.mHomeItemTypeMap.put(3, 20008);
        this.mHomeItemTypeMap.put(20005, 20002);
    }

    public void readHomeData() {
        this.mModelImpl.ARo();
    }

    public void requestHomeData() {
        this.mModelImpl.ATo();
    }

    public Pair<List<? extends IHomeDataItem>, Boolean> getHomeDataLocal() {
        return this.mModelImpl.aFo();
    }

    public void addHomeDataListener(IHomeDataChangedListener<? super IHomeDataItem> iHomeDataChangedListener, boolean bl) {
        this.mModelImpl.ado(iHomeDataChangedListener, bl);
    }

    public void setDeepLinkParam(String string2) {
        this.mModelImpl.ado(string2);
    }

    public void reqWithUri(String string2) {
        this.mModelImpl.ARo(string2);
    }

    public boolean hasEntryType(int n2) {
        return this.mModelImpl.ado(n2);
    }

    public void removeHomeDataListener(IHomeDataChangedListener iHomeDataChangedListener) {
        this.mModelImpl.ado(iHomeDataChangedListener);
    }

    public void onHomeWindowShown(boolean bl, boolean bl2) {
        this.mModelImpl.ado(bl, bl2);
    }

    public void onHomeWindowHidden() {
        this.mModelImpl.aPo();
    }

    public int getItemType(int n2) {
        return this.mHomeItemTypeMap.get(n2);
    }

    public void onModuleDeleted(Object object) {
        this.mModelImpl.ado(object);
    }

    public boolean hasBottomChannelTab() {
        boolean bl;
        RuntimeContext.hasMainBottomChannel = bl = ado.ARo.ado();
        return bl;
    }

    public boolean hasDiscoveryTab() {
        if (SystemUtils.isShowEnvSetting() && ((IBbsService)ServiceManagerProxy.getService(IBbsService.class)).isFakeService()) {
            return false;
        }
        return ((IDiscoverTabService)ServiceManagerProxy.getService(IDiscoverTabService.class)).isBbsAvailable();
    }

    public boolean isMainWithNavBottom() {
        return HomeABSetting.INSTANCE.isNewMain();
    }

    public MutableLiveData<Boolean> getGameRecommendUpdateLiveData() {
        return this.mModelImpl.ago();
    }

    public void setDeeplinkId(String string2) {
        Aco.ado(string2);
    }
}

