/*
 * Decompiled with CFR 0.152.
 */
package com.yy.yylite.hiido;

import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.HardwareUtils;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class HiidoExecutor
implements IYYTaskExecutor {
    private static final String TAG = "HiidoExecutor";
    private static int MAX_CONCURRENCY_TASKS = HardwareUtils.getCpuCoreCount() >= 4 ? 10 : 8;
    private AtomicInteger mCurrentActiveTasks = new AtomicInteger(0);
    private final ArrayList<HiidoRunnable> mRunnableToPost = new ArrayList(0);
    private final HashMap<Runnable, HiidoRunnable> mRunnableDelayMap = new HashMap();

    public void postToMainThread(Runnable task, long delayMillis) {
        YYTaskExecutor.postToMainThread((Runnable)task, (long)delayMillis);
    }

    public void postIdleRunnableToMainThread(Runnable task) {
        YYTaskExecutor.postIdleRunnableToMainThread((Runnable)task);
    }

    public void removeRunnableFromMainThread(Runnable task) {
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)task);
    }

    public boolean isMainThread() {
        return YYTaskExecutor.isMainThread();
    }

    public com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor createAQueueExcuter() {
        return new HiidoQueueTaskExecutor(YYTaskExecutor.createAQueueExcuter());
    }

    public void execute(Runnable task, long delayMillis) {
        this.execute(task, null, delayMillis, 10);
    }

    public void execute(Runnable task, long delayMillis, int priority) {
        this.execute(task, null, delayMillis, priority);
    }

    public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
        this.execute(task, callbackInMainThread, delayMillis, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int priority) {
        if (task == null) {
            return;
        }
        HiidoRunnable runNow = null;
        if (delayMillis > 0L) {
            MLog.debug((Object)TAG, (String)"execute task: %s, delay: %d", (Object[])new Object[]{task.getClass().getName(), delayMillis});
            runNow = new HiidoRunnable(task, callbackInMainThread, delayMillis, priority);
            HashMap<Runnable, HiidoRunnable> hashMap = this.mRunnableDelayMap;
            synchronized (hashMap) {
                this.mRunnableDelayMap.put(task, runNow);
            }
            YYTaskExecutor.execute((Runnable)runNow, (Runnable)callbackInMainThread, (long)delayMillis, (int)priority);
            return;
        }
        ArrayList<HiidoRunnable> arrayList = this.mRunnableToPost;
        synchronized (arrayList) {
            this.mRunnableToPost.add(new HiidoRunnable(task, callbackInMainThread, delayMillis, priority));
        }
        this.executeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(Runnable task) {
        if (task == null) {
            return;
        }
        MLog.debug((Object)TAG, (String)"removeTask task: %s", (Object[])new Object[]{task.getClass().getName()});
        HiidoRunnable realRunnable = null;
        Cloneable cloneable = this.mRunnableDelayMap;
        synchronized (cloneable) {
            realRunnable = this.mRunnableDelayMap.remove(task);
        }
        cloneable = this.mRunnableToPost;
        synchronized (cloneable) {
            if (this.mRunnableToPost.size() > 0) {
                for (HiidoRunnable hiidoRunnable : this.mRunnableToPost) {
                    if (hiidoRunnable == null || hiidoRunnable.mRunnable != task) continue;
                    this.mRunnableToPost.remove(hiidoRunnable);
                    break;
                }
            }
        }
        if (realRunnable != null) {
            YYTaskExecutor.removeTask((Runnable)realRunnable);
            this.executeNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeNext() {
        HiidoRunnable runNow = null;
        ArrayList<HiidoRunnable> arrayList = this.mRunnableToPost;
        synchronized (arrayList) {
            if (this.mRunnableToPost.size() > 0) {
                if (this.mCurrentActiveTasks.get() < MAX_CONCURRENCY_TASKS) {
                    this.mCurrentActiveTasks.incrementAndGet();
                    runNow = this.mRunnableToPost.get(0);
                    this.mRunnableToPost.remove(0);
                } else {
                    MLog.debug((Object)TAG, (String)"executeNext fail, tasks is over max", (Object[])new Object[0]);
                }
            }
        }
        if (runNow != null) {
            YYTaskExecutor.execute(runNow, (Runnable)runNow.mCallbackInMainThread, (long)runNow.mDelayMillis, (int)runNow.mPriority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onTaskFinished(HiidoRunnable runnable) {
        this.mCurrentActiveTasks.decrementAndGet();
        if (runnable != null) {
            HashMap<Runnable, HiidoRunnable> hashMap = this.mRunnableDelayMap;
            synchronized (hashMap) {
                this.mRunnableDelayMap.remove(runnable.mRunnable);
            }
        }
        this.executeNext();
    }

    private void onTaskBegin(HiidoRunnable runnable) {
        if (runnable.mDelayMillis > 0L) {
            MLog.debug((Object)TAG, (String)"onTaskBegin tasks: %d", (Object[])new Object[]{this.mCurrentActiveTasks.get()});
            this.mCurrentActiveTasks.incrementAndGet();
        }
    }

    private class HiidoRunnable
    implements Runnable {
        public Runnable mRunnable;
        public Runnable mCallbackInMainThread = null;
        public long mDelayMillis = 0L;
        public int mPriority = 10;

        HiidoRunnable(Runnable runnable) {
            this.mRunnable = runnable;
        }

        HiidoRunnable(Runnable runnable, Runnable callbackInMainThread, long delayMillis, int priority) {
            this.mRunnable = runnable;
            this.mCallbackInMainThread = callbackInMainThread;
            this.mDelayMillis = delayMillis;
            this.mPriority = priority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    HiidoExecutor.this.onTaskBegin(this);
                    if (this.mRunnable != null) {
                        this.mRunnable.run();
                    }
                    HiidoExecutor.this.onTaskFinished(this);
                    if (!RuntimeContext.sIsDebuggable || this.mRunnable == null) break block6;
                    HiidoExecutor hiidoExecutor = HiidoExecutor.this;
                    synchronized (hiidoExecutor) {
                        MLog.debug((Object)HiidoExecutor.TAG, (String)"onTaskFinished: %s, RunnableToPost: %s", (Object[])new Object[]{this.mRunnable.getClass().getName(), HiidoExecutor.this.mRunnableToPost.size()});
                    }
                }
                catch (Throwable throwable) {
                    HiidoExecutor.this.onTaskFinished(this);
                    MLog.error((Object)HiidoExecutor.TAG, (String)"onTaskFinished: %s, error: %s", (Object[])new Object[]{this.mRunnable, throwable});
                    throw throwable;
                }
            }
        }
    }

    private static class HiidoQueueTaskExecutor
    implements com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor {
        private IQueueTaskExecutor mExecutor;

        HiidoQueueTaskExecutor(IQueueTaskExecutor queueTaskExecutor) {
            this.mExecutor = queueTaskExecutor;
        }

        public void execute(Runnable task, long delayMillis) {
            this.mExecutor.execute(task, delayMillis);
        }

        public void execute(Runnable task, long delayMillis, int priority) {
            this.mExecutor.execute(task, delayMillis, priority);
        }

        public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis) {
            this.mExecutor.execute(task, callbackInMainThread, delayMillis);
        }

        public void execute(Runnable task, Runnable callbackInMainThread, long delayMillis, int priority) {
            this.mExecutor.execute(task, callbackInMainThread, delayMillis, priority);
        }

        public void removeTask(Runnable task) {
            this.mExecutor.removeTask(task);
        }
    }
}

