/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.general.innerpresenter;

import android.app.Activity;
import android.view.ViewGroup;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ToastUtils;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.bean.ChannelDetailInfo;
import com.yy.hiyo.channel.base.bean.MyChannelControlConfig;
import com.yy.hiyo.channel.base.service.IChannel;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.base.service.IRoleService;
import com.yy.hiyo.channel.base.service.intercepter.IMediaIntercepter;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.context.BaseChannelPresenter;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.context.IHolderPresenter;
import com.yy.hiyo.channel.component.seat.SeatPresenter;
import com.yy.hiyo.channel.component.seat.bean.SeatItem;
import com.yy.hiyo.channel.plugins.general.R;
import com.yy.hiyo.channel.plugins.general.innerpresenter.IVoiceCallPresenter;
import com.yy.hiyo.channel.plugins.general.innerpresenter.VoiceCallPresenter;
import com.yy.hiyo.channel.plugins.general.seat.VoiceChatSeatPresenter;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.OpenVoiceChatReq;
import net.ihago.channel.srv.mgr.OpenVoiceChatRes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000k\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006*\u0001\u0012\u0018\u0000 +2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u00012\u00020\u00042\u00020\u0005:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u0018H\u0002J\u0012\u0010\u001b\u001a\u00020\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u001c\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010#\u001a\u00020\u0018H\u0016J\"\u0010$\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0015H\u0016J\b\u0010(\u001a\u00020\u0018H\u0002J\u0010\u0010)\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010*\u001a\u00020\u0018H\u0002R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/yy/hiyo/channel/plugins/general/innerpresenter/VoiceCallPresenter;", "Lcom/yy/hiyo/channel/cbase/context/BaseChannelPresenter;", "Lcom/yy/hiyo/channel/cbase/AbsPage;", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "Lcom/yy/hiyo/channel/plugins/general/innerpresenter/IVoiceCallPresenter;", "Lcom/yy/hiyo/channel/cbase/context/IHolderPresenter;", "()V", "container", "Lcom/yy/appbase/ui/widget/YYPlaceHolderView;", "contentView", "Landroid/view/ViewGroup;", "hasCheckMyRole", "", "hasCheckPermission", "hasPermission", "icState", "Lcom/yy/base/imageloader/view/RecycleImageView;", "mSeatObs", "com/yy/hiyo/channel/plugins/general/innerpresenter/VoiceCallPresenter$mSeatObs$1", "Lcom/yy/hiyo/channel/plugins/general/innerpresenter/VoiceCallPresenter$mSeatObs$1;", "myRole", "", "seatState", "checkHasPermissionFromNet", "", "checkHasSeat", "checkMyRole", "clickVoiceChat", "handledCallBack", "Ljava/lang/Runnable;", "onDataUpdate", "channelId", "", "info", "Lcom/yy/hiyo/channel/base/bean/ChannelDetailInfo;", "onDestroy", "onRoleChanged", "uid", "", "roleType", "openVoiceChat", "setContainer", "updateSeatState", "Companion", "general_release"})
public final class VoiceCallPresenter
extends BaseChannelPresenter<AbsPage, IChannelPageContext<AbsPage>>
implements IVoiceCallPresenter,
IHolderPresenter {
    private RecycleImageView icState;
    private YYPlaceHolderView container;
    private ViewGroup contentView;
    private boolean hasCheckPermission;
    private boolean hasPermission;
    private int seatState;
    private int myRole = -1;
    private boolean hasCheckMyRole;
    private final mSeatObs.1 mSeatObs = new Observer<List<? extends SeatItem>>(this){
        final /* synthetic */ VoiceCallPresenter this$0;

        public void onChanged(@Nullable List<? extends SeatItem> t) {
            if (t != null) {
                Collection collection = t;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    VoiceCallPresenter.access$setHasCheckPermission$p(this.this$0, true);
                    VoiceCallPresenter.access$setHasPermission$p(this.this$0, true);
                }
            }
            VoiceCallPresenter.access$checkHasPermissionFromNet(this.this$0);
            VoiceCallPresenter.access$updateSeatState(this.this$0);
        }
        {
            this.this$0 = $outer;
        }
    };
    @NotNull
    public static final String TAG = "VoiceCallPresenter";
    public static final int STATE_NOT_VALID = 0;
    public static final int STATE_STARTABLE = 1;
    public static final int STATE_CAN_NOT_OPEN = 2;
    public static final Companion Companion = new Companion(null);

    private final void updateSeatState() {
        boolean hasUserInSeat;
        if (!this.hasPermission || this.isDestroyed()) {
            return;
        }
        boolean isInSeat = this.getChannel().getSeatService().isInSeat(AccountUtil.getUid());
        int chatMode = this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo.openVoiceChatMode;
        int n = isInSeat ? 0 : ((hasUserInSeat = this.getChannel().getSeatService().hasUserInSeat()) ? 0 : (this.hasCheckMyRole ? (this.myRole == 15 || this.myRole == 10 ? 1 : (chatMode == 1 && this.myRole == 5 ? 1 : 2)) : 0));
        this.seatState = n;
        ViewGroup viewGroup = this.contentView;
        if (viewGroup != null) {
            viewGroup.setVisibility(0);
        }
        switch (this.seatState) {
            case 0: {
                ViewGroup viewGroup2 = this.contentView;
                if (viewGroup2 != null) {
                    viewGroup2.setVisibility(4);
                }
                break;
            }
            case 1: 
            case 2: {
                ImageLoader.loadImage((RecycleImageView)this.icState, (int)R.drawable.icon_voice_call_star);
            }
        }
    }

    public void setContainer(@NotNull YYPlaceHolderView container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        IHolderPresenter.DefaultImpls.setContainer((IHolderPresenter)this, (YYPlaceHolderView)container);
        this.container = container;
        this.checkMyRole();
        this.checkHasSeat();
    }

    private final void checkMyRole() {
        this.getChannel().getRoleService().getMyRole(new IRoleService.IGetRoleCallBack(this){
            final /* synthetic */ VoiceCallPresenter this$0;

            public void onSuccess(@Nullable String channelId, int roleType) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"VoiceCallPresenter", (String)("getMyRole success, channelId:" + channelId + ", roleType:" + roleType), (Object[])new Object[0]);
                }
                VoiceCallPresenter.access$setMyRole$p(this.this$0, roleType);
                VoiceCallPresenter.access$setHasCheckMyRole$p(this.this$0, true);
                VoiceCallPresenter.access$updateSeatState(this.this$0);
            }

            public void onError(@Nullable String channelId, int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                MLog.error((Object)"VoiceCallPresenter", (String)("getMyRole error!!! channelId:" + channelId + ", code:" + errorCode + ", msg:" + errorTips + ", e:" + e), (Object[])new Object[0]);
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final void checkHasSeat() {
        LiveData seats = ((VoiceChatSeatPresenter)this.getPresenter(VoiceChatSeatPresenter.class)).seats();
        if (seats != null && seats.getValue() != null) {
            Object object = seats.getValue();
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (((List)object).isEmpty()) {
                this.hasCheckPermission = true;
                this.hasPermission = true;
            }
        }
        seats.observe((LifecycleOwner)((IChannelPageContext)this.getMvpContext()).getLifecycleOwner(), (Observer)this.mSeatObs);
        this.checkHasPermissionFromNet();
        this.updateSeatState();
    }

    private final void checkHasPermissionFromNet() {
        block1: {
            if (this.hasPermission || this.isDestroyed()) {
                return;
            }
            IServiceManager iServiceManager = ServiceManagerProxy.getServiceManager();
            if (iServiceManager == null || (iServiceManager = (IChannelCenterService)iServiceManager.getService(IChannelCenterService.class)) == null) break block1;
            iServiceManager.getControlConfig(new IChannelCenterService.IGetControlConfigCallBack(this){
                final /* synthetic */ VoiceCallPresenter this$0;

                public void onSuccess(@Nullable MyChannelControlConfig controlConfig) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)"VoiceCallPresenter", (String)("checkHasPermissionFromNet success:" + controlConfig), (Object[])new Object[0]);
                    }
                    if (this.this$0.isDestroyed()) {
                        MLog.error((Object)"VoiceCallPresenter", (String)"has destroy!!!", (Object[])new Object[0]);
                        return;
                    }
                    VoiceCallPresenter.access$setHasCheckPermission$p(this.this$0, true);
                    MyChannelControlConfig myChannelControlConfig = controlConfig;
                    if (myChannelControlConfig != null) {
                        if (myChannelControlConfig.canOpenVoiceChat) {
                            VoiceCallPresenter.access$setHasPermission$p(this.this$0, true);
                        }
                    }
                    VoiceCallPresenter.access$updateSeatState(this.this$0);
                }

                public void onError(int errorCode, @Nullable String errorTips, @Nullable Exception e) {
                    MLog.error((Object)"VoiceCallPresenter", (String)("checkHasPermissionFromNet fail:" + errorCode + ", msg:" + errorTips), (Object[])new Object[0]);
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
    }

    private final void openVoiceChat() {
        IEnteredChannel iEnteredChannel = ((IChannelPageContext)this.getMvpContext()).getChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)iEnteredChannel, (String)"mvpContext.channel");
        String channelId = iEnteredChannel.getChannelId();
        OpenVoiceChatReq req = new OpenVoiceChatReq.Builder().cid(channelId).build();
        ProtoManager.getInstance().sendRpc(channelId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<OpenVoiceChatRes>("openvoicechat"){

            public void onResponse(@NotNull OpenVoiceChatRes message, long code, @NotNull String msg) {
                Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
                Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
                super.onResponse((AndroidMessage)message, code, msg);
            }
        });
    }

    @Override
    public void clickVoiceChat(@Nullable Runnable handledCallBack) {
        switch (this.seatState) {
            case 1: {
                if (this.getChannel().getMediaService().getMediaIntercepter() != null) {
                    IMediaIntercepter iMediaIntercepter = this.getChannel().getMediaService().getMediaIntercepter();
                    if (iMediaIntercepter == null) {
                        Intrinsics.throwNpe();
                    }
                    iMediaIntercepter.tryOpenVoiceChat(false, (IChannel)this.getChannel(), new Runnable(this, handledCallBack){
                        final /* synthetic */ VoiceCallPresenter this$0;
                        final /* synthetic */ Runnable $handledCallBack;

                        public final void run() {
                            block0: {
                                VoiceCallPresenter.access$openVoiceChat(this.this$0);
                                Runnable runnable = this.$handledCallBack;
                                if (runnable == null) break block0;
                                runnable.run();
                            }
                        }
                        {
                            this.this$0 = voiceCallPresenter;
                            this.$handledCallBack = runnable;
                        }
                    }, (Runnable)clickVoiceChat.2.INSTANCE);
                } else {
                    Runnable runnable = handledCallBack;
                    if (runnable != null) {
                        runnable.run();
                    }
                    this.openVoiceChat();
                }
                ChannelTrack.INSTANCE.onVoiceCallClick();
                break;
            }
            case 2: {
                Runnable runnable = handledCallBack;
                if (runnable != null) {
                    runnable.run();
                }
                MLog.error((Object)TAG, (String)("STATE_CAN_NOT_OPEN not allow role:" + this.myRole + ", uid:" + AccountUtil.getUid()), (Object[])new Object[0]);
                int chatMode = this.getChannel().getDataService().getChannelDetailInfo(null).baseInfo.openVoiceChatMode;
                int toast = R.string.tips_manager_can_open_voice_call;
                if (chatMode == 1) {
                    toast = R.string.tips_member_can_open_voice_call;
                }
                ToastUtils.showToast((Activity)((Activity)((IChannelPageContext)this.getMvpContext()).getContext()), (int)toast, (int)1);
                break;
            }
            case 0: {
                Runnable runnable = handledCallBack;
                if (runnable != null) {
                    runnable.run();
                }
                MLog.error((Object)TAG, (String)"not valid ", (Object[])new Object[0]);
            }
        }
    }

    public void onRoleChanged(@Nullable String channelId, long uid, int roleType) {
        super.onRoleChanged(channelId, uid, roleType);
        if (uid == AccountUtil.getUid()) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)("on my role change role:" + roleType), (Object[])new Object[0]);
            }
            this.myRole = roleType;
            this.hasCheckMyRole = true;
            this.checkHasPermissionFromNet();
            this.updateSeatState();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        ((SeatPresenter)this.getPresenter(SeatPresenter.class)).seats().removeObserver((Observer)this.mSeatObs);
    }

    public void onDataUpdate(@Nullable String channelId, @Nullable ChannelDetailInfo info) {
        super.onDataUpdate(channelId, info);
        this.updateSeatState();
    }

    public static final /* synthetic */ int access$getMyRole$p(VoiceCallPresenter $this) {
        return $this.myRole;
    }

    public static final /* synthetic */ void access$setMyRole$p(VoiceCallPresenter $this, int n) {
        $this.myRole = n;
    }

    public static final /* synthetic */ boolean access$getHasCheckMyRole$p(VoiceCallPresenter $this) {
        return $this.hasCheckMyRole;
    }

    public static final /* synthetic */ void access$setHasCheckMyRole$p(VoiceCallPresenter $this, boolean bl) {
        $this.hasCheckMyRole = bl;
    }

    public static final /* synthetic */ void access$updateSeatState(VoiceCallPresenter $this) {
        $this.updateSeatState();
    }

    public static final /* synthetic */ boolean access$getHasCheckPermission$p(VoiceCallPresenter $this) {
        return $this.hasCheckPermission;
    }

    public static final /* synthetic */ void access$setHasCheckPermission$p(VoiceCallPresenter $this, boolean bl) {
        $this.hasCheckPermission = bl;
    }

    public static final /* synthetic */ boolean access$getHasPermission$p(VoiceCallPresenter $this) {
        return $this.hasPermission;
    }

    public static final /* synthetic */ void access$setHasPermission$p(VoiceCallPresenter $this, boolean bl) {
        $this.hasPermission = bl;
    }

    public static final /* synthetic */ void access$openVoiceChat(VoiceCallPresenter $this) {
        $this.openVoiceChat();
    }

    public static final /* synthetic */ void access$checkHasPermissionFromNet(VoiceCallPresenter $this) {
        $this.checkHasPermissionFromNet();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/yy/hiyo/channel/plugins/general/innerpresenter/VoiceCallPresenter$Companion;", "", "()V", "STATE_CAN_NOT_OPEN", "", "STATE_NOT_VALID", "STATE_STARTABLE", "TAG", "", "general_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

