/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.yy.appbase.R;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.gamemode.GameLabel;

public class GameLabelView
extends YYRelativeLayout {
    private static final String TAG = "GameLabelView";
    private YYTextView mTvLabel;

    public GameLabelView(Context context) {
        this(context, null);
    }

    public GameLabelView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GameLabelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.createView(context);
    }

    private void createView(Context ctx) {
        GameLabelView.inflate((Context)ctx, (int)R.layout.game_label, (ViewGroup)this);
        this.mTvLabel = (YYTextView)this.findViewById(R.id.tv_label_text);
    }

    public void setGameLabel(GameLabel gameLabel) {
        if (gameLabel != null && gameLabel.isLebalValid()) {
            this.mTvLabel.setVisibility(0);
            if (TextUtils.isEmpty((CharSequence)gameLabel.text)) {
                this.mTvLabel.setText((CharSequence)"");
            } else {
                this.mTvLabel.setText((CharSequence)StringUtils.format((String)"%s ", (Object[])new Object[]{gameLabel.text}));
            }
            try {
                int color = ColorUtils.getCardBgColor((String)gameLabel.textColor);
                this.mTvLabel.setTextColor(color);
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (String)"setGameLabel %s", (Throwable)e, (Object[])new Object[]{gameLabel});
            }
            if (!TextUtils.isEmpty((CharSequence)gameLabel.bgUrl)) {
                this.mTvLabel.setVisibility(0);
                int bitmapWidth = ScreenUtils.getInstance().getWidthPixels() / 3;
                ImageLoader.loadBitmap((Context)this.getContext(), (String)gameLabel.bgUrl, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                        GameLabelView.this.mTvLabel.setVisibility(8);
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        GameLabelView.this.mTvLabel.setBackgroundDrawable((Drawable)new BitmapDrawable(GameLabelView.this.getResources(), bitmap));
                    }
                }, (int)bitmapWidth, (int)bitmapWidth);
            } else {
                this.mTvLabel.setVisibility(8);
            }
        } else {
            this.mTvLabel.setVisibility(8);
        }
    }
}

