/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.singlegame.indie;

import com.yy.hiyo.game.base.singlegame.indie.GameAction;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;

public final class IndieGamePlayContext
extends GamePlayContext {
    private String payload;
    private GameAction gameAction;

    private IndieGamePlayContext(Builder builder) {
        super(builder.joinFrom);
        this.mFrom = builder.joinFrom;
        this.payload = builder.payload;
        this.roomId = builder.roomId;
        this.gameAction = builder.gameAction;
    }

    public String getPayload() {
        return this.payload;
    }

    public GameAction getGameAction() {
        return this.gameAction;
    }

    public static class Builder {
        private final GameContextDef.JoinFrom joinFrom;
        private String roomId;
        private String payload;
        private GameAction gameAction;

        public Builder(GameContextDef.JoinFrom joinFrom) {
            this.joinFrom = joinFrom;
            this.gameAction = GameAction.getDEFAULT();
        }

        public Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public Builder gameAction(GameAction gameAction) {
            this.gameAction = gameAction;
            return this;
        }

        public IndieGamePlayContext build() {
            return new IndieGamePlayContext(this);
        }
    }
}

