/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.helper;

import android.text.TextUtils;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import okhttp3.Call;

public class ShortUrlUtil {
    private static final String TAG = "ShortUrlUtil";
    private static final int ERR_INPUT_EMPTY = 0;
    private static final int ERR_ENCODE_EXCEPTION = 1;
    private static final int ERR_FETCH_FAIL = 2;

    public static void getShortUrl(final String url, final IGetShortUrl callback) {
        String encodeUrl;
        if (TextUtils.isEmpty((CharSequence)url)) {
            ShortUrlUtil.onErr(url, 0, "", callback);
            return;
        }
        try {
            encodeUrl = URLEncoder.encode(url, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            MLog.error((Object)TAG, (Throwable)e);
            ShortUrlUtil.onErr(url, 2, e.getMessage(), callback);
            return;
        }
        String target = UriProvider.SHORT_URL_SERVICE_URL + encodeUrl;
        HttpUtil.httpReq((String)target, null, (int)1, (INetRespCallback)new INetRespCallback<String>(){

            public void onError(Call call, Exception e, int id2) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)ShortUrlUtil.TAG, (String)("getShortUrl onError: url:" + url), (Object[])new Object[0]);
                }
                ShortUrlUtil.onErr(url, 2, e.getMessage(), callback);
            }

            public void onResponse(String response, BaseResponseBean<String> res, int id2) {
                if (callback != null && res.code == 1) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)ShortUrlUtil.TAG, (String)("onResponse:input:" + url + " response" + (String)res.data), (Object[])new Object[0]);
                    }
                    callback.onSuccess(url, (String)res.data);
                } else {
                    ShortUrlUtil.onErr(url, 2, "res.code = " + res.code, callback);
                }
            }
        });
    }

    private static void onErr(String input, int code, String msg, IGetShortUrl callback) {
        YYTaskExecutor.postToMainThread(() -> {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"err:input:%s,code:%d,msg:%s", (Object[])new Object[]{input, code, msg});
            }
            if (callback != null) {
                callback.onError(input, code, msg);
            }
        });
    }

    public static interface IGetShortUrl {
        public void onSuccess(String var1, String var2);

        public void onError(String var1, int var2, String var3);
    }
}

