/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.helper;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lcom/yy/hiyo/game/base/helper/GameReportV1;", "", "()V", "Companion", "IReporter", "game-base_release"})
public final class GameReportV1 {
    @NotNull
    public static final String LOG_TAG = "GameReportV1";
    private static ConcurrentHashMap<String, String> content;
    private static WeakReference<IReporter> reporter;
    private static long startTime;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        content = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/yy/hiyo/game/base/helper/GameReportV1$IReporter;", "", "report", "", "content", "", "", "game-base_release"})
    public static interface IReporter {
        public void report(@NotNull Map<String, String> var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0016\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u00020\r2\b\b\u0002\u0010\u0010\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J&\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0004J\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0004J&\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004J\u0016\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J\u0016\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u0004J\u0016\u0010$\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u000e\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/yy/hiyo/game/base/helper/GameReportV1$Companion;", "", "()V", "LOG_TAG", "", "content", "Ljava/util/concurrent/ConcurrentHashMap;", "reporter", "Ljava/lang/ref/WeakReference;", "Lcom/yy/hiyo/game/base/helper/GameReportV1$IReporter;", "startTime", "", "appendCommon", "", "gid", "gameVer", "clear", "doReport", "", "newEmpty", "reportCallStartGame", "reportGameDownload", "downloadType", "downloadTime", "downloadResult", "reportGameFirstFrameTime", "startGameTime", "startGameResult", "reportGameStartPlayedTime", "gameReportTime", "gameReportResult", "hasCacheFile", "reportRuntime", "runtimeResult", "reportToken", "tokenResult", "reportUserCancel", "userCancel", "setReport", "rep", "game-base_release"})
    public static final class Companion {
        public final void setReport(@NotNull IReporter rep) {
            Intrinsics.checkParameterIsNotNull((Object)rep, (String)"rep");
            WeakReference weakReference = reporter;
            if (weakReference != null) {
                weakReference.clear();
            }
            reporter = new WeakReference<IReporter>(rep);
        }

        public final void newEmpty(@Nullable String gid, @Nullable String gameVer) {
            MLog.debug((Object)GameReportV1.LOG_TAG, (String)"newEmpty", (Object[])new Object[0]);
            this.clear();
            this.appendCommon(gid, gameVer);
        }

        private final void clear() {
            content = new ConcurrentHashMap();
            startTime = System.currentTimeMillis();
        }

        private final void appendCommon(String gid, String gameVer) {
            Map map = content;
            String string2 = gid;
            if (string2 == null) {
                string2 = "";
            }
            map.put("gameId", string2);
            Map map2 = content;
            String string3 = gameVer;
            if (string3 == null) {
                string3 = "";
            }
            map2.put("gameVersion", string3);
            Map map3 = content;
            String string4 = CommonHttpHeader.getAppVer();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"CommonHttpHeader.getAppVer()");
            map3.put("hagoVersion", string4);
            ((Map)content).put("uid", String.valueOf(AccountUtil.getUid()));
            ((Map)content).put("stage", "downloaded");
            MLog.debug((Object)GameReportV1.LOG_TAG, (String)("content:" + content), (Object[])new Object[0]);
        }

        public final void reportGameDownload(@NotNull String gid, @NotNull String downloadType, long downloadTime, @NotNull String downloadResult) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)downloadType, (String)"downloadType");
            Intrinsics.checkParameterIsNotNull((Object)downloadResult, (String)"downloadResult");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                ((Map)content).put("downloadType", downloadType);
                if (Intrinsics.areEqual((Object)downloadResult, (Object)"0")) {
                    ((Map)content).put("downloadTime", String.valueOf(System.currentTimeMillis() - startTime));
                }
                ((Map)content).put("downloadResult", downloadResult);
                ((Map)content).put("stage", "download");
                MLog.debug((Object)GameReportV1.LOG_TAG, (String)("reportGameDownload " + content), (Object[])new Object[0]);
                this.doReport(false);
                startTime = System.currentTimeMillis();
                content.remove("downloadTime");
                content.remove("downloadResult");
                ((Map)content).put("stage", "downloaded");
            }
        }

        public final void reportToken(@NotNull String gid, @NotNull String tokenResult) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)tokenResult, (String)"tokenResult");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                ((Map)content).put("tokenResult", tokenResult);
                if (Intrinsics.areEqual((Object)tokenResult, (Object)"0")) {
                    ((Map)content).put("tokenTime", String.valueOf(System.currentTimeMillis() - startTime));
                } else {
                    com.yy.hiyo.game.base.helper.GameReportV1$Companion.doReport$default(this, false, 1, null);
                }
            }
        }

        public final void reportRuntime(@NotNull String gid, @NotNull String runtimeResult) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)runtimeResult, (String)"runtimeResult");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                ((Map)content).put("runtimeResult", runtimeResult);
                if (Intrinsics.areEqual((Object)runtimeResult, (Object)"0")) {
                    ((Map)content).put("runtimeTime", String.valueOf(System.currentTimeMillis() - startTime));
                } else {
                    com.yy.hiyo.game.base.helper.GameReportV1$Companion.doReport$default(this, false, 1, null);
                }
            }
        }

        public final void reportCallStartGame(@NotNull String gid) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                ((Map)content).put("callStartGameTime", String.valueOf(System.currentTimeMillis() - startTime));
            }
        }

        public final void reportGameFirstFrameTime(@NotNull String gid, long startGameTime, @NotNull String startGameResult) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)startGameResult, (String)"startGameResult");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                ((Map)content).put("startGameResult", startGameResult);
                if (Intrinsics.areEqual((Object)startGameResult, (Object)"0")) {
                    ((Map)content).put("startGameTime", String.valueOf(System.currentTimeMillis() - startTime));
                } else {
                    com.yy.hiyo.game.base.helper.GameReportV1$Companion.doReport$default(this, false, 1, null);
                }
            }
        }

        public final void reportGameStartPlayedTime(@NotNull String gid, long gameReportTime, @NotNull String gameReportResult, @NotNull String hasCacheFile) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)gameReportResult, (String)"gameReportResult");
            Intrinsics.checkParameterIsNotNull((Object)hasCacheFile, (String)"hasCacheFile");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId")))) {
                if (Intrinsics.areEqual((Object)gameReportResult, (Object)"0")) {
                    ((Map)content).put("gameReportTime", String.valueOf(System.currentTimeMillis() - startTime));
                }
                ((Map)content).put("gameReportResult", gameReportResult);
                if (StringUtils.isNotEmpty((String)hasCacheFile)) {
                    ((Map)content).put("hasCacheFile", hasCacheFile);
                }
                ((Map)content).put("stage", "downloaded");
                com.yy.hiyo.game.base.helper.GameReportV1$Companion.doReport$default(this, false, 1, null);
            }
        }

        public final void reportUserCancel(@NotNull String gid, @NotNull String userCancel) {
            Intrinsics.checkParameterIsNotNull((Object)gid, (String)"gid");
            Intrinsics.checkParameterIsNotNull((Object)userCancel, (String)"userCancel");
            if (Intrinsics.areEqual((Object)gid, (Object)((String)content.get("gameId"))) && Intrinsics.areEqual((Object)userCancel, (Object)"1")) {
                this.newEmpty(gid, (String)content.get("gameVersion"));
                ((Map)content).put("userCancel", userCancel);
                ((Map)content).put("stage", "cancel");
                com.yy.hiyo.game.base.helper.GameReportV1$Companion.doReport$default(this, false, 1, null);
            }
        }

        private final void doReport(boolean clear) {
            Object object;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)GameReportV1.LOG_TAG, (String)("report " + content), (Object[])new Object[0]);
            }
            if ((object = reporter) != null && (object = (IReporter)((Reference)object).get()) != null) {
                object.report(content);
            }
            if (clear) {
                this.clear();
            }
        }

        static /* synthetic */ void doReport$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = true;
            }
            companion.doReport(bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

