/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.gamemode;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.yy.hiyo.game.base.gamemode.GameModeInfo;
import java.util.List;

public class MultiModeInfo
implements Parcelable {
    @SerializedName(value="imBgUrl")
    private String imBgUrl;
    @SerializedName(value="matchBgUrl")
    private String matchBgUrl;
    @SerializedName(value="bgColor")
    private String bgColor;
    @SerializedName(value="modeList")
    private List<GameModeInfo> modeList;
    public static final Parcelable.Creator<MultiModeInfo> CREATOR = new Parcelable.Creator<MultiModeInfo>(){

        public MultiModeInfo createFromParcel(Parcel in) {
            return new MultiModeInfo(in);
        }

        public MultiModeInfo[] newArray(int size) {
            return new MultiModeInfo[size];
        }
    };

    public MultiModeInfo() {
    }

    protected MultiModeInfo(Parcel in) {
        this.imBgUrl = in.readString();
        this.matchBgUrl = in.readString();
        this.bgColor = in.readString();
        this.modeList = in.createTypedArrayList(GameModeInfo.CREATOR);
    }

    public GameModeInfo findModeById(int id2) {
        if (this.modeList == null) {
            return null;
        }
        for (GameModeInfo mode : this.modeList) {
            if (mode == null || mode.getId() != id2) continue;
            return mode;
        }
        return null;
    }

    public GameModeInfo findAvailModeById(int id2) {
        if (this.modeList == null) {
            return null;
        }
        GameModeInfo findMode = null;
        GameModeInfo firstAvailMode = null;
        for (GameModeInfo mode : this.modeList) {
            if (mode != null && mode.getId() == id2 && mode.isAvail()) {
                findMode = mode;
                break;
            }
            if (mode == null || firstAvailMode != null || !mode.isAvail()) continue;
            firstAvailMode = mode;
        }
        return findMode != null ? findMode : firstAvailMode;
    }

    public String getImBgUrl() {
        return this.imBgUrl;
    }

    public void setImBgUrl(String imBgUrl) {
        this.imBgUrl = imBgUrl;
    }

    public String getMatchBgUrl() {
        return this.matchBgUrl;
    }

    public void setMatchBgUrl(String matchBgUrl) {
        this.matchBgUrl = matchBgUrl;
    }

    public List<GameModeInfo> getModeList() {
        return this.modeList;
    }

    public void setModeList(List<GameModeInfo> modeList) {
        this.modeList = modeList;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setBgColor(String bgColor) {
        this.bgColor = bgColor;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.imBgUrl);
        dest.writeString(this.matchBgUrl);
        dest.writeString(this.bgColor);
        dest.writeTypedList(this.modeList);
    }
}

