/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.config;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.config.GameCommonConfigData;
import org.json.JSONException;
import org.json.JSONObject;

public class GameCommonConfig
extends AConfigData {
    public static final int OPEN_SEPARATETHREAD = 1;
    private static final String KEY_SEPARATETHREAD = "separatethread";
    private static final String KEY_V8FLAGS = "v8flags";
    private static JSONObject sData;
    public GameCommonConfigData mGameCommonConfigData = null;

    public BssCode getBssCode() {
        return BssCode.GAME_COMMON_CONFIG;
    }

    public GameCommonConfigData getData() {
        return this.mGameCommonConfigData;
    }

    public void parseConfig(final String configs) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameCommonConfig.parseConfigInner(configs);
                try {
                    GameCommonConfig.this.mGameCommonConfigData = (GameCommonConfigData)JsonParser.parseJsonObject((String)configs, GameCommonConfigData.class);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static synchronized void parseConfigInner(String configs) {
        if (StringUtils.isEmpty((String)configs)) {
            sData = null;
        } else {
            try {
                sData = JsonParser.obtainJSONObject((String)configs);
            }
            catch (JSONException e) {
                MLog.error((Object)"GameWebSockectConfig", (Throwable)e);
            }
        }
    }

    public static synchronized boolean getSeparatethreadOpen(String gameId) {
        try {
            int type;
            JSONObject item;
            if (sData != null && StringUtils.isNotEmpty((String)gameId) && sData.has(gameId) && (item = sData.getJSONObject(gameId)) != null && item.has(KEY_SEPARATETHREAD) && (type = item.getInt(KEY_SEPARATETHREAD)) == 1) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"getSeparatethreadOpen", (String)"game:%s configType:%d", (Object[])new Object[]{gameId, type});
                }
                return true;
            }
        }
        catch (Exception e) {
            MLog.error((Object)"getSeparatethreadOpen", (Throwable)e);
        }
        return false;
    }

    public static synchronized String getV8flag(String gameId) {
        try {
            JSONObject item;
            if (sData != null && StringUtils.isNotEmpty((String)gameId) && sData.has(gameId) && (item = sData.getJSONObject(gameId)) != null && item.has(KEY_V8FLAGS)) {
                return item.getString(KEY_V8FLAGS);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"getV8flag", (Throwable)e);
        }
        return "";
    }
}

