/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.base.bean;

import android.text.TextUtils;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameInfoSource;
import com.yy.hiyo.game.base.bean.GamePatchInfo;

public abstract class BasicGameInfo {
    public String gid;
    protected String modulerUrl;
    protected String modulerMd5;
    protected String modulerVer;
    protected boolean moduleGray;
    protected long minCompatibleVer;
    public final GameInfoSource fromSource;
    public final GameDownloadInfo downloadInfo = new GameDownloadInfo();
    public final GamePatchInfo patchInfo = new GamePatchInfo();
    public int waitDownloadGames = -1;

    public BasicGameInfo(GameInfoSource fromSource) {
        this.fromSource = fromSource;
    }

    public String getGid() {
        return this.gid;
    }

    public String getModulerUrl() {
        return this.modulerUrl;
    }

    public String getModulerMd5() {
        return this.modulerMd5;
    }

    public String getModulerVer() {
        return this.modulerVer;
    }

    public boolean isModuleGray() {
        return this.moduleGray;
    }

    @Deprecated
    public void setModulerVer(String version) {
        if (StringUtils.equal((String)version, (String)this.modulerVer)) {
            return;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"GameInfo", (String)"setModulerVer gameId: %s,  change version: %s, old version: %s", (Object[])new Object[]{this.gid, version, this.modulerVer});
        }
        if (StringUtils.isAllDigits((String)version)) {
            this.modulerVer = version;
        }
    }

    public long getMinCompatibleVer() {
        return this.minCompatibleVer;
    }

    public void setMinCompatibleVer(long minCompatibleVer) {
        this.minCompatibleVer = minCompatibleVer;
    }

    public boolean isGameIdEquals(GameInfo other) {
        boolean ret = false;
        if (other != null && !TextUtils.isEmpty((CharSequence)this.gid)) {
            ret = this.gid.equals(other.getGid());
        }
        return ret;
    }
}

