/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.game.audio;

import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.config.AudioTypes;
import com.yy.appbase.config.BossConfigService;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IBossConfigService;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.game.audio.AudioPathUtils;
import com.yy.hiyo.game.audio.AudioRepository;
import com.yy.hiyo.game.audio.Mp3PlayHelper;
import com.yy.hiyo.game.audio.PKGameAudioInfo;
import com.yy.hiyo.game.service.IGameAudioService;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class PKGameAudioManager
extends DefaultController
implements IGameAudioService {
    private static final String TAG = "PKGameAudioManager";
    private static final int AUDIO_CONFIG_VERSION = 2;
    private Queue<PKGameAudioInfo> mAudioQueues = new LinkedList<PKGameAudioInfo>();
    private Map<String, PKGameAudioInfo> mPKGameAudioConfig = new Hashtable<String, PKGameAudioInfo>();
    private String mCurrentQueueAudioId;
    private String mCurrentBgmAudioId;
    private LongSparseArray<Mp3PlayHelper> mAllAudioChannel = new LongSparseArray();
    private boolean mAudiosHasChecked = false;
    private IShouldPlay mIShouldPlay = new IShouldPlay(){

        @Override
        public boolean shouldPlay(String key) {
            return true;
        }
    };

    public PKGameAudioManager(Environment env) {
        super(env);
        NotificationCenter.getGlobalInstance().register(NotificationIdDef.AUDIO_PLAY_CONPLETE, (INotify)this);
    }

    @Override
    public void getAudioConfig() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (this.mAudiosHasChecked) {
            return;
        }
        this.mAudiosHasChecked = true;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getAudioConfig", (Object[])new Object[0]);
        }
        ((IBossConfigService)this.getServiceManager().getService(IBossConfigService.class)).getBossConfig("soundConfig", (BossConfigService.ConfigCallback)new BossConfigService.ConfigCallback<Map<String, PKGameAudioInfo>>(){

            public void onSuccess(final Map<String, PKGameAudioInfo> response) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)PKGameAudioManager.TAG, (String)"getAudioConfig", (Object[])new Object[0]);
                }
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        PKGameAudioManager.this.handlerAudioConfig(response);
                    }
                });
            }

            public void onError(Exception e) {
                MLog.error((Object)PKGameAudioManager.TAG, (String)"getAudioConfig OnError", (Throwable)e, (Object[])new Object[0]);
            }
        });
    }

    private void handlerAudioConfig(Map<String, PKGameAudioInfo> response) {
        this.mPKGameAudioConfig.clear();
        if (FP.empty(response)) {
            return;
        }
        for (String audioTag : response.keySet()) {
            PKGameAudioInfo audioInfo = response.get(audioTag);
            if (audioInfo == null || audioInfo.minVersion > 2) continue;
            this.mPKGameAudioConfig.put(audioTag, audioInfo);
            if (this.isBgm(audioTag)) {
                audioInfo.isInQueue = false;
                audioInfo.audioChannel = 1;
                audioInfo.isLoop = true;
            }
            if (this.isOtherAudio(audioTag)) {
                audioInfo.isInQueue = false;
                audioInfo.audioChannel = 3;
                audioInfo.isLoop = false;
                audioInfo.volume = 1.0f;
            }
            if (this.isGameResultAudio(audioTag)) {
                audioInfo.volume = 0.8f;
            }
            if (this.isMicUpAudio(audioTag)) {
                audioInfo.volume = 1.0f;
            }
            if (!audioTag.equals("negativeProp") && !audioTag.equals("positionProp")) continue;
            audioInfo.playTiming = 1;
        }
        this.downloadPKGameAudio(this.mPKGameAudioConfig, AudioPathUtils.AUDIO_CACHE_DIR);
    }

    private void downloadPKGameAudio(final Map<String, PKGameAudioInfo> audioConfig, final String cacheDir) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PKGameAudioManager.this.downloadPKGameAudioAsync(audioConfig, cacheDir);
            }
        });
    }

    private void downloadPKGameAudioAsync(Map<String, PKGameAudioInfo> theAudics, final String cacheDir) {
        final HashMap<String, PKGameAudioInfo> audioConfig = new HashMap<String, PKGameAudioInfo>(theAudics);
        if (FP.empty(audioConfig)) {
            return;
        }
        try {
            Set keys = audioConfig.keySet();
            if (keys == null || keys.size() <= 0) {
                return;
            }
            ArrayList keyArray = new ArrayList(keys);
            final String key = (String)keyArray.get(0);
            final PKGameAudioInfo audioInfo = (PKGameAudioInfo)audioConfig.get(key);
            audioConfig.remove(keyArray.get(0));
            if (audioInfo == null || StringUtils.isEmpty((String)audioInfo.url)) {
                this.downloadPKGameAudioAsync(audioConfig, cacheDir);
                return;
            }
            audioInfo.key = key;
            if (AudioRepository.getInstance().chekAudioDownload(audioInfo)) {
                if (!MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)"downloadPKGameAudio audio had downloaded, key: %s", (Object[])new Object[]{key});
                }
                audioInfo.filePath = AudioPathUtils.getAudioCachePathByUrl(audioInfo.url);
                this.downloadPKGameAudioAsync(audioConfig, cacheDir);
                return;
            }
            final String url = audioInfo.url;
            final String fileName = AudioPathUtils.getFileNameByAudioUrl(url);
            Downloader.Builder builder = new Downloader.Builder(url, cacheDir, fileName);
            builder.setSupportContinueTransfer(true);
            builder.setTaskGroup(DownloadBussinessGroup.GAME_VOICE);
            builder.setCallBack(new IDownloadCallback(){

                public void onComplete(Downloader downloader) {
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)PKGameAudioManager.TAG, (String)"downloadGameAsync onComplete downloader: %s,  fullPath: %s, url: %s", (Object[])new Object[]{downloader, cacheDir, url});
                    }
                    audioInfo.filePath = cacheDir + File.separator + fileName;
                    audioInfo.key = key;
                    PKGameAudioManager.this.downloadPKGameAudioAsync(audioConfig, cacheDir);
                }

                public void onError(Downloader downloader, int errorType, String errorInfo) {
                    MLog.error((Object)PKGameAudioManager.TAG, (String)"downloadGameAsync onError downloader: %s, fullPath: %s, url: %s, errorType: %s, errorInfo: %s", (Object[])new Object[]{downloader, cacheDir, url, errorType, errorInfo});
                    PKGameAudioManager.this.downloadPKGameAudioAsync(audioConfig, cacheDir);
                }

                public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                }

                public void onStart(Downloader downloader) {
                    if (!MLog.isLogLevelAboveDebug()) {
                        MLog.debug((Object)PKGameAudioManager.TAG, (String)"downloadGameAsync onStart downloader: %s, fullPath: %s, url: %s", (Object[])new Object[]{downloader, cacheDir, url});
                    }
                }
            });
            Downloader downloader = builder.build();
            downloader.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"downloadPKGameAudio error", (Throwable)e, (Object[])new Object[0]);
        }
    }

    @Override
    public void initURLAudio(String url) {
        this.initURLAudio(url, false);
    }

    @Override
    public void initURLAudio(String url, boolean isLoop) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"initURLAudio url: %s, isLoop: %b", (Object[])new Object[]{url, isLoop});
        }
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        PKGameAudioInfo cacheConfig = this.mPKGameAudioConfig.get(url);
        if (cacheConfig != null && url.equals(cacheConfig.url)) {
            return;
        }
        String key = url.hashCode() + "";
        PKGameAudioInfo pkGameAudioInfo = new PKGameAudioInfo();
        pkGameAudioInfo.key = key;
        pkGameAudioInfo.isInQueue = false;
        pkGameAudioInfo.isLoop = isLoop;
        pkGameAudioInfo.audioChannel = 3;
        pkGameAudioInfo.url = url;
        pkGameAudioInfo.playTiming = 2;
        Hashtable<String, PKGameAudioInfo> audioInfoMap = new Hashtable<String, PKGameAudioInfo>();
        audioInfoMap.put(key, pkGameAudioInfo);
        this.mPKGameAudioConfig.putAll(audioInfoMap);
        this.downloadPKGameAudio(audioInfoMap, AudioPathUtils.URL_AUDIO_CACHE_DIR);
    }

    @Override
    public void playOtherUrlAudio(String url) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"playOtherUrlAudio url: %s", (Object[])new Object[]{url});
        }
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        this.play(url.hashCode() + "");
    }

    @Override
    public void stopOtherUrlAudio(String url) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopOtherUrlAudio url: %s", (Object[])new Object[]{url});
        }
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        this.stopAudio(url.hashCode() + "");
    }

    @Override
    public void play(String key) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"play audio key: %s, current bgm: %s, current queue: %s", (Object[])new Object[]{key, this.mCurrentBgmAudioId, this.mCurrentQueueAudioId});
        }
        if (this.isBgm(key) && !StringUtils.isEmpty((String)key) && key.equals(this.mCurrentBgmAudioId)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"play the same bgm", (Object[])new Object[0]);
            }
            return;
        }
        this.playWithAudioInfo(this.getAudioInfoByKey(key));
    }

    @Override
    public void stopAudio(String key) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stop audio key: %s, current bgm: %s, current queue: %s", (Object[])new Object[]{key, this.mCurrentBgmAudioId, this.mCurrentQueueAudioId});
        }
        if (!StringUtils.isEmpty((String)key) && key.equals(this.mCurrentBgmAudioId)) {
            this.stopCurrentChannelAudio(key);
            this.mCurrentBgmAudioId = null;
        } else {
            this.stopQueueAudio(key);
        }
    }

    @Override
    public void stopAllAudio() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"stopAllAudio", (Object[])new Object[0]);
        }
        this.mCurrentBgmAudioId = null;
        this.mCurrentQueueAudioId = null;
        this.stopAllQueueAudio();
        this.stopAllAudioChannel();
    }

    @Override
    public void stopAllQueueAudio() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"stopAllQueueAudio", (Object[])new Object[0]);
        }
        this.clearAudioQueue();
        Mp3PlayHelper.getInstance().stopPlayers();
    }

    private boolean isBgm(String key) {
        for (String s : AudioTypes.PKGameBgmAudio) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isOtherAudio(String key) {
        for (String s : AudioTypes.PKGameOtherAudio) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isGameResultAudio(String key) {
        for (String s : AudioTypes.PkGameResultAudio) {
            if (!s.equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean isMicUpAudio(String audioTag) {
        for (String s : AudioTypes.MicUpAudio) {
            if (!s.equals(audioTag)) continue;
            return true;
        }
        return false;
    }

    private void playWithAudioInfo(PKGameAudioInfo audioInfo) {
        this.playAudio(audioInfo, this.mIShouldPlay);
    }

    private void playAudio(final PKGameAudioInfo pkGameAudioInfo, IShouldPlay shouldPlay) {
        if (pkGameAudioInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"[playAudio] with empty audio info", (Object[])new Object[0]);
            }
            return;
        }
        String path = this.getPathByAudioInfo(pkGameAudioInfo);
        if (StringUtils.isEmpty((String)path)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"[playAudio] path is null, audioInfo: %s.", (Object[])new Object[]{pkGameAudioInfo.key});
            }
            return;
        }
        if (shouldPlay != null && !shouldPlay.shouldPlay(pkGameAudioInfo.key)) {
            this.playNextAudio();
            return;
        }
        Mp3PlayHelper audioPlayer = this.getAudioChannelByInfo(pkGameAudioInfo);
        if (audioPlayer == null) {
            MLog.error((Object)TAG, (String)"audio player is null", (Object[])new Object[0]);
            return;
        }
        if (!pkGameAudioInfo.isInQueue) {
            float volume = 0.2f;
            if (this.isOtherAudio(pkGameAudioInfo.key)) {
                volume = pkGameAudioInfo.volume;
            }
            audioPlayer.stopPlayers();
            audioPlayer.playMp3WithPath(path, volume, false, null, pkGameAudioInfo.isLoop);
            this.mCurrentBgmAudioId = pkGameAudioInfo.key;
            return;
        }
        switch (pkGameAudioInfo.playTiming) {
            case 2: {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)TAG, (String)"[playAudio] play audio right now, path:%s", (Object[])new Object[]{path});
                }
                this.mAudioQueues.clear();
                Mp3PlayHelper.getInstance().stopPlayers();
                Mp3PlayHelper.getInstance().playMp3WithPath(path, pkGameAudioInfo.volume, true);
                this.mCurrentQueueAudioId = pkGameAudioInfo.key;
                break;
            }
            case 1: {
                Mp3PlayHelper.getInstance().isPlaying(new Mp3PlayHelper.IAudioPlayFlagCallBack(){

                    @Override
                    public void onPlayCallBack(final boolean isPlaying) {
                        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                            public void run() {
                                if (!isPlaying) {
                                    Mp3PlayHelper.getInstance().stopPlayers();
                                    if (MLog.isLogLevelBlowInfo()) {
                                        MLog.info((Object)PKGameAudioManager.TAG, (String)"[playAudio] play queue audio, key:%s, path:%s", (Object[])new Object[]{pkGameAudioInfo.key, pkGameAudioInfo.filePath});
                                    }
                                    Mp3PlayHelper.getInstance().playMp3WithPath(pkGameAudioInfo.filePath, 0.6f, true);
                                    PKGameAudioManager.this.mCurrentQueueAudioId = pkGameAudioInfo.key;
                                } else {
                                    PKGameAudioManager.this.mAudioQueues.offer(pkGameAudioInfo);
                                }
                            }
                        });
                    }
                });
                break;
            }
        }
    }

    private void playNextAudio() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"[playNextAudio]", (Object[])new Object[0]);
        }
        if (this.mAudioQueues.isEmpty()) {
            return;
        }
        PKGameAudioInfo audioInfo = this.mAudioQueues.poll();
        if (audioInfo == null) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"[onAudioComplete] the queue is null.", (Object[])new Object[0]);
            }
            return;
        }
        this.playWithAudioInfo(audioInfo);
    }

    private void stopQueueAudio(String audioTag) {
        if (StringUtils.isEmpty((String)audioTag)) {
            MLog.error((Object)TAG, (String)"[stopQueueAudio] empty tag", (Object[])new Object[0]);
            return;
        }
        if (!StringUtils.isEmpty((String)this.mCurrentQueueAudioId) && audioTag.equals(this.mCurrentQueueAudioId)) {
            this.stopCurrentChannelAudio(audioTag);
            this.mCurrentQueueAudioId = null;
        }
        ArrayList<PKGameAudioInfo> removeAudios = new ArrayList<PKGameAudioInfo>();
        if (this.mAudioQueues != null) {
            for (PKGameAudioInfo audioInfo : this.mAudioQueues) {
                if (!audioTag.equals(audioInfo.key)) continue;
                removeAudios.add(audioInfo);
            }
            this.mAudioQueues.removeAll(removeAudios);
        }
        this.playNextAudio();
    }

    private void stopCurrentChannelAudio(String audioTag) {
        Mp3PlayHelper mp3PlayHelper = this.getAudioChannelByInfo(this.getAudioInfoByKey(audioTag));
        if (mp3PlayHelper != null) {
            mp3PlayHelper.stopPlayers();
        }
    }

    private void stopAllAudioChannel() {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"stopAllAudioChannel", (Object[])new Object[0]);
        }
        if (this.mAllAudioChannel != null && this.mAllAudioChannel.size() != 0) {
            for (int i = 0; i < this.mAllAudioChannel.size(); ++i) {
                Mp3PlayHelper mp3PlayHelper = (Mp3PlayHelper)this.mAllAudioChannel.valueAt(i);
                if (mp3PlayHelper == null) continue;
                mp3PlayHelper.stopPlayers();
            }
        }
    }

    public void clearAudioQueue() {
        this.mAudioQueues.clear();
    }

    @Nullable
    private String getPathByAudioInfo(PKGameAudioInfo audioInfo) {
        if (audioInfo == null) {
            MLog.error((Object)TAG, (String)"[getPathByAudioInfo] find no audio path", (Object[])new Object[0]);
            return null;
        }
        if (!StringUtils.isEmpty((String)audioInfo.filePath)) {
            if (!MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)TAG, (String)"[getPathByAudioInfo] key: %s, uri: %s", (Object[])new Object[]{audioInfo.key, audioInfo.filePath});
            }
            return audioInfo.filePath;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[getPathByAudioInfo] key: %s, uri: %s", (Object[])new Object[]{audioInfo.key, audioInfo.url});
        }
        return audioInfo.url;
    }

    @Nullable
    private Mp3PlayHelper getAudioChannelByKey(String key) {
        PKGameAudioInfo gameAudioInfo = this.getAudioInfoByKey(key);
        return this.getAudioChannelByInfo(gameAudioInfo);
    }

    @Nullable
    private Mp3PlayHelper getAudioChannelByInfo(PKGameAudioInfo audioInfo) {
        if (audioInfo == null) {
            return null;
        }
        switch (audioInfo.audioChannel) {
            case 1: {
                audioInfo.isInQueue = false;
                this.mAllAudioChannel.put((long)Mp3PlayHelper.getSecondInstance().hashCode(), (Object)Mp3PlayHelper.getSecondInstance());
                return Mp3PlayHelper.getSecondInstance();
            }
            case 3: {
                audioInfo.isInQueue = false;
                this.mAllAudioChannel.put((long)Mp3PlayHelper.getThirdInstance().hashCode(), (Object)Mp3PlayHelper.getThirdInstance());
                return Mp3PlayHelper.getThirdInstance();
            }
            case 2: {
                this.mAllAudioChannel.put((long)Mp3PlayHelper.getInstance().hashCode(), (Object)Mp3PlayHelper.getInstance());
                return Mp3PlayHelper.getInstance();
            }
        }
        this.mAllAudioChannel.put((long)Mp3PlayHelper.getInstance().hashCode(), (Object)Mp3PlayHelper.getInstance());
        return Mp3PlayHelper.getInstance();
    }

    @Nullable
    public PKGameAudioInfo getAudioInfoByKey(String key) {
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)"[getAudioInfoByKey] key: %s", (Object[])new Object[]{key});
        }
        return this.mPKGameAudioConfig.get(key);
    }

    public void notify(Notification notification) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"notify notificationId: %d", (Object[])new Object[]{notification.id});
        }
        if (NotificationIdDef.AUDIO_PLAY_CONPLETE == notification.id) {
            this.playNextAudio();
        }
    }

    static interface IShouldPlay {
        public boolean shouldPlay(String var1);
    }
}

