/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.taskexecutor.single;

import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.NamedThreadFactory;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class YYProxySingleThreadPoolExecutor
extends ThreadPoolExecutor {
    private static final String TAG = "YYProxySingleThread";
    private String tag;
    private ThreadFactory defaultThreadFactory;
    private IQueueTaskExecutor queueTaskExecutor;
    private static RejectedExecutionHandler sHandler = new RejectedExecutionHandler(){

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        }
    };

    public YYProxySingleThreadPoolExecutor(String tag) {
        this(new NamedThreadFactory(TAG + tag), tag);
    }

    public void setUseWorkPriority(boolean useWorkPriority) {
        this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter(useWorkPriority);
    }

    public YYProxySingleThreadPoolExecutor(ThreadFactory threadFactory, String tag) {
        super(1, 1, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory, sHandler);
        this.defaultThreadFactory = threadFactory;
        this.tag = tag;
        this.queueTaskExecutor = YYTaskExecutor.createAQueueExcuter();
    }

    @Override
    public void shutdown() {
        MLog.info(TAG, "tag:%s, shutdown!", this.tag);
        if (this.queueTaskExecutor != null) {
            this.queueTaskExecutor.removeAllTask();
        }
        this.queueTaskExecutor = null;
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        MLog.info(TAG, "tag:%s, shutdown!", this.tag);
        if (this.queueTaskExecutor != null) {
            super.shutdown();
            ArrayList<Runnable> result = this.queueTaskExecutor.removeAllTask();
            this.queueTaskExecutor = null;
            return result;
        }
        return super.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return super.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return super.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        MLog.info(TAG, "tag:%s, awaitTermination!", this.tag);
        return super.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit task:%s!", this.tag, task);
        }
        return super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit2 task:%s!", this.tag, task);
        }
        return super.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (SystemUtils.isShowEnvSetting()) {
            MLog.info(TAG, "tag:%s, submit3 task:%s!", this.tag, task);
        }
        return super.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAll1!", this.tag);
        return super.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAll2!", this.tag);
        return super.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException, InterruptedException {
        MLog.info(TAG, "tag:%s, invokeAny1!", this.tag);
        return super.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        MLog.info(TAG, "tag:%s, invokeAny2!", this.tag);
        return super.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.queueTaskExecutor != null) {
            this.queueTaskExecutor.execute(command, 0L);
        }
    }
}

