/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.database.Cursor;
import com.yy.base.logger.MLog;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public final class IOUtils {
    public static int readShort(byte[] aSrcArray, int aOffset) {
        return (aSrcArray[aOffset] & 0xFF) << 8 | aSrcArray[aOffset + 1] & 0xFF;
    }

    public static void writeShort(byte[] aDestArray, int aOffset, short aValue) {
        aDestArray[aOffset] = (byte)(aValue >> 8 & 0xFF);
        aDestArray[aOffset + 1] = (byte)(aValue >> 0 & 0xFF);
    }

    public static int readInt(byte[] aSrcArray, int aOffset) {
        return ((aSrcArray[aOffset] & 0xFF) << 24) + ((aSrcArray[aOffset + 1] & 0xFF) << 16) + ((aSrcArray[aOffset + 2] & 0xFF) << 8) + ((aSrcArray[aOffset + 3] & 0xFF) << 0);
    }

    public static void writeInt(byte[] aDestArray, int aOffset, int aValue) {
        aDestArray[aOffset] = (byte)(aValue >> 24 & 0xFF);
        aDestArray[aOffset + 1] = (byte)(aValue >> 16 & 0xFF);
        aDestArray[aOffset + 2] = (byte)(aValue >> 8 & 0xFF);
        aDestArray[aOffset + 3] = (byte)(aValue >> 0 & 0xFF);
    }

    public static long readLong(byte[] aSrcArray, int aOffset) {
        return ((long)(aSrcArray[aOffset] & 0xFF) << 56) + ((long)(aSrcArray[aOffset + 1] & 0xFF) << 48) + ((long)(aSrcArray[aOffset + 2] & 0xFF) << 40) + ((long)(aSrcArray[aOffset + 3] & 0xFF) << 32) + ((long)(aSrcArray[aOffset + 4] & 0xFF) << 24) + ((long)(aSrcArray[aOffset + 5] & 0xFF) << 16) + ((long)(aSrcArray[aOffset + 6] & 0xFF) << 8) + ((long)(aSrcArray[aOffset + 7] & 0xFF) << 0);
    }

    public static void writeLong(byte[] aDestArray, int aOffset, long aValue) {
        aDestArray[aOffset + 0] = (byte)(aValue >>> 56);
        aDestArray[aOffset + 1] = (byte)(aValue >>> 48);
        aDestArray[aOffset + 2] = (byte)(aValue >>> 40);
        aDestArray[aOffset + 3] = (byte)(aValue >>> 32);
        aDestArray[aOffset + 4] = (byte)(aValue >>> 24);
        aDestArray[aOffset + 5] = (byte)(aValue >>> 16);
        aDestArray[aOffset + 6] = (byte)(aValue >>> 8);
        aDestArray[aOffset + 7] = (byte)(aValue >>> 0);
    }

    public static byte[] readUTFBytes(DataInput aInput) throws IOException {
        int sUtfLength = aInput.readUnsignedShort();
        byte[] sByteArray = new byte[sUtfLength];
        aInput.readFully(sByteArray, 0, sUtfLength);
        return sByteArray;
    }

    public static void writeUTFBytes(DataOutputStream aOutput, byte[] aSrcArray) throws Exception {
        if (aSrcArray != null) {
            aOutput.writeShort(aSrcArray.length);
            aOutput.write(aSrcArray, 0, aSrcArray.length);
        } else {
            aOutput.writeShort(0);
        }
    }

    public static byte[] readBytes(InputStream aInput, int aReadLength, int aBufferLength) throws IOException {
        if (aInput == null || aReadLength <= 0) {
            return null;
        }
        byte[] sData = new byte[aReadLength];
        if (aBufferLength <= 0) {
            aBufferLength = 2048;
        }
        int sLength = 0;
        for (int i = 0; i < aReadLength && (sLength = aReadLength - i < aBufferLength ? aInput.read(sData, i, aReadLength - i) : aInput.read(sData, i, aBufferLength)) != -1; i += sLength) {
        }
        return sData;
    }

    public static byte[] readBytesEx(InputStream aInput, int aReadLength, int aBufferLength) throws IOException, OutOfMemoryError {
        if (aInput == null) {
            return null;
        }
        if (aBufferLength <= 0) {
            aBufferLength = 2048;
        }
        if (aReadLength <= 0) {
            aReadLength = 1024;
            ByteArrayOutputStream sBos = new ByteArrayOutputStream(aReadLength);
            byte[] sBuffer = new byte[aBufferLength];
            int sPos = 0;
            while ((sPos = aInput.read(sBuffer, 0, aBufferLength)) != -1) {
                sBos.write(sBuffer, 0, sPos);
            }
            byte[] sBytesArray = sBos.toByteArray();
            sBos.close();
            sBos = null;
            return sBytesArray;
        }
        return IOUtils.readBytes(aInput, aReadLength, aBufferLength);
    }

    public static int readIntFormCharArray(char[] aSrcArray, int aOffset) {
        return ((aSrcArray[aOffset] & 0xFFFF) << 16) + (aSrcArray[aOffset + 1] & 0xFFFF);
    }

    public static void writeInt2CharArray(char[] aSrcArray, int aOffset, int aValue) {
        aSrcArray[aOffset] = (char)(aValue >> 16 & 0xFFFF);
        aSrcArray[aOffset + 1] = (char)(aValue & 0xFFFF);
    }

    public static void writeUTFBytes(byte[] aDestArray, int aOffset, byte[] aSrcUTFBytes) {
        if (aSrcUTFBytes == null) {
            IOUtils.writeShort(aDestArray, aOffset, (short)0);
        } else {
            IOUtils.writeShort(aDestArray, aOffset, (short)aSrcUTFBytes.length);
            System.arraycopy(aSrcUTFBytes, 0, aDestArray, aOffset + 2, aSrcUTFBytes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readByteArrayFromInputStream(InputStream aInputStream) {
        byte[] res = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int len = 0;
            int size = 4096;
            byte[] buf = new byte[size];
            while ((len = aInputStream.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            res = bos.toByteArray();
        }
        catch (IOException e) {
            MLog.processSilentException(e);
        }
        finally {
            IOUtils.safeClose(bos);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFullBytes(InputStream input) {
        if (input == null) {
            return null;
        }
        if (!(input instanceof BufferedInputStream)) {
            input = new BufferedInputStream(input);
        }
        byte[] inputStreamBuffer = new byte[32768];
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        try {
            int offset = 0;
            while ((offset = input.read(inputStreamBuffer, 0, inputStreamBuffer.length)) > 0) {
                baos.write(inputStreamBuffer, 0, offset);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            MLog.processSilentException(e);
        }
        finally {
            IOUtils.safeClose(baos);
            baos = null;
        }
        return null;
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                MLog.processSilentException(e);
            }
        }
    }

    public static void safeClose(Cursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
            }
            catch (Exception e) {
                MLog.processSilentException(e);
            }
        }
    }
}

