/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.StringUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class URLUtils {
    private static final String TAG = "URLUtils";
    public static volatile IUrlHandler sUrlHandler = null;

    public static String encode(String s) {
        return Uri.encode((String)s);
    }

    public static String urlEncoderEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "urlEncoderEncode", e, new Object[0]);
            return url;
        }
    }

    public static String urlDecoderDecode(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            MLog.error((Object)TAG, "urlEncoderEncode", e, new Object[0]);
            return url;
        }
    }

    @NonNull
    public static Map<String, String> getParams(@NonNull Uri uri) {
        Set keys = uri.getQueryParameterNames();
        HashMap<String, String> params = new HashMap<String, String>(FP.size(keys));
        for (String item : keys) {
            String value;
            if (FP.empty(item) || FP.empty(value = uri.getQueryParameter(item))) continue;
            params.put(item, value);
        }
        return params;
    }

    public static String addParam(String originUrl, String key, String value) {
        try {
            Uri.Builder builder = Uri.parse((String)originUrl).buildUpon();
            builder.appendQueryParameter(key, value);
            return builder.toString();
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return originUrl;
        }
    }

    public static String addParams(String originUrl, Map<String, String> params) {
        if (FP.empty(params)) {
            return originUrl;
        }
        try {
            Uri.Builder builder = Uri.parse((String)originUrl).buildUpon();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                builder.appendQueryParameter(entry.getKey(), entry.getValue());
            }
            return builder.toString();
        }
        catch (Exception e) {
            MLog.error(TAG, e);
            return originUrl;
        }
    }

    public static boolean isHttpScheme(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        Uri uri = Uri.parse((String)url);
        return uri != null && StringUtils.equalsIgnoreCase(uri.getScheme(), "http");
    }

    public static boolean isHttpsScheme(String url) {
        if (StringUtils.isEmpty(url)) {
            return false;
        }
        Uri uri = Uri.parse((String)url);
        return uri != null && StringUtils.equalsIgnoreCase(uri.getScheme(), "https");
    }

    public static String replaceHttpToHttps(String url) {
        return StringUtils.isNotEmpty(url) ? url.replaceFirst("http://", "https://") : url;
    }

    public static String replaceHttpsToHttp(String url) {
        return StringUtils.isNotEmpty(url) ? url.replaceFirst("https://", "http://") : url;
    }

    public static String getDomainName(@Nullable String url) {
        URI uri = null;
        try {
            int index = url.indexOf("?");
            if (index > 0) {
                url = url.substring(0, index);
            }
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (uri != null && uri.getHost() != null) {
            return uri.getHost();
        }
        return "";
    }

    public static boolean isOurHost(String host) {
        if (StringUtils.isEmpty(host)) {
            return false;
        }
        IUrlHandler handler = sUrlHandler;
        if (handler == null) {
            return false;
        }
        return handler.isOurHost(host);
    }

    public static boolean isOurHostByUrl(String url) {
        return sUrlHandler.isOurHostByUrl(url);
    }

    public static String replaceUrl(String url) {
        return sUrlHandler.replaceUrl(url);
    }

    public static String replaceUrl(String url, String hostOfUrl) {
        return sUrlHandler.replaceUrl(url, hostOfUrl);
    }

    public static String replaceHostSuffix(String hostSuffix) {
        return sUrlHandler.replaceHostSuffix(hostSuffix);
    }

    public static String replaceHttpByConfig(String url) {
        return sUrlHandler.replaceHttpByConfig(url);
    }

    public static String replaceHttpByConfig(String url, String hostOfUrl) {
        return sUrlHandler.replaceHttpByConfig(url, hostOfUrl);
    }

    public static String replaceHost(String host) {
        return sUrlHandler.replaceHost(host);
    }

    public static List<String> getOurFirstHostSuffixList() {
        return sUrlHandler.getOurFirstHostSuffixList();
    }

    public static void setUrlHandler(IUrlHandler urlHandler) {
        sUrlHandler = urlHandler;
    }

    public static interface IUrlHandler {
        public boolean isOurHost(String var1);

        public boolean isOurHostByUrl(String var1);

        public String replaceUrl(String var1);

        public String replaceUrl(String var1, String var2);

        public String replaceHost(String var1);

        public String replaceHostSuffix(String var1);

        public String replaceHttpByConfig(String var1);

        public String replaceHttpByConfig(String var1, String var2);

        public List<String> getOurFirstHostSuffixList();
    }
}

