/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.utils;

import com.yy.base.logger.MLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestUtils {
    private static final String CHAR_SET = "UTF-8";
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private static byte[] digest(MessageDigest digest, InputStream data) throws IOException {
        return DigestUtils.updateDigest(digest, data).digest();
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static MessageDigest getMd5Digest() {
        return DigestUtils.getDigest("MD5");
    }

    public static MessageDigest getSha1Digest() {
        return DigestUtils.getDigest("SHA1");
    }

    public static byte[] md5(byte[] data) {
        return DigestUtils.getMd5Digest().digest(data);
    }

    public static byte[] md5(InputStream data) throws IOException {
        return DigestUtils.digest(DigestUtils.getMd5Digest(), data);
    }

    public static byte[] md5(String data) throws UnsupportedEncodingException {
        return DigestUtils.md5(data.getBytes(CHAR_SET));
    }

    public static String md5Hex(byte[] data) {
        return DigestUtils.encodeHexString(DigestUtils.md5(data));
    }

    public static String md5Hex(InputStream data) throws IOException {
        return DigestUtils.encodeHexString(DigestUtils.md5(data));
    }

    public static String md5Hex(String data) throws UnsupportedEncodingException {
        return DigestUtils.encodeHexString(DigestUtils.md5(data));
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, byte[] valueToDigest) {
        messageDigest.update(valueToDigest);
        return messageDigest;
    }

    public static MessageDigest updateDigest(MessageDigest digest, InputStream data) throws IOException {
        byte[] buffer = new byte[1024];
        int read = data.read(buffer, 0, 1024);
        while (read > -1) {
            digest.update(buffer, 0, read);
            read = data.read(buffer, 0, 1024);
        }
        return digest;
    }

    public static MessageDigest updateDigest(MessageDigest messageDigest, String valueToDigest) throws UnsupportedEncodingException {
        messageDigest.update(valueToDigest.getBytes(CHAR_SET));
        return messageDigest;
    }

    public static char[] encodeHex(byte[] data) {
        return DigestUtils.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return DigestUtils.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    public static String encodeHexString(byte[] data) {
        return new String(DigestUtils.encodeHex(data));
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char c0 = DIGITS_LOWER[(bt & 0xF0) >> 4];
        char c1 = DIGITS_LOWER[bt & 0xF];
        stringbuffer.append(c0);
        stringbuffer.append(c1);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            DigestUtils.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    public static String bufferToHex(byte[] bytes) {
        return DigestUtils.bufferToHex(bytes, 0, bytes.length);
    }

    public static String sha1(String data) {
        String encodeData = null;
        MessageDigest md = DigestUtils.getSha1Digest();
        byte[] d = null;
        try {
            d = md.digest(data.getBytes(CHAR_SET));
            encodeData = DigestUtils.bufferToHex(d);
        }
        catch (UnsupportedEncodingException e) {
            MLog.processSilentException(e);
        }
        return encodeData;
    }
}

