/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.thread;

import android.os.Handler;
import android.os.SystemClock;
import com.yy.base.logger.MLog;

public class JBlockRunnable
implements Runnable {
    private final Runnable mTask;
    private boolean mDone;

    public JBlockRunnable(Runnable task) {
        this.mTask = task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.mTask.run();
        }
        finally {
            JBlockRunnable jBlockRunnable = this;
            synchronized (jBlockRunnable) {
                this.mDone = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postAndWait(Handler handler, long timeout) {
        if (!handler.post((Runnable)this)) {
            return false;
        }
        JBlockRunnable jBlockRunnable = this;
        synchronized (jBlockRunnable) {
            if (timeout > 0L) {
                long expirationTime = SystemClock.uptimeMillis() + timeout;
                try {
                    while (!this.mDone) {
                        long delay = expirationTime - SystemClock.uptimeMillis();
                        if (delay <= 0L) {
                            return false;
                        }
                        this.wait(delay);
                    }
                }
                catch (InterruptedException ex) {
                    MLog.error((Object)this, "postAndWait error : " + ex.toString(), new Object[0]);
                }
            } else {
                try {
                    while (!this.mDone) {
                        this.wait();
                    }
                }
                catch (InterruptedException ex) {
                    MLog.error((Object)this, "postAndWait error : " + ex.toString(), new Object[0]);
                }
            }
        }
        return true;
    }
}

