/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.imageloader.webpanim.decoder;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.ResourceDecoder;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import com.yy.base.imageloader.webpanim.WebpHeaderParser;
import com.yy.base.imageloader.webpanim.decoder.Utils;
import com.yy.base.imageloader.webpanim.decoder.WebpDrawable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StreamWebpDecoder
implements ResourceDecoder<InputStream, WebpDrawable> {
    public static final Option<Boolean> DISABLE_ANIMATION = Option.memory("com.yy.base.imageloader.webpanim.decoder.StreamWebpDecoder.DisableAnimation", false);
    private final ResourceDecoder<ByteBuffer, WebpDrawable> byteBufferDecoder;
    private final ArrayPool byteArrayPool;

    public StreamWebpDecoder(ResourceDecoder<ByteBuffer, WebpDrawable> byteBufferDecoder, ArrayPool byteArrayPool) {
        this.byteBufferDecoder = byteBufferDecoder;
        this.byteArrayPool = byteArrayPool;
    }

    @Override
    public boolean handles(@NonNull InputStream inputStream, @NonNull Options options) throws IOException {
        if (options.get(DISABLE_ANIMATION).booleanValue()) {
            return false;
        }
        WebpHeaderParser.WebpImageType webpType = WebpHeaderParser.getType(inputStream, this.byteArrayPool);
        return WebpHeaderParser.isAnimatedWebpType(webpType);
    }

    @Override
    @Nullable
    public Resource<WebpDrawable> decode(@NonNull InputStream inputStream, int width, int height, @NonNull Options options) throws IOException {
        byte[] data = Utils.inputStreamToBytes(inputStream);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.byteBufferDecoder.decode(byteBuffer, width, height, options);
    }
}

