/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine;

import androidx.annotation.NonNull;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.util.Preconditions;

class EngineResource<Z>
implements Resource<Z> {
    private final boolean isCacheable;
    private final boolean isRecyclable;
    private final Resource<Z> resource;
    private ResourceListener listener;
    private Key key;
    private int acquired;
    private boolean isRecycled;

    EngineResource(Resource<Z> toWrap, boolean isCacheable, boolean isRecyclable) {
        this.resource = Preconditions.checkNotNull(toWrap);
        this.isCacheable = isCacheable;
        this.isRecyclable = isRecyclable;
    }

    synchronized void setResourceListener(Key key, ResourceListener listener) {
        this.key = key;
        this.listener = listener;
    }

    Resource<Z> getResource() {
        return this.resource;
    }

    boolean isCacheable() {
        return this.isCacheable;
    }

    @Override
    @NonNull
    public Class<Z> getResourceClass() {
        return this.resource.getResourceClass();
    }

    @Override
    @NonNull
    public Z get() {
        return this.resource.get();
    }

    @Override
    public int getSize() {
        return this.resource.getSize();
    }

    @Override
    public synchronized void recycle() {
        if (this.acquired > 0) {
            throw new IllegalStateException("Cannot recycle a resource while it is still acquired");
        }
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot recycle a resource that has already been recycled");
        }
        this.isRecycled = true;
        if (this.isRecyclable) {
            this.resource.recycle();
        }
    }

    synchronized void acquire() {
        if (this.isRecycled) {
            throw new IllegalStateException("Cannot acquire a recycled resource");
        }
        ++this.acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release() {
        try {
            ResourceListener resourceListener = this.listener;
            synchronized (resourceListener) {
                EngineResource engineResource = this;
                synchronized (engineResource) {
                    if (this.acquired <= 0) {
                        throw new IllegalStateException("Cannot release a recycled or not yet acquired resource");
                    }
                    if (--this.acquired == 0) {
                        this.listener.onResourceReleased(this.key, this);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized String toString() {
        return "EngineResource{isCacheable=" + this.isCacheable + ", listener=" + this.listener + ", key=" + this.key + ", acquired=" + this.acquired + ", isRecycled=" + this.isRecycled + ", resource=" + this.resource + '}';
    }

    static interface ResourceListener {
        public void onResourceReleased(Key var1, EngineResource<?> var2);
    }
}

