/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.memoryrecycle.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageButton;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.drawablerecycle.DrawableRecycler;
import com.yy.base.memoryrecycle.views.IImageRecycleView;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.memoryrecycle.views.ViewSetTagRunnable;

public class YYImageButton
extends ImageButton
implements IImageRecycleView {
    private boolean mIsAttachToWindow;

    public YYImageButton(Context context) {
        super(context);
        this.logCreate();
    }

    public YYImageButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    public YYImageButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.logCreate();
        DrawableRecycler.onAttributesUpdated(context, this, attrs);
    }

    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        DrawableRecycler.onVisibilityChanged(this, visibility);
    }

    protected void onAttachedToWindow() {
        this.mIsAttachToWindow = true;
        super.onAttachedToWindow();
        DrawableRecycler.onAttachedToWindow(this);
    }

    protected void onDetachedFromWindow() {
        this.mIsAttachToWindow = false;
        super.onDetachedFromWindow();
        DrawableRecycler.onDetachedFromWindow(this);
    }

    public void setBackgroundDrawable(Drawable background) {
        super.setBackgroundDrawable(background);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, background);
    }

    public void setBackgroundResource(int resid) {
        super.setBackgroundResource(resid);
        DrawableRecycler.onBackgroundUpdated((IRecycleView)this, resid);
    }

    public void setImageDrawable(Drawable drawable2) {
        super.setImageDrawable(drawable2);
        DrawableRecycler.onImageUpdated((IRecycleView)this, drawable2);
    }

    public void setImageResource(int resid) {
        super.setImageResource(resid);
        DrawableRecycler.onImageUpdated((IRecycleView)this, resid);
    }

    public Drawable getDrawable() {
        DrawableRecycler.onGetDrawable(this);
        Drawable drawable2 = super.getDrawable();
        DrawableRecycler.onGetDrawableEnd(this);
        return drawable2;
    }

    public Drawable getBackground() {
        DrawableRecycler.onGetBackground(this);
        Drawable drawable2 = super.getBackground();
        DrawableRecycler.onGetBackgroundEnd(this);
        return drawable2;
    }

    @Override
    public void setImageDrawableToNull() {
        super.setImageDrawable(null);
    }

    @Override
    public void setBackgroundToNull() {
        super.setBackgroundDrawable(null);
    }

    @Override
    public Drawable getBackgroundInner() {
        return super.getBackground();
    }

    @Override
    public boolean isAttachToWindow() {
        return this.mIsAttachToWindow;
    }

    @Override
    public boolean closeAutoRecycleDrawables() {
        return false;
    }

    @Override
    public Drawable getImageDrawableInner() {
        return super.getDrawable();
    }

    public void setTag(int key, Object tag) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            super.setTag(key, tag);
        } else {
            this.post(new ViewSetTagRunnable((View)this, key, tag));
        }
    }

    public Object getTag(int key) {
        try {
            return super.getTag(key);
        }
        catch (Exception e) {
            MLog.error("YYImageButton", e);
            return null;
        }
    }
}

