/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.request;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import androidx.annotation.CheckResult;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Option;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.DownsampleStrategy;
import com.bumptech.glide.request.BaseRequestOptions;

public class RequestOptions
extends BaseRequestOptions<RequestOptions> {
    @Nullable
    private static RequestOptions skipMemoryCacheTrueOptions;
    @Nullable
    private static RequestOptions skipMemoryCacheFalseOptions;
    @Nullable
    private static RequestOptions fitCenterOptions;
    @Nullable
    private static RequestOptions centerInsideOptions;
    @Nullable
    private static RequestOptions centerCropOptions;
    @Nullable
    private static RequestOptions circleCropOptions;
    @Nullable
    private static RequestOptions noTransformOptions;
    @Nullable
    private static RequestOptions noAnimationOptions;

    @NonNull
    @CheckResult
    public static RequestOptions sizeMultiplierOf(@FloatRange(from=0.0, to=1.0) float sizeMultiplier) {
        return (RequestOptions)new RequestOptions().sizeMultiplier(sizeMultiplier);
    }

    @NonNull
    @CheckResult
    public static RequestOptions diskCacheStrategyOf(@NonNull DiskCacheStrategy diskCacheStrategy) {
        return (RequestOptions)new RequestOptions().diskCacheStrategy(diskCacheStrategy);
    }

    @NonNull
    @CheckResult
    public static RequestOptions priorityOf(@NonNull Priority priority) {
        return (RequestOptions)new RequestOptions().priority(priority);
    }

    @NonNull
    @CheckResult
    public static RequestOptions placeholderOf(@Nullable Drawable placeholder) {
        return (RequestOptions)new RequestOptions().placeholder(placeholder);
    }

    @NonNull
    @CheckResult
    public static RequestOptions placeholderOf(@DrawableRes int placeholderId) {
        return (RequestOptions)new RequestOptions().placeholder(placeholderId);
    }

    @NonNull
    @CheckResult
    public static RequestOptions errorOf(@Nullable Drawable errorDrawable) {
        return (RequestOptions)new RequestOptions().error(errorDrawable);
    }

    @NonNull
    @CheckResult
    public static RequestOptions errorOf(@DrawableRes int errorId) {
        return (RequestOptions)new RequestOptions().error(errorId);
    }

    @NonNull
    @CheckResult
    public static RequestOptions skipMemoryCacheOf(boolean skipMemoryCache) {
        if (skipMemoryCache) {
            if (skipMemoryCacheTrueOptions == null) {
                skipMemoryCacheTrueOptions = (RequestOptions)((RequestOptions)new RequestOptions().skipMemoryCache(true)).autoClone();
            }
            return skipMemoryCacheTrueOptions;
        }
        if (skipMemoryCacheFalseOptions == null) {
            skipMemoryCacheFalseOptions = (RequestOptions)((RequestOptions)new RequestOptions().skipMemoryCache(false)).autoClone();
        }
        return skipMemoryCacheFalseOptions;
    }

    @NonNull
    @CheckResult
    public static RequestOptions overrideOf(@IntRange(from=0L) int width, @IntRange(from=0L) int height) {
        return (RequestOptions)new RequestOptions().override(width, height);
    }

    @NonNull
    @CheckResult
    public static RequestOptions overrideOf(@IntRange(from=0L) int size) {
        return RequestOptions.overrideOf(size, size);
    }

    @NonNull
    @CheckResult
    public static RequestOptions signatureOf(@NonNull Key signature) {
        return (RequestOptions)new RequestOptions().signature(signature);
    }

    @NonNull
    @CheckResult
    public static RequestOptions fitCenterTransform() {
        if (fitCenterOptions == null) {
            fitCenterOptions = (RequestOptions)((RequestOptions)new RequestOptions().fitCenter()).autoClone();
        }
        return fitCenterOptions;
    }

    @NonNull
    @CheckResult
    public static RequestOptions centerInsideTransform() {
        if (centerInsideOptions == null) {
            centerInsideOptions = (RequestOptions)((RequestOptions)new RequestOptions().centerInside()).autoClone();
        }
        return centerInsideOptions;
    }

    @NonNull
    @CheckResult
    public static RequestOptions centerCropTransform() {
        if (centerCropOptions == null) {
            centerCropOptions = (RequestOptions)((RequestOptions)new RequestOptions().centerCrop()).autoClone();
        }
        return centerCropOptions;
    }

    @NonNull
    @CheckResult
    public static RequestOptions circleCropTransform() {
        if (circleCropOptions == null) {
            circleCropOptions = (RequestOptions)((RequestOptions)new RequestOptions().circleCrop()).autoClone();
        }
        return circleCropOptions;
    }

    @NonNull
    @CheckResult
    public static RequestOptions bitmapTransform(@NonNull Transformation<Bitmap> transformation) {
        return (RequestOptions)new RequestOptions().transform(transformation);
    }

    @NonNull
    @CheckResult
    public static RequestOptions noTransformation() {
        if (noTransformOptions == null) {
            noTransformOptions = (RequestOptions)((RequestOptions)new RequestOptions().dontTransform()).autoClone();
        }
        return noTransformOptions;
    }

    @NonNull
    @CheckResult
    public static <T> RequestOptions option(@NonNull Option<T> option, @NonNull T value) {
        return (RequestOptions)new RequestOptions().set(option, value);
    }

    @NonNull
    @CheckResult
    public static RequestOptions decodeTypeOf(@NonNull Class<?> resourceClass) {
        return (RequestOptions)new RequestOptions().decode(resourceClass);
    }

    @NonNull
    @CheckResult
    public static RequestOptions formatOf(@NonNull DecodeFormat format) {
        return (RequestOptions)new RequestOptions().format(format);
    }

    @NonNull
    @CheckResult
    public static RequestOptions frameOf(@IntRange(from=0L) long frameTimeMicros) {
        return (RequestOptions)new RequestOptions().frame(frameTimeMicros);
    }

    @NonNull
    @CheckResult
    public static RequestOptions downsampleOf(@NonNull DownsampleStrategy strategy) {
        return (RequestOptions)new RequestOptions().downsample(strategy);
    }

    @NonNull
    @CheckResult
    public static RequestOptions timeoutOf(@IntRange(from=0L) int timeout) {
        return (RequestOptions)new RequestOptions().timeout(timeout);
    }

    @NonNull
    @CheckResult
    public static RequestOptions encodeQualityOf(@IntRange(from=0L, to=100L) int quality) {
        return (RequestOptions)new RequestOptions().encodeQuality(quality);
    }

    @NonNull
    @CheckResult
    public static RequestOptions encodeFormatOf(@NonNull Bitmap.CompressFormat format) {
        return (RequestOptions)new RequestOptions().encodeFormat(format);
    }

    @NonNull
    @CheckResult
    public static RequestOptions noAnimation() {
        if (noAnimationOptions == null) {
            noAnimationOptions = (RequestOptions)((RequestOptions)new RequestOptions().dontAnimate()).autoClone();
        }
        return noAnimationOptions;
    }
}

