/*
 * Decompiled with CFR 0.152.
 */
package com.yy.base.crash;

import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ThrowUtils;
import java.util.concurrent.ConcurrentHashMap;

public class CrashMonitor {
    private static final String TAG = "CrashMonitor";
    private static ITryCatchChecker sTryCatchChecker;
    private static final ConcurrentHashMap<String, Long> sCrashTime;

    public static boolean tryCatch(Object cls, String id2, Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        try {
            runnable.run();
        }
        catch (Throwable e) {
            return CrashMonitor.tryCatch(cls, id2, e);
        }
        return false;
    }

    public static boolean tryCatch(Object cls, String id2, Throwable e) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            return false;
        }
        if (Build.VERSION.SDK_INT < 21 && cls instanceof View && e instanceof StackOverflowError) {
            MLog.error((Object)TAG, "view StackOverflowError happen", e, new Object[0]);
            SettingFlags.setBoolean("home_view_oom_happen", true);
            SettingFlags.commit();
        }
        MLog.processSilentException(cls, e);
        if (sTryCatchChecker == null || !sTryCatchChecker.tryCatch(id2, e)) {
            ThrowUtils.throwException("Crash by className: " + CrashMonitor.className(cls) + ". id: " + id2, e);
        }
        Long last = sCrashTime.get(id2);
        long cur = System.currentTimeMillis();
        sCrashTime.put(id2, cur);
        if (last == null || Math.abs(cur - last) > 20000L) {
            YYTaskExecutor.postToMainThread(() -> {
                try {
                    if (cls instanceof ViewGroup) {
                        ((ViewGroup)cls).invalidate();
                        ((ViewGroup)cls).requestLayout();
                    } else if (cls instanceof View && ((View)cls).getParent() instanceof ViewGroup) {
                        ((ViewGroup)((View)cls).getParent()).invalidate();
                        ((ViewGroup)((View)cls).getParent()).requestLayout();
                    }
                }
                catch (Exception exception) {
                    MLog.error(TAG, exception);
                }
            });
        }
        return true;
    }

    private static String className(Object cls) {
        if (cls == null) {
            return "null";
        }
        String className = cls.getClass().getName();
        if (cls instanceof View) {
            className = className + "(" + ((View)cls).getId() + ")";
        }
        return className;
    }

    public static void setTryCatchChecker(ITryCatchChecker tryCatchChecker) {
        sTryCatchChecker = tryCatchChecker;
    }

    static {
        sCrashTime = new ConcurrentHashMap();
    }

    public static interface ITryCatchChecker {
        public boolean tryCatch(String var1, Throwable var2);
    }
}

